/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkservice;

import com.vmware.sva.bld.AbstractBldInformation;
import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BusinessLogicDomain;
import com.vmware.sva.bld.ft.MasterGenerationInformation;
import com.vmware.sva.common.ReplicaInformation;
import com.vmware.sva.common.SerialGeneration;
import com.vmware.sva.common.StorageClusterConfig;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.common.SvaVersion;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.util.LoggerAdapter;
import com.vmware.sva.util.SvaHelper;
import com.vmware.sva.util.SystemUtils;
import com.vmware.sva.zkservice.BldDomainOnlineEvent;
import com.vmware.sva.zkservice.BldDomainsOnlineChangeEvent;
import com.vmware.sva.zkservice.BldMessagesAvailableEvent;
import com.vmware.sva.zkservice.BldPseudoSvaEvent;
import com.vmware.sva.zkservice.BldReplicaEvent;
import com.vmware.sva.zkservice.BldSvaVersionChangeEvent;
import com.vmware.sva.zkservice.BldTransactionsAvailableEvent;
import com.vmware.sva.zkservice.ZkOfflineException;
import com.vmware.sva.zkservice.ZooKeeperWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZkClient
implements Watcher {
    private static final String LOCALHOST = "127.0.0.1";
    private static final String ZKPORT = ":" + SvaConstants.ZK_CLIENT_PORT;
    private static final String ZK_HEALTH_PATH = "/Health";
    private static final String ZK_ELECTION_PATH = "/Election";
    private static final String ZK_ELECTION_PREFIX = "/replica_";
    private static final String ZK_MESSAGE_QUEUE_PATH = "/Messages";
    private static final String ZK_MESSAGE_PREFIX = "/msg_";
    private static final String ZK_TRANSACTION_LOG_PATH = "/TransactionLog";
    private static final String ZK_TRANSACTIONS_SUBPATH = "/Transactions";
    private static final String ZK_GENERATIONS_SUBPATH = "/Generations";
    private static final String ZK_MASTER_GENERATION_SUBPATH = "/MasterGeneration";
    private static final String ZK_REPLICAS_SUBPATH = "/Replicas";
    private static final String ZK_CLUSTER_CONFIG_PATH = "/ClusterConfiguration";
    private static final String ZK_RECONFIG_NETWORK_FLAG_PATH = "/ClusterConfiguration/ReconfigNetwork";
    private static final String ZK_VERSION_PATH = "/Version";
    private static final String ZK_SVA_VERSION_PATH = "/Version/SVA";
    private static final String ZK_DATA_VERSION_PATH = "/Version/Data";
    private Timer offlineTimer = null;
    private final UUID svaId;
    private final UUID domainId;
    private final String domainName;
    private final List<String> addresses;
    private ZooKeeperWrapper zk;
    private boolean online = false;
    private BldEventWatcher domainOnlineWatcher = null;
    private BldEventWatcher replicaOnlineWatcher = null;
    private BldEventWatcher messageWatcher = null;
    private BldEventWatcher transactionWatcher = null;
    private boolean watchForHealthChange = false;
    private BldEventWatcher svaVersionWatcher = null;
    private String domainElectionPath = null;
    private String msgQueuePath = null;
    private String transactionLogPath = null;
    private String transactionsPath = null;
    private String generationsPath = null;
    private String masterGenerationPath = null;
    private String replicasPath = null;
    private boolean amMaster = false;
    private UUID currentMasterId = null;
    protected static final Logger logger = Logger.getLogger(ZkClient.class.getName());
    private final int OLD_SESSION_EXPIRE_WAITTIME = 1000;

    public ZkClient(UUID svaId, BusinessLogicDomain domain, List<String> addresses) {
        this(svaId, domain.getId(), domain.getName(), addresses);
    }

    public ZkClient(UUID svaId, BusinessLogicDomain domain) {
        this(svaId, domain.getId(), domain.getName(), Collections.singletonList(LOCALHOST));
    }

    public ZkClient(UUID svaId, UUID domainId, String domainName) {
        this(svaId, domainId, domainName, Collections.singletonList(LOCALHOST));
    }

    public ZkClient(UUID svaId, UUID domainId, String domainName, List<String> addresses) {
        this.svaId = svaId;
        this.domainId = domainId;
        this.domainName = domainName;
        this.addresses = new ArrayList<String>(addresses);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (this.zk != null) {
                this.zk.close();
            }
            this.online = false;
        }
    }

    public synchronized boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceOffline(boolean allowReboot) {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (this.online) {
                this.handleOffline(allowReboot);
                this.initialize();
            }
        }
    }

    public void addAddress(String address) {
        this.addresses.add(address);
    }

    public void remAddress(String address) {
        this.addresses.remove(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReplicaOnline(BldEventWatcher watcher) throws Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            logger.log(Level.FINE, "registering for replica online");
            this.replicaOnlineWatcher = watcher;
            if (this.online) {
                this.writeReplicaOnline();
            }
        }
    }

    public synchronized String getSvaVersion(BldEventWatcher watcher) throws Exception {
        logger.log(Level.FINE, "Registering for SVA version");
        String result = this.getSvaVersion(true);
        this.svaVersionWatcher = watcher;
        return result;
    }

    public String getSvaVersion() throws Exception {
        return this.getSvaVersion(false);
    }

    private synchronized String getSvaVersion(boolean watch) throws Exception {
        if (!this.online) {
            throw new ZkOfflineException();
        }
        return (String)BldSerialization.bytesToObject(this.zk.getData(false, ZK_SVA_VERSION_PATH, watch, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() throws Exception {
        assert (!Thread.holdsLock(this));
        logger.log(Level.FINE, "Upgrading ZooKeeper data");
        ArrayList<String> nodes = null;
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            assert (this.amMaster);
            assert (this.compareSvaVersion() < 0) : "SVA version downgrade";
            int compareData = this.compareDataVersion();
            if (compareData != 0) {
                if (compareData > 0) {
                    throw new Exception("Attempt to perform a downgrade of ZooKeeper data");
                }
                nodes = new ArrayList<String>();
                nodes.add("/");
            }
        }
        if (nodes != null) {
            this.upgradeNodes(nodes);
        }
        this.createUpdateMasterGeneration();
        zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            String version = SvaVersion.getVersion();
            this.zk.setData(false, ZK_SVA_VERSION_PATH, BldSerialization.objectToBytes(version), -1);
            logger.log(Level.INFO, "Upgraded ZooKeeper data to SVA version: " + version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeNodes(List<String> nodes) throws Exception {
        ZkClient zkClient;
        assert (!Thread.holdsLock(this));
        int objectCount = 0;
        int upgradeCount = 0;
        while (!nodes.isEmpty()) {
            zkClient = this;
            synchronized (zkClient) {
                if (!this.online) {
                    throw new ZkOfflineException();
                }
                ++objectCount;
                String path = nodes.remove(0);
                try {
                    boolean upgraded = this.zk.upgrade(path);
                    if (upgraded) {
                        ++upgradeCount;
                    }
                    List<String> childrenList = this.zk.getChildren(path, false);
                    Object[] children = childrenList.toArray(new String[childrenList.size()]);
                    Arrays.sort(children);
                    String parent = path;
                    if (!parent.endsWith("/")) {
                        parent = parent + '/';
                    }
                    for (Object child : children) {
                        nodes.add(parent + (String)child);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Problem upgrading object for path: " + path + ", object number: " + objectCount, e);
                    throw e;
                }
            }
        }
        zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            String version = SerialGeneration.getCurrent().getVersionString();
            this.zk.setData(false, ZK_DATA_VERSION_PATH, BldSerialization.objectToBytes(version), -1);
            logger.log(Level.INFO, "Upgraded objects in ZooKeeper nodes to serial version: " + version + ", objects checked: " + objectCount + ", objects upgraded: " + upgradeCount);
        }
    }

    private int compareSvaVersion() throws Exception {
        String current;
        String stored = this.getSvaVersion(false);
        int result = SvaVersion.compareVersions((String)stored, (String)(current = SvaVersion.getVersion()));
        if (result == 0 && SvaDebug.FORCE_UPGRADE) {
            result = -1;
        }
        return result;
    }

    private int compareDataVersion() throws Exception {
        String current;
        String stored = this.getDataVersion();
        int result = SvaVersion.compareVersions((String)stored, (String)(current = SerialGeneration.getCurrent().getVersionString()));
        if (result == 0 && SvaDebug.FORCE_UPGRADE) {
            result = -1;
        }
        return result;
    }

    private synchronized String getDataVersion() throws Exception {
        if (!this.online) {
            throw new ZkOfflineException();
        }
        return (String)BldSerialization.bytesToObject(this.zk.getData(false, ZK_DATA_VERSION_PATH, false, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getMasterId(boolean watch) {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (this.currentMasterId != null) {
                return this.currentMasterId;
            }
            return this.getInternalMasterId(watch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDomainOnline(BldEventWatcher watcher) throws BldException, KeeperException, InterruptedException {
        logger.log(Level.FINE, "Registering for domain online:" + this.domainName);
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (watcher == null) {
                throw new BldException("watcher for registerDomainOnline cannot be null");
            }
            this.domainOnlineWatcher = watcher;
            if (this.online) {
                new BldDomainOnlineEvent(true).send(this.domainOnlineWatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBldInformation(AbstractBldInformation bldInformation) throws Exception {
        logger.log(Level.FINE, "Updating BLD information: " + this.domainName);
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.writeBldInformation(bldInformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDomainOnline(BldEventWatcher watcher) {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (this.domainOnlineWatcher != null) {
                if (watcher != this.domainOnlineWatcher) {
                    String errorStr = "Wrong watcher unregistering for domain online messages";
                    assert (false) : "Wrong watcher unregistering for domain online messages";
                    logger.log(Level.SEVERE, "Wrong watcher unregistering for domain online messages");
                } else {
                    this.domainOnlineWatcher = null;
                    this.watchForHealthChange = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UUID> getOnlineDomains(boolean watch) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            HashSet<UUID> domains = new HashSet<UUID>();
            try {
                if (!this.online) {
                    throw new ZkOfflineException();
                }
                this.zk.sync("/", null, null);
                List<String> children = this.zk.getChildren(ZK_HEALTH_PATH, watch);
                for (String child : children) {
                    domains.add(UUID.fromString(child));
                }
                this.watchForHealthChange = watch;
                return domains;
            }
            catch (ZkOfflineException e) {
                logger.log(Level.INFO, "Could not get online domains: " + e.getMessage());
                return domains;
            }
            catch (KeeperException e) {
                logger.log(Level.INFO, "Could not get online domains: " + e.getMessage());
                return domains;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBldInformation getBldInformation(UUID bldId) {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                logger.log(Level.WARNING, "ZkClient is offline: " + this.domainName);
            }
            String bldInformationPath = "/Health/" + bldId;
            try {
                this.zk.sync("/", null, null);
                if (this.zk.exists(bldInformationPath, false) != null) {
                    byte[] bData = this.zk.getData(false, bldInformationPath, false, null);
                    AbstractBldInformation bldInformation = (AbstractBldInformation)((Object)BldSerialization.bytesToObject(bData));
                    return bldInformation;
                }
                logger.log(Level.WARNING, "Request to read non-existing BLD information znode " + bldInformationPath);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to read BLD information znode " + bldInformationPath + ": " + e.getMessage());
            }
            return null;
        }
    }

    public UUID getBldInstantiationId(UUID bldId) {
        AbstractBldInformation bldInformation = this.getBldInformation(bldId);
        if (bldInformation == null) {
            return null;
        }
        return bldInformation.getInstantiationId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMessageQueue() throws Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.createZnodeIfDoesntExist(this.msgQueuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessageQueue() throws KeeperException, InterruptedException, Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.deleteZnodeTree(this.msgQueuePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messageQueueExists() throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            return this.zk.exists(this.msgQueuePath, false) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(AbstractBlcMessage msg) throws Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            logger.log(Level.FINE, "Sending message from " + msg.getHeader().getSourceBld().toString() + " to " + msg.getHeader().getDestinationBld());
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            String dstMsgQueuePath = "/Messages/" + msg.getHeader().getDestinationBld().toString();
            if (this.zk.exists(dstMsgQueuePath, false) == null) {
                throw new BldException("Message queue " + dstMsgQueuePath + " does not exist");
            }
            String dstMsgQueueChildPath = dstMsgQueuePath + ZK_MESSAGE_PREFIX;
            byte[] bMsg = null;
            bMsg = BldSerialization.objectToBytes((Object)msg);
            this.zk.create(dstMsgQueueChildPath, bMsg, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessageList(BldEventWatcher watcher) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            logger.log(Level.FINE, "Getting messages for " + this.domainId.toString());
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            this.messageWatcher = watcher;
            if (this.zk.exists(this.msgQueuePath, false) == null) {
                throw new BldException("Message queue " + this.msgQueuePath + " does not exist");
            }
            List<String> children = this.zk.getChildren(this.msgQueuePath, true);
            Collections.sort(children);
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBlcMessage getMessage(String msgId) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.msgQueuePath, false) == null) {
                throw new BldException("Message queue " + this.msgQueuePath + " does not exist");
            }
            String msgQueueChildPath = this.msgQueuePath + "/" + msgId;
            try {
                return (AbstractBlcMessage)((Object)BldSerialization.bytesToObject(this.zk.getData(true, msgQueueChildPath, false, null)));
            }
            catch (Exception e) {
                if (this.zk.exists(msgQueueChildPath, false) != null) {
                    throw new BldException("Unable to read message " + msgQueueChildPath + ": " + e.getMessage());
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(String msgId) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            block8: {
                if (!this.online) {
                    throw new ZkOfflineException();
                }
                this.zk.sync("/", null, null);
                if (this.zk.exists(this.msgQueuePath, false) == null) {
                    throw new BldException("Message queue " + this.msgQueuePath + " does not exist");
                }
                String msgQueueChildPath = this.msgQueuePath + "/" + msgId;
                if (this.zk.exists(msgQueueChildPath, false) != null) {
                    try {
                        this.zk.delete(msgQueueChildPath, -1);
                    }
                    catch (Exception e) {
                        if (this.zk.exists(msgQueueChildPath, false) == null) break block8;
                        throw new BldException("Unable to delete message " + msgQueueChildPath + ": " + e.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTransactionLog() throws Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            this.createZnodeIfDoesntExist(ZK_TRANSACTION_LOG_PATH);
            this.createZnodeIfDoesntExist(this.transactionLogPath);
            this.createZnodeIfDoesntExist(this.transactionsPath);
            if (this.zk.exists(this.masterGenerationPath, false) == null) {
                byte[] bdata = BldSerialization.objectToBytes((Object)new MasterGenerationInformation());
                try {
                    this.zk.create(this.masterGenerationPath, bdata, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException e) {
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to create \"" + this.masterGenerationPath, e);
                    throw e;
                }
            }
            this.createZnodeIfDoesntExist(this.generationsPath);
            this.createZnodeIfDoesntExist(this.replicasPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTransactionLog() throws Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            this.deleteZnodeTree(this.transactionLogPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTransactionLog(BldTransaction transaction) throws BldException, KeeperException, InterruptedException, IOException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.transactionLogPath, false) == null) {
                throw new BldException("Transactions log " + this.transactionLogPath + " does not exist");
            }
            if (this.zk.exists(this.transactionsPath, false) == null) {
                throw new BldException("Transactions subpath " + this.transactionsPath + " does not exist");
            }
            this.zk.create(this.transactionsPath + "/" + this.genString(transaction.getGeneration()), BldSerialization.objectToBytes(transaction), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getTransactionList(BldEventWatcher watcher) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.transactionLogPath, false) == null) {
                throw new BldException("Transactions log " + this.transactionLogPath + " does not exist");
            }
            if (this.zk.exists(this.transactionsPath, false) == null) {
                throw new BldException("Transactions subpath " + this.transactionsPath + " does not exist");
            }
            List<String> children = this.zk.getChildren(this.transactionsPath, true);
            ArrayList<Long> transactionIds = new ArrayList<Long>();
            for (String child : children) {
                transactionIds.add(Long.parseLong(child));
            }
            Collections.sort(transactionIds);
            this.transactionWatcher = watcher;
            return transactionIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BldTransaction getTransaction(long generation) throws BldException, KeeperException, InterruptedException, IOException, ClassNotFoundException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.transactionLogPath, false) == null) {
                throw new BldException("Transactions log " + this.transactionLogPath + " does not exist");
            }
            if (this.zk.exists(this.transactionsPath, false) == null) {
                throw new BldException("Transactions subpath " + this.transactionsPath + " does not exist");
            }
            return (BldTransaction)BldSerialization.bytesToObject(this.zk.getData(false, this.transactionsPath + "/" + this.genString(generation), false, null));
        }
    }

    public void updateGeneration(long generation) throws BldException, KeeperException, InterruptedException, IOException, ClassNotFoundException {
        this.setGeneration(this.svaId, generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeneration(UUID svaId, long generation) throws BldException, KeeperException, InterruptedException, IOException, ClassNotFoundException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.transactionLogPath, false) == null) {
                throw new BldException("generation path " + this.transactionLogPath + " does not exist");
            }
            if (this.zk.exists(this.generationsPath, false) == null) {
                throw new BldException("generation path " + this.generationsPath + " does not exist");
            }
            String generationZnode = this.generationsPath + "/" + svaId.toString();
            if (this.zk.exists(generationZnode, false) == null) {
                this.zk.create(generationZnode, BldSerialization.objectToBytes(generation), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                this.zk.setData(false, generationZnode, BldSerialization.objectToBytes(generation), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateBldTransactionLog() throws KeeperException, InterruptedException, IOException, ClassNotFoundException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            long lowGen = this.getLowestGeneration();
            String gString = this.genString(lowGen);
            String transactionLogTransactionsPath = this.transactionLogPath + ZK_TRANSACTIONS_SUBPATH;
            List<String> children = this.zk.getChildren(transactionLogTransactionsPath, false);
            Collections.sort(children);
            int highCount = children.size();
            if (SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) {
                logger.log(Level.INFO, "Lowest transaction = " + children.get(0) + ", highest transaction = " + children.get(highCount - 1));
            }
            for (String child : children) {
                if (child.compareTo(gString) >= 0) continue;
                if (SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) {
                    logger.log(Level.INFO, "Deleting transaction " + child);
                }
                this.zk.delete(transactionLogTransactionsPath + "/" + child, -1);
            }
            if (SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) {
                children = this.zk.getChildren(transactionLogTransactionsPath, false);
                int lowCount = children.size();
                logger.log(Level.INFO, "Truncated " + (highCount - lowCount) + " transaction log from " + highCount + " to " + lowCount);
            }
        }
    }

    private List<String> getOnlineReplicas() {
        ArrayList<String> onlineReplicas = new ArrayList<String>();
        List<String> onlineReplicaZnodes = null;
        try {
            onlineReplicaZnodes = this.zk.getChildren(this.domainElectionPath, false);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to retrieve online replica IDs", e);
            onlineReplicaZnodes = new ArrayList<String>();
        }
        for (String node : onlineReplicaZnodes) {
            try {
                String path = this.domainElectionPath + "/" + node;
                UUID svaId = (UUID)BldSerialization.bytesToObject(this.zk.getData(true, path, null, null));
                String svaIdStr = svaId.toString();
                onlineReplicas.add(svaIdStr);
                if (!SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) continue;
                logger.log(Level.INFO, path + ": replica " + svaIdStr + " is online");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to retrieve replica ID " + node, e);
            }
        }
        return onlineReplicas;
    }

    private long getLowestGeneration() {
        List<String> onlineReplicas = this.getOnlineReplicas();
        List<String> generationZnodes = null;
        try {
            generationZnodes = this.zk.getChildren(this.generationsPath, false);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to retrieve generations", e);
            return 0L;
        }
        String msg = "Generations:";
        long lowGen = -1L;
        boolean allReplicasOnline = true;
        for (String gNode : generationZnodes) {
            if (onlineReplicas.contains(gNode)) {
                try {
                    long g = (Long)BldSerialization.bytesToObject(this.zk.getData(false, this.generationsPath + "/" + gNode, null, null));
                    msg = msg + " " + g;
                    if (lowGen >= 0L && g >= lowGen) continue;
                    lowGen = g;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Unable to retrieve generaion " + gNode, e);
                    allReplicasOnline = false;
                }
                continue;
            }
            if (SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) {
                logger.log(Level.INFO, "SVA " + gNode + " is offline");
            }
            allReplicasOnline = false;
        }
        lowGen = lowGen < SvaConstants.ZK_MASTER_UPDATE_FREQUENCY ? 0L : (lowGen -= SvaConstants.ZK_MASTER_UPDATE_FREQUENCY);
        if (!allReplicasOnline) {
            lowGen = lowGen < SvaConstants.MAX_ZK_TRANSACTION_LOG_LENGTH ? 0L : (lowGen -= SvaConstants.MAX_ZK_TRANSACTION_LOG_LENGTH);
        }
        if (SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) {
            logger.log(Level.INFO, msg + ", lowest = " + lowGen);
        }
        return lowGen;
    }

    public synchronized void cleanupDeadSva(UUID svaId, List<UUID> domainIds) {
        String svaIdStr = svaId.toString();
        for (UUID domId : domainIds) {
            String tlPath = "/TransactionLog/" + domId.toString();
            String generationPath = tlPath + ZK_GENERATIONS_SUBPATH + "/" + svaIdStr;
            try {
                this.zk.delete(generationPath, -1);
                if (SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) {
                    logger.log(Level.INFO, "Deleted generation path " + generationPath);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not delete generation path " + generationPath, e);
            }
            String replicaPath = tlPath + ZK_REPLICAS_SUBPATH + "/" + svaIdStr;
            try {
                this.zk.delete(replicaPath, -1);
                if (!SvaDebug.LOG_ZK_TRANSACTION_LOG_TRUNCATION) continue;
                logger.log(Level.INFO, "Deleted replica information path " + generationPath);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not delete replica information path " + generationPath, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReplicaInfo(UUID svaId, ReplicaInformation replicaInformation) throws BldException, KeeperException, InterruptedException, IOException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.transactionLogPath, false) == null) {
                throw new BldException("replica information " + this.transactionLogPath + " does not exist");
            }
            if (this.zk.exists(this.replicasPath, false) == null) {
                throw new BldException("replica information " + this.replicasPath + " does not exist");
            }
            String replicaZnode = this.replicasPath + "/" + svaId.toString();
            byte[] bReplicaInformation = BldSerialization.objectToBytes(replicaInformation);
            if (this.zk.exists(replicaZnode, false) == null) {
                this.zk.create(replicaZnode, bReplicaInformation, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                this.zk.setData(false, replicaZnode, bReplicaInformation, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicaInformation getReplicaInformation(UUID svaId) throws BldException, KeeperException, InterruptedException, IOException, ClassNotFoundException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(this.transactionLogPath, false) == null) {
                throw new BldException("replica information " + this.transactionLogPath + " does not exist");
            }
            if (this.zk.exists(this.replicasPath, false) == null) {
                throw new BldException("replica information " + this.replicasPath + " does not exist");
            }
            String replicaZnode = this.replicasPath + "/" + svaId.toString();
            if (this.zk.exists(replicaZnode, false) == null) {
                throw new BldException("replica information " + replicaZnode + " does not exist");
            }
            return (ReplicaInformation)BldSerialization.bytesToObject(this.zk.getData(false, replicaZnode, false, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStorageClusterConfig(StorageClusterConfig storageClusterConfig) throws BldException, IOException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            byte[] bdata = BldSerialization.objectToBytes(storageClusterConfig);
            if (this.zk.exists(ZK_CLUSTER_CONFIG_PATH, false) == null) {
                this.zk.create(ZK_CLUSTER_CONFIG_PATH, bdata, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            } else {
                this.zk.setData(false, ZK_CLUSTER_CONFIG_PATH, bdata, -1);
            }
        }
    }

    public synchronized StorageClusterConfig readStorageClusterConfig() throws BldException, KeeperException, InterruptedException, IOException, ClassNotFoundException {
        if (!this.online) {
            throw new ZkOfflineException();
        }
        this.zk.sync("/", null, null);
        if (this.zk.exists(ZK_CLUSTER_CONFIG_PATH, false) == null) {
            throw new BldException("Storage Cluster Configuration /ClusterConfiguration does not exist");
        }
        return (StorageClusterConfig)BldSerialization.bytesToObject(this.zk.getData(false, ZK_CLUSTER_CONFIG_PATH, false, null));
    }

    public synchronized void writeMasterGeneration(MasterGenerationInformation masterGenerationInformation) throws ZkOfflineException, KeeperException, InterruptedException, IOException {
        if (!this.online) {
            throw new ZkOfflineException();
        }
        this.zk.sync("/", null, null);
        byte[] bdata = BldSerialization.objectToBytes((Object)masterGenerationInformation);
        this.zk.setData(false, this.masterGenerationPath, bdata, -1);
    }

    private synchronized void createUpdateMasterGeneration() throws ZkOfflineException, KeeperException, InterruptedException, IOException, ClassNotFoundException {
        this.zk.sync("/", null, null);
        List<String> ftDomainIds = this.zk.getChildren(ZK_TRANSACTION_LOG_PATH, false);
        for (String ftDomainId : ftDomainIds) {
            String path = "/TransactionLog/" + ftDomainId + ZK_MASTER_GENERATION_SUBPATH;
            byte[] bdata = BldSerialization.objectToBytes((Object)new MasterGenerationInformation(-1L, null));
            if (this.zk.exists(path, false) == null) {
                logger.log(Level.INFO, "Creating Update MasterGenerationInformation");
                this.zk.create(path, bdata, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                continue;
            }
            MasterGenerationInformation generationInformation = (MasterGenerationInformation)((Object)BldSerialization.bytesToObject(this.zk.getData(false, path, false, null)));
            if (generationInformation.getGeneration() != 0L) continue;
            logger.log(Level.INFO, "Writing Update MasterGenerationInformaton");
            this.zk.setData(false, this.masterGenerationPath, bdata, -1);
        }
    }

    public synchronized MasterGenerationInformation readMasterGeneration() throws KeeperException, InterruptedException, IOException, ClassNotFoundException, BldException {
        logger.log(Level.INFO, "Reading master generation");
        if (!this.online) {
            throw new ZkOfflineException();
        }
        this.zk.sync("/", null, null);
        if (this.zk.exists(this.masterGenerationPath, false) == null) {
            throw new BldException("Master Generation Information " + this.masterGenerationPath + " does not exist");
        }
        return (MasterGenerationInformation)((Object)BldSerialization.bytesToObject(this.zk.getData(false, this.masterGenerationPath, false, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReconfigNetworkFlag() throws BldException, IOException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(ZK_RECONFIG_NETWORK_FLAG_PATH, false) == null) {
                this.zk.create(ZK_RECONFIG_NETWORK_FLAG_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReconfigNetworkFlagSet() throws BldException, IOException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            return this.zk.exists(ZK_RECONFIG_NETWORK_FLAG_PATH, false) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReconfigNetworkFlag() throws BldException, IOException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            if (this.zk.exists(ZK_RECONFIG_NETWORK_FLAG_PATH, false) != null) {
                this.zk.delete(ZK_RECONFIG_NETWORK_FLAG_PATH, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReplicaInformation(UUID svaId) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            block9: {
                if (!this.online) {
                    throw new ZkOfflineException();
                }
                this.zk.sync("/", null, null);
                if (this.zk.exists(this.transactionLogPath, false) == null) {
                    throw new BldException("replica information " + this.transactionLogPath + " does not exist");
                }
                if (this.zk.exists(this.replicasPath, false) == null) {
                    throw new BldException("replica information " + this.replicasPath + " does not exist");
                }
                String replicaZnode = this.replicasPath + "/" + svaId.toString();
                if (this.zk.exists(replicaZnode, false) != null) {
                    try {
                        this.zk.delete(replicaZnode, -1);
                    }
                    catch (Exception e) {
                        if (this.zk.exists(replicaZnode, false) == null) break block9;
                        throw new BldException("Unable to delete replica information " + replicaZnode + ": " + e.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPseudoSvaOnline(boolean watch) throws BldException, KeeperException, InterruptedException {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.zk.sync("/", null, null);
            return this.zk.exists("/PseudoSvaOnline", true) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        logger.log(Level.FINE, "Processing event: " + event.toString());
        ZkClient zkClient = this;
        synchronized (zkClient) {
            logger.log(Level.FINE, "Executor: processing event " + event.toString());
            String eventPath = event.getPath();
            block2 : switch (event.getType()) {
                case None: {
                    switch (event.getState()) {
                        case SyncConnected: {
                            this.processSyncConnected();
                            break block2;
                        }
                        case Disconnected: {
                            this.processDisconnected();
                            break block2;
                        }
                        case Expired: {
                            this.processExpired();
                        }
                    }
                    break;
                }
                case NodeChildrenChanged: {
                    if (eventPath.equals(ZK_HEALTH_PATH)) {
                        this.processHealthChanged();
                        break;
                    }
                    if (eventPath.equals(this.domainElectionPath)) {
                        this.processElectionChanged();
                        break;
                    }
                    if (eventPath.equals(this.msgQueuePath)) {
                        this.processMessageQueueChanged();
                        break;
                    }
                    if (!eventPath.equals(this.transactionsPath)) break;
                    this.processTransactionLogChanged();
                    break;
                }
                case NodeCreated: {
                    if (!eventPath.equals("/PseudoSvaOnline")) break;
                    this.processPseudoSvaOnlineChanged();
                    break;
                }
                case NodeDeleted: {
                    if (!eventPath.equals("/PseudoSvaOnline")) break;
                    this.processPseudoSvaOnlineChanged();
                    break;
                }
                case NodeDataChanged: {
                    if (!eventPath.equals(ZK_SVA_VERSION_PATH)) break;
                    this.processSvaVersionChanged();
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "Received unexpected WatchedEvent: " + event.toString());
                }
            }
        }
    }

    private void processSyncConnected() {
        logger.log(Level.INFO, "Domain " + this.domainName + " zookeeper client received SYNC CONNECTED");
        logger.log(Level.INFO, "ZooKeeper session 0x" + Long.toHexString(this.zk.getSessionId()) + " for domain " + this.domainName + " (" + this.domainId.toString() + ")");
        if (this.offlineTimer != null) {
            this.offlineTimer.cancel();
            this.offlineTimer = null;
        }
        this.zk.wakeup();
        if (!this.online) {
            this.handleOnline();
        }
    }

    private void processDisconnected() {
        logger.log(Level.INFO, "Domain " + this.domainName + " zookeeper client received DISCONNECTED");
        if (this.offlineTimer == null) {
            this.offlineTimer = new Timer("ZkClient Offline Timer");
            this.offlineTimer.schedule((TimerTask)new OfflineTimerTask(), SvaConstants.ZK_CLIENT_OFFLINE_TIMEOUT);
        }
    }

    private void processExpired() {
        logger.log(Level.INFO, "Domain " + this.domainName + " zookeeper client received EXPIRED");
        if (this.online) {
            this.handleOffline(true);
            this.initialize();
        }
    }

    private void processHealthChanged() {
        if (this.watchForHealthChange) {
            new BldDomainsOnlineChangeEvent().send(this.domainOnlineWatcher);
        }
    }

    private void processElectionChanged() {
        if (!this.amMaster) {
            try {
                UUID newMasterId = this.getInternalMasterId(true);
                this.amMaster = this.amMasterReplica(newMasterId);
                if (this.amMaster) {
                    new BldReplicaEvent(true, true, this.currentMasterId).send(this.replicaOnlineWatcher);
                } else if (this.currentMasterId == null || !this.currentMasterId.equals(newMasterId)) {
                    new BldReplicaEvent(true, false, this.currentMasterId).send(this.replicaOnlineWatcher);
                    this.currentMasterId = newMasterId;
                }
            }
            catch (Exception e) {
                this.handleOffline(true);
                this.initialize();
            }
        }
    }

    private void processMessageQueueChanged() {
        if (this.messageWatcher != null) {
            new BldMessagesAvailableEvent().send(this.messageWatcher);
        }
    }

    private void processTransactionLogChanged() {
        if (this.transactionWatcher != null) {
            new BldTransactionsAvailableEvent().send(this.transactionWatcher);
        }
    }

    private void processPseudoSvaOnlineChanged() {
        new BldPseudoSvaEvent().send(this.domainOnlineWatcher);
    }

    private void processSvaVersionChanged() {
        if (this.svaVersionWatcher != null) {
            new BldSvaVersionChangeEvent().send(this.svaVersionWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        block8: {
            this.domainElectionPath = "/Election/" + this.domainId.toString();
            this.msgQueuePath = "/Messages/" + this.domainId.toString();
            this.transactionLogPath = "/TransactionLog/" + this.domainId.toString();
            this.transactionsPath = this.transactionLogPath + ZK_TRANSACTIONS_SUBPATH;
            this.generationsPath = this.transactionLogPath + ZK_GENERATIONS_SUBPATH;
            this.masterGenerationPath = this.transactionLogPath + ZK_MASTER_GENERATION_SUBPATH;
            this.replicasPath = this.transactionLogPath + ZK_REPLICAS_SUBPATH;
            this.internalClose();
            StringBuilder hosts = new StringBuilder();
            boolean first = true;
            for (String address : this.addresses) {
                if (!first) {
                    hosts.append(",");
                } else {
                    first = false;
                }
                hosts.append(address).append(ZKPORT);
            }
            try {
                this.zk = new ZooKeeperWrapper(hosts.toString(), SvaConstants.ZK_CLIENT_SESSION_TIMEOUT, this, true, this);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to create ZooKeeper client: " + e.getMessage());
                e.printStackTrace();
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)("Unable to create ZooKeeper client: " + e.getMessage()));
            }
        }
        ZkClient zkClient = this;
        synchronized (zkClient) {
            this.zk.sync("/", null, null);
        }
    }

    private void internalClose() {
        if (this.zk != null) {
            try {
                this.zk.close();
            }
            catch (InterruptedException e) {
                assert (false) : "Unable to close ZooKeeper client: " + e.getMessage();
                logger.log(Level.SEVERE, "Unable to close ZooKeeper client: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createElectionService() throws KeeperException, InterruptedException, Exception {
        ZkClient zkClient = this;
        synchronized (zkClient) {
            if (!this.online) {
                throw new ZkOfflineException();
            }
            this.createZnodeIfDoesntExist(ZK_ELECTION_PATH);
            this.createZnodeIfDoesntExist(this.domainElectionPath);
        }
    }

    private void createZnodeIfDoesntExist(String znode) throws KeeperException, InterruptedException, Exception {
        if (this.zk.exists(znode, false) == null) {
            try {
                this.zk.create(znode, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to create \"" + znode, e);
                throw e;
            }
        }
    }

    private void deleteZnodeTree(String znode) throws KeeperException, InterruptedException, Exception {
        if (this.zk.exists(znode, false) != null) {
            try {
                List<String> children = this.zk.getChildren(znode, false);
                for (String child : children) {
                    this.deleteZnodeTree(znode + "/" + child);
                }
                this.zk.delete(znode, -1);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unable to delete znode " + znode + ": " + e.getMessage());
                throw e;
            }
        }
    }

    private UUID getInternalMasterId(boolean watch) {
        this.zk.sync("/", null, null);
        List<String> children = this.zk.getChildren(this.domainElectionPath, watch);
        if (children.isEmpty()) {
            logger.log(Level.WARNING, "No online replica for in election path");
            return null;
        }
        Collections.sort(children);
        try {
            Stat stat = new Stat();
            UUID masterId = (UUID)BldSerialization.bytesToObject(this.zk.getData(true, this.domainElectionPath + "/" + children.get(0), false, stat));
            if (!masterId.equals(this.svaId)) {
                return masterId;
            }
            if (stat.getEphemeralOwner() == this.zk.getSessionId()) {
                return masterId;
            }
            logger.log(Level.FINE, "Old election znode found for this domain; ignoring");
            return null;
        }
        catch (Exception e) {
            try {
                logger.log(Level.INFO, "Could not read election master znode; assuming deleted; ignoring: " + e.getMessage());
                return null;
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Could not get master ID: " + e2.getMessage());
                return null;
            }
        }
    }

    private boolean amMasterReplica(UUID masterId) {
        if (masterId == null) {
            return false;
        }
        return masterId.equals(this.svaId);
    }

    private void writeReplicaOnline() throws Exception {
        this.createElectionService();
        String domainElectionChildPath = this.domainElectionPath + ZK_ELECTION_PREFIX;
        this.zk.create(domainElectionChildPath, BldSerialization.objectToBytes(this.svaId), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        this.currentMasterId = this.getInternalMasterId(true);
        this.amMaster = this.amMasterReplica(this.currentMasterId);
        new BldReplicaEvent(true, this.amMaster, null).send(this.replicaOnlineWatcher);
    }

    public synchronized void waitForOldSessionToExpire() throws Exception {
        logger.log(Level.INFO, "Waiting for old session to expire for domain " + this.domainName);
        String domainHealthPath = "/Health/" + this.domainId.toString();
        this.zk.sync("/", null, null);
        int tries = SvaConstants.ZK_CLIENT_SESSION_TIMEOUT / 1000 + SvaConstants.ZK_OLD_SESSION_EXPIRE_EXTRA_RETRIES;
        while (this.zk.exists(domainHealthPath, false) != null) {
            logger.log(Level.INFO, "Old session exits for domain " + this.domainName + " continuing to wait (retry left = " + tries + ")");
            if (--tries == 0) {
                throw new Exception("Old session not expiring");
            }
            this.wait(1000L);
            this.zk.sync("/", null, null);
        }
    }

    private void writeBldInformation(AbstractBldInformation bldInformation) throws IOException, KeeperException, InterruptedException {
        String domainHealthPath = "/Health/" + this.domainId.toString();
        this.zk.sync("/", null, null);
        byte[] bData = BldSerialization.objectToBytes((Object)bldInformation);
        if (this.zk.exists(domainHealthPath, false) != null) {
            try {
                logger.log(Level.INFO, "Writing BLD information " + this.domainId);
                this.zk.setData(false, domainHealthPath, bData, -1);
                new BldDomainOnlineEvent(true).send(this.domainOnlineWatcher);
                return;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unable to write domain health path " + domainHealthPath + ", will try creating: " + e.getMessage());
            }
        }
        logger.log(Level.INFO, "Creating BLD information " + this.domainId);
        this.zk.create(domainHealthPath, bData, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
    }

    private void handleOnline() {
        logger.log(Level.INFO, "Created ZooKeeper client session 0x" + Long.toHexString(this.zk.getSessionId()) + " for domain " + this.domainName + "(" + this.domainId.toString() + ")");
        try {
            this.SetupBasicCluster();
        }
        catch (Exception e) {
            this.initialize();
            return;
        }
        this.online = true;
        if (this.domainOnlineWatcher != null) {
            new BldDomainOnlineEvent(true).send(this.domainOnlineWatcher);
        }
        if (this.replicaOnlineWatcher != null) {
            try {
                this.writeReplicaOnline();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to write replica online file: " + e.getMessage());
                this.initialize();
                return;
            }
        }
    }

    private void SetupBasicCluster() throws Exception {
        this.createZnodeIfDoesntExist(ZK_HEALTH_PATH);
        this.createZnodeIfDoesntExist(ZK_MESSAGE_QUEUE_PATH);
        this.createZnodeIfDoesntExist(ZK_VERSION_PATH);
        if (this.zk.exists(ZK_SVA_VERSION_PATH, false) == null) {
            try {
                this.zk.create(ZK_SVA_VERSION_PATH, BldSerialization.objectToBytes(SvaVersion.getVersion()), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException e) {
                // empty catch block
            }
        }
        if (this.zk.exists(ZK_DATA_VERSION_PATH, false) == null) {
            try {
                this.zk.create(ZK_DATA_VERSION_PATH, BldSerialization.objectToBytes(SerialGeneration.getCurrent().getVersionString()), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    private void handleOffline(boolean allowReboot) {
        logger.log(Level.FINE, "zClient is offline: " + this.domainName);
        this.internalClose();
        if (allowReboot && SvaDebug.MEMBER_REBOOT_TO_TERMINATE) {
            logger.log(Level.WARNING, this.domainName + " ZooKeeper client has gone offline.  Forcing reboot");
            try {
                SystemUtils.reboot(true, null, new LoggerAdapter(logger));
            }
            catch (Exception e) {
                String errorMsg = "reboot failed: " + e.getLocalizedMessage();
                assert (false) : errorMsg;
                logger.log(Level.SEVERE, errorMsg, e);
            }
        }
        if (this.offlineTimer != null) {
            this.offlineTimer.cancel();
            this.offlineTimer = null;
        }
        this.online = false;
        if (this.domainOnlineWatcher != null) {
            new BldDomainOnlineEvent(false).send(this.domainOnlineWatcher);
            this.domainOnlineWatcher = null;
        }
        this.replicaOnlineWatcher = null;
        this.messageWatcher = null;
        this.transactionWatcher = null;
        this.watchForHealthChange = false;
        this.svaVersionWatcher = null;
    }

    private String genString(long generation) {
        return String.format("%1$020d", generation);
    }

    private class OfflineTimerTask
    extends TimerTask {
        private OfflineTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ZkClient zkClient = ZkClient.this;
                synchronized (zkClient) {
                    if (ZkClient.this.offlineTimer != null) {
                        ZkClient.this.offlineTimer.cancel();
                        ZkClient.this.offlineTimer = null;
                        if (ZkClient.this.online) {
                            ZkClient.this.handleOffline(true);
                            ZkClient.this.initialize();
                        }
                    }
                }
            }
            catch (AssertionError e) {
                SvaHelper.handleAssertionError("ZkClient.OfflineTimerTask", e, logger);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception in ZkClient.OfflineTimerTask: " + e.getMessage(), e);
            }
        }
    }
}

