/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlDataReader {
    private String _configLocation;
    private InputStream inStream;

    public void setInputStream(InputStream in) throws Exception {
        if (in == null) {
            throw new Exception("Inputstream is null");
        }
        this.inStream = in;
    }

    public String getConfigLocation() {
        return this._configLocation;
    }

    public void setConfigLocation(String configLocation) throws Exception {
        File f = new File(configLocation);
        if (!f.exists()) {
            throw new Exception("Configuration file not found: " + configLocation);
        }
        this._configLocation = configLocation;
    }

    public void init() throws Exception {
        if (this._configLocation == null && this.inStream == null) {
            throw new Exception("No config location or input stream set");
        }
        if (this._configLocation != null) {
            File f = new File(this._configLocation);
            if (!f.exists()) {
                throw new Exception("File not found: " + this._configLocation);
            }
            FileInputStream stream = new FileInputStream(f);
            assert (stream != null);
            this.inStream = stream;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(this.inStream);
        this.loadFromXML(dom);
    }

    public abstract void loadFromXML(Document var1) throws Exception;

    public String getTextValue(Element ele, String tagName, String defaultValue) throws Exception {
        String textVal;
        assert (ele != null);
        assert (tagName != null);
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl == null || nl.getLength() == 0) {
            if (defaultValue == null) {
                throw new Exception(tagName);
            }
            return defaultValue;
        }
        Node n = nl.item(0).getFirstChild();
        if (n != null && (textVal = n.getNodeValue()).length() > 0) {
            return textVal;
        }
        if (defaultValue == null) {
            throw new Exception(tagName);
        }
        return defaultValue;
    }
}

