/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.ws.sas;

import com.vmware.sva.common.MemberSva;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.SvaServerInfo;
import com.vmware.sva.messaging.MessagingInterfaceImpl;
import com.vmware.sva.messaging.interfaces.SasInterface;
import com.vmware.sva.messaging.ws.AbstractService;
import com.vmware.sva.messaging.ws.ConverterUtil;
import com.vmware.sva.messaging.ws.model.AbstractStorageEntity;
import com.vmware.sva.messaging.ws.model.ExceptionMsg;
import com.vmware.sva.messaging.ws.model.LoginFailed;
import com.vmware.sva.messaging.ws.model.LoginFailedMsg;
import com.vmware.sva.messaging.ws.model.MapEntry;
import com.vmware.sva.messaging.ws.model.NfsAccessControl;
import com.vmware.sva.messaging.ws.model.NoPermission;
import com.vmware.sva.messaging.ws.model.NoPermissionMsg;
import com.vmware.sva.messaging.ws.model.PingResult;
import com.vmware.sva.messaging.ws.model.StorageCluster;
import com.vmware.sva.messaging.ws.model.TaskRef;
import com.vmware.sva.messaging.ws.model.TaskStatus;
import com.vmware.sva.messaging.ws.model.UserSession;
import com.vmware.sva.messaging.ws.sas.Exception;
import com.vmware.sva.messaging.ws.sas.LoginFailedException;
import com.vmware.sva.messaging.ws.sas.NoPermissionException;
import com.vmware.sva.messaging.ws.sas.SasserviceSkeletonInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SasserviceSkeleton
extends AbstractService
implements SasserviceSkeletonInterface {
    private static final Log log = LogFactory.getLog(SasserviceSkeleton.class);
    private SasInterface sas;

    public SasserviceSkeleton(MessagingInterfaceImpl messaging) {
        super(messaging, messaging.getSasController());
    }

    public void setSasInterface(SasInterface sas) {
        this.sas = sas;
    }

    private SasInterface getSasInterface() {
        if (this.sas == null) {
            this.sas = this.getMessagingInterfaceImpl().getSasInterface();
        }
        return this.sas;
    }

    protected void checkUserSession() throws NoPermissionException {
        if (this.getUserSession() == null) {
            NoPermission np = new NoPermission();
            np.setMessage("Please login first.");
            NoPermissionMsg npmsg = new NoPermissionMsg();
            npmsg.setNoPermissionMsg(np);
            NoPermissionException npe = new NoPermissionException();
            npe.setFaultMessage(npmsg);
            throw npe;
        }
    }

    protected Exception convertException(java.lang.Exception e) {
        log.error("sas Exception: ", e);
        ExceptionMsg msg = new ExceptionMsg();
        com.vmware.sva.messaging.ws.model.Exception ex = new com.vmware.sva.messaging.ws.model.Exception();
        ex.setMessage(e.getMessage());
        msg.setExceptionMsg(ex);
        Exception exp = new Exception();
        exp.setFaultMessage(msg);
        return exp;
    }

    @Override
    public TaskRef changePassword(String user, String oldPass, String newPass) throws NoPermissionException, Exception {
        this.checkUserSession();
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.changePassword(user, oldPass, newPass);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        if (log.isInfoEnabled()) {
            log.info("changePassword for " + user + ", task id " + task.getTaskId());
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public StorageCluster getStorageCluster() throws NoPermissionException {
        this.checkUserSession();
        com.vmware.sva.common.StorageCluster sc = this.sas.getStorageCluster();
        if (log.isInfoEnabled()) {
            log.info("getStorageCluster : " + sc.getId());
            log.info("  ManagementInterface: " + sc.getManagementInterface().getIpAddress().getHostAddress());
            log.info("  master Id: " + sc.getMasterId());
            List<MemberSva> svas = sc.getMembers();
            log.info("   member SVAs:");
            if (svas != null) {
                for (MemberSva sva : svas) {
                    log.info("      sva Id: " + sva.getId());
                    log.info("      sva name: " + sva.getName());
                    log.info("      sva memberId: " + sva.getMemberId());
                    log.info("      sva state: " + (Object)((Object)sva.getState()));
                    log.info("      sva StorageClusterId: " + sva.getStorageClusterId());
                }
            } else {
                log.error("No MemSva in StorageCluster");
            }
            List<com.vmware.sva.common.AbstractStorageEntity> ses = sc.getStorageEntities();
            log.info("   Storage Entities:");
            if (ses != null) {
                for (com.vmware.sva.common.AbstractStorageEntity se : ses) {
                    log.info("      Id: " + se.getId());
                    log.info("      State: " + (Object)((Object)se.getState()));
                }
            } else {
                log.info("No storage entities in StorageCluster.");
            }
        }
        return (StorageCluster)ConverterUtil.convert(sc, null);
    }

    @Override
    public void repairCluster() throws NoPermissionException, Exception {
        this.checkUserSession();
        try {
            this.sas.repairCluster();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public UserSession login(String username, String password) throws LoginFailedException {
        try {
            log.info("login sas : username=" + username);
            this.sas.authenticate(username, password);
        }
        catch (java.lang.Exception e) {
            log.error("SVA login failed: ", e);
            LoginFailed lf = new LoginFailed();
            lf.setMessage(e.getMessage());
            LoginFailedMsg lfmsg = new LoginFailedMsg();
            lfmsg.setLoginFailedMsg(lf);
            LoginFailedException lfe = new LoginFailedException();
            lfe.setFaultMessage(lfmsg);
            throw lfe;
        }
        UserSession user = new UserSession();
        user.setUsername(username);
        user.setSessionId(UUID.randomUUID().toString());
        this.setUserSession(user);
        return user;
    }

    @Override
    public PingResult ping() {
        if (this.getSasInterface() == null) {
            return null;
        }
        return (PingResult)ConverterUtil.convert(this.sas.ping(), null);
    }

    @Override
    public void abortTask(String taskId) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("abortTask : " + taskId);
        }
        try {
            this.sas.abortTask(UUID.fromString(taskId));
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public void confirmStorageClusterNetworkConfig(String taskId) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("confirmStorageClusterNetworkConfig : " + taskId);
        }
        try {
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            HttpServletRequest servletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            String localAddress = servletRequest.getLocalAddr();
            this.sas.confirmStorageClusterNetworkConfig(UUID.fromString(taskId), localAddress);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public TaskRef exitStorageClusterMaintenanceMode() throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("exitStorageClusterMaintenanceMode");
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.exitStorageClusterMaintenanceMode();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public TaskRef gatherDiagnosticInfo() throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("SAS : gatherDiagnosticInfo");
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.gatherDiagnosticInfo();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public DataHandler getDiagnosticInfo() throws Exception, NoPermissionException {
        this.checkUserSession();
        InputStream in = null;
        try {
            in = this.sas.getDiagnosticInfo();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        final InputStream fin = in;
        DataHandler dh = new DataHandler(new DataSource(){

            @Override
            public String getContentType() {
                return "application/x-zip-compressed";
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return fin;
            }

            @Override
            public String getName() {
                return "";
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
        return dh;
    }

    @Override
    public MapEntry[] getAllParameters() throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("getAllParameters");
        }
        try {
            HashMap<String, Object> map = this.sas.getAllParameters();
            int size = map.size();
            MapEntry[] entries = new MapEntry[size];
            Iterator it = map.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = (String)it.next();
                entries[i] = new MapEntry();
                entries[i].setKey(key);
                entries[i].setValue(map.get(key));
                log.info("key: " + key + "; value: " + entries[i].getValue());
                ++i;
            }
            return entries;
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public MapEntry getParameter(String name) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("getParameter(" + name + ")");
        }
        Object value = null;
        try {
            value = this.sas.getParameter(name);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        MapEntry me = new MapEntry();
        me.setKey(name);
        me.setValue(value);
        return me;
    }

    @Override
    public void setParameter(String name, Object value) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("setParameter(" + name + ", " + (value == null ? "null" : value.toString()) + ")");
        }
        try {
            this.sas.setParameter(name, value);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public AbstractStorageEntity getStorageEntity(String storageEntityId) throws Exception, NoPermissionException {
        this.checkUserSession();
        com.vmware.sva.common.AbstractStorageEntity entity = null;
        try {
            entity = this.sas.getStorageEntity(UUID.fromString(storageEntityId));
            if (log.isInfoEnabled()) {
                log.info("SAS : getStorageEntity ");
                if (entity != null) {
                    log.info("   StorageEntity: " + (Object)((Object)entity.getState()));
                }
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (AbstractStorageEntity)ConverterUtil.convert(entity, null);
    }

    @Override
    public com.vmware.sva.messaging.ws.model.SvaServerInfo getSvaServer(String svaId) throws Exception, NoPermissionException {
        this.checkUserSession();
        SvaServerInfo sva = null;
        try {
            sva = this.sas.getSvaServer(UUID.fromString(svaId));
            if (log.isInfoEnabled()) {
                log.info("SAS : getSvaServer ");
                if (sva != null) {
                    log.info("   svaId: " + sva.getId().toString());
                }
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (com.vmware.sva.messaging.ws.model.SvaServerInfo)ConverterUtil.convert(sva, null);
    }

    @Override
    public TaskRef[] getTaskList() throws Exception, NoPermissionException {
        this.checkUserSession();
        List<com.vmware.sva.common.TaskRef> tasks = null;
        try {
            tasks = this.sas.getTaskList();
            if (log.isInfoEnabled()) {
                log.info("SAS : getTaskList");
                if (tasks != null) {
                    for (com.vmware.sva.common.TaskRef task : tasks) {
                        log.info("   " + task.getTaskId());
                    }
                }
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef[])ConverterUtil.convert(tasks, TaskRef[].class);
    }

    @Override
    public TaskStatus getTaskStatus(String taskId) throws Exception, NoPermissionException {
        this.checkUserSession();
        com.vmware.sva.common.TaskStatus status2 = null;
        try {
            status2 = this.sas.getTaskStatus(UUID.fromString(taskId));
            if (log.isInfoEnabled()) {
                log.info("SAS : getTaskStatus ");
                if (status2 != null) {
                    log.info("   state: " + (Object)((Object)status2.getState()));
                }
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskStatus)ConverterUtil.convert(status2, null);
    }

    @Override
    public void renameStorageCluster(String name) throws Exception, NoPermissionException {
        this.checkUserSession();
        try {
            this.sas.renameStorageCluster(name);
            if (log.isInfoEnabled()) {
                log.info("SAS : renameStorageCluster ");
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public TaskRef renameStorageClusterMember(String svaId, String name) throws Exception, NoPermissionException {
        this.checkUserSession();
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.renameStorageClusterMember(UUID.fromString(svaId), name);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        if (log.isInfoEnabled()) {
            log.info("renameStorageClusterMember for " + svaId + ", task id " + task.getTaskId());
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public void repairPseudoSva() throws Exception, NoPermissionException {
        try {
            this.sas.repairPseudoSva();
            if (log.isInfoEnabled()) {
                log.info("SAS : repairPseudoSVA ");
            }
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public TaskRef replaceStorageClusterMember(String oldSvaId, String newSvaId) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("replaceStorageClusterMember: oldSvaId=" + oldSvaId + ", newSvaId=" + newSvaId);
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.replaceStorageClusterMember(UUID.fromString(oldSvaId), UUID.fromString(newSvaId));
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public void setDefaultParameter(String name, String value) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("setDefaultParameter: key=" + name + ", value==" + value);
        }
        try {
            this.sas.setParameter(name, value);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public TaskRef setStorageClusterNetworkConfig(com.vmware.sva.messaging.ws.model.NetworkInterface config, long timeout) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("setStorageClusterNetworkConfig");
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.setStorageClusterNetworkConfig((NetworkInterface)ConverterUtil.convert(config, null), timeout);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public TaskRef setStorageEntityNetworkConfig(String storageEntityId, com.vmware.sva.messaging.ws.model.NetworkInterface config) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("setStorageClusterNetworkConfig");
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.setStorageEntityNetworkConfig(UUID.fromString(storageEntityId), (NetworkInterface)ConverterUtil.convert(config, null));
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public TaskRef enterStorageClusterMaintenanceMode(boolean stopSvaService) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("enterStorageClusterMaintenanceMode : ");
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.enterStorageClusterMaintenanceMode(stopSvaService);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public TaskRef shutdownStorageClusterMember(String svaId, boolean maintenanceMode) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("shutdownStorageClusterMember : svaId=, maintenanceMode=" + maintenanceMode);
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.shutdownStorageClusterMember(UUID.fromString(svaId), maintenanceMode);
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public void setStorageEntityAccessControlList(String storageEntityId, NfsAccessControl[] acl) throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("setStorageEntityAccessControlList : storageEntityId=" + storageEntityId);
        }
        try {
            this.sas.setStorageEntityAccessControlList(UUID.fromString(storageEntityId), (List)ConverterUtil.convert(acl, ArrayList.class));
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
    }

    @Override
    public TaskRef growStorage() throws Exception, NoPermissionException {
        this.checkUserSession();
        if (log.isInfoEnabled()) {
            log.info("growStorage : ");
        }
        com.vmware.sva.common.TaskRef task = null;
        try {
            task = this.sas.growStorage();
        }
        catch (java.lang.Exception e) {
            throw this.convertException(e);
        }
        return (TaskRef)ConverterUtil.convert(task, null);
    }

    @Override
    public void logout() {
        super.removeCurrentWsSession();
    }

    @Override
    public void noop(boolean validateSession) throws NoPermissionException {
        if (validateSession) {
            this.checkUserSession();
        }
    }
}

