/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;

public class AcidTestTool
extends TestCase {
    protected int recordSize = 1024;
    protected int batchSize = 5;
    protected int workerThinkTime = 500;
    protected Destination target;
    private Random random = new Random();
    private byte[] data;
    private int workerCount = 10;
    private AtomicBoolean ignoreJMSErrors = new AtomicBoolean(false);
    private ActiveMQConnectionFactory factory;
    private Connection connection;
    private AtomicInteger publishedBatches = new AtomicInteger(0);
    private AtomicInteger consumedBatches = new AtomicInteger(0);
    private List<Throwable> errors = Collections.synchronizedList(new ArrayList());

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        this.target = new ActiveMQQueue(((Object)((Object)this)).getClass().getName());
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    private void reconnect() throws InterruptedException, JMSException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.connection = null;
        }
        long reconnectDelay = 1000L;
        while (this.connection == null) {
            if (reconnectDelay > 10000L) {
                reconnectDelay = 10000L;
            }
            try {
                this.connection = this.factory.createConnection();
                this.connection.start();
            }
            catch (JMSException e) {
                Thread.sleep(reconnectDelay);
                reconnectDelay *= 2L;
            }
        }
    }

    public void testAcidTransactions() throws Throwable {
        Worker w;
        System.out.println("Client threads write records using: Record Size: " + this.recordSize + ", Batch Size: " + this.batchSize + ", Worker Think Time: " + this.workerThinkTime);
        this.data = new byte[this.recordSize];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)i;
        }
        System.out.println("==============================================");
        System.out.println("===> Start the server now.");
        System.out.println("==============================================");
        this.reconnect();
        System.out.println("Starting " + this.workerCount + " Workers...");
        ArrayList<ConsumerWorker> workers = new ArrayList<ConsumerWorker>();
        for (int i = 0; i < this.workerCount; ++i) {
            String string = "worker-" + i;
            w = new ConsumerWorker(this.connection.createSession(true, 0), string, 5000L);
            workers.add((ConsumerWorker)w);
            new Thread((Runnable)w, "Consumer:" + string).start();
            w = new ProducerWorker(this.connection.createSession(true, 0), string);
            workers.add((ConsumerWorker)w);
            new Thread((Runnable)w, "Producer:" + string).start();
        }
        System.out.println("Waiting for " + this.workerCount * 10 + " batches to be delivered.");
        while (this.publishedBatches.get() < this.workerCount * 5) {
            System.out.println("Stats: Produced Batches: " + this.publishedBatches.get() + ", Consumed Batches: " + this.consumedBatches.get());
            Thread.sleep(1000L);
        }
        System.out.println("==============================================");
        System.out.println("===> Server is under load now.  Kill it!");
        System.out.println("==============================================");
        this.ignoreJMSErrors.set(true);
        System.out.println("Waiting for all workers to exit due to server shutdown.");
        for (Worker worker : workers) {
            while (!worker.waitForExit(1000L)) {
                System.out.println("==============================================");
                System.out.println("===> Server is under load now.  Kill it!");
                System.out.println("==============================================");
                System.out.println("Stats: Produced Batches: " + this.publishedBatches.get() + ", Consumed Batches: " + this.consumedBatches.get());
            }
        }
        workers.clear();
        if (this.errors.size() > 0) {
            throw this.errors.get(0);
        }
        System.out.println("==============================================");
        System.out.println("===> Start the server now.");
        System.out.println("==============================================");
        this.reconnect();
        System.out.println("Restarted.");
        for (int i = 0; i < this.workerCount; ++i) {
            String string = "worker-" + i;
            w = new ConsumerWorker(this.connection.createSession(true, 0), string, 5000L);
            workers.add((ConsumerWorker)w);
            new Thread((Runnable)w, "Consumer:" + string).start();
        }
        System.out.println("Waiting for restarted consumers to finish consuming all messages..");
        for (Worker worker : workers) {
            while (!worker.waitForExit(5000L)) {
                System.out.println("Waiting for restarted consumers to finish consuming all messages..");
                System.out.println("Stats: Produced Batches: " + this.publishedBatches.get() + ", Consumed Batches: " + this.consumedBatches.get());
            }
        }
        workers.clear();
        System.out.println("Workers finished..");
        System.out.println("Stats: Produced Batches: " + this.publishedBatches.get() + ", Consumed Batches: " + this.consumedBatches.get());
        if (this.errors.size() > 0) {
            throw this.errors.get(0);
        }
    }

    public static void main(String[] args) {
        try {
            AcidTestTool tool = new AcidTestTool();
            tool.setUp();
            tool.testAcidTransactions();
            tool.tearDown();
        }
        catch (Throwable e) {
            System.out.println("Test Failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static /* synthetic */ Random access$100(AcidTestTool x0) {
        return x0.random;
    }

    static /* synthetic */ AtomicInteger access$200(AcidTestTool x0) {
        return x0.publishedBatches;
    }

    static /* synthetic */ AtomicBoolean access$300(AcidTestTool x0) {
        return x0.ignoreJMSErrors;
    }

    static /* synthetic */ List access$400(AcidTestTool x0) {
        return x0.errors;
    }

    static /* synthetic */ AtomicInteger access$500(AcidTestTool x0) {
        return x0.consumedBatches;
    }

    private final class ConsumerWorker
    implements Worker {
        private Session session;
        private MessageConsumer consumer;
        private final long timeout;
        private CountDownLatch doneLatch = new CountDownLatch(1);

        ConsumerWorker(Session session, String workerId, long timeout) throws JMSException {
            this.session = session;
            this.timeout = timeout;
            this.consumer = session.createConsumer(AcidTestTool.this.target, "workerId='" + workerId + "'");
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[FORLOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean waitForExit(long i) throws InterruptedException {
            return this.doneLatch.await(i, TimeUnit.MILLISECONDS);
        }
    }

    private final class ProducerWorker
    implements Worker {
        private Session session;
        private MessageProducer producer;
        private BytesMessage message;
        private CountDownLatch doneLatch = new CountDownLatch(1);

        ProducerWorker(Session session, String workerId) throws JMSException {
            this.session = session;
            this.producer = session.createProducer(AcidTestTool.this.target);
            this.producer.setDeliveryMode(2);
            this.message = session.createBytesMessage();
            this.message.setStringProperty("workerId", workerId);
            this.message.writeBytes(AcidTestTool.this.data);
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[FORLOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean waitForExit(long i) throws InterruptedException {
            return this.doneLatch.await(i, TimeUnit.MILLISECONDS);
        }
    }

    private static interface Worker
    extends Runnable {
        public boolean waitForExit(long var1) throws InterruptedException;
    }
}

