/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.ModuleDeployer;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.repository.util.WSInfoList;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryListener
implements DeploymentConstants {
    protected static final Log log = LogFactory.getLog(RepositoryListener.class);
    protected DeploymentEngine deploymentEngine;
    protected WSInfoList wsInfoList;

    public RepositoryListener(DeploymentEngine deploymentEngine, boolean isClasspath) {
        this.deploymentEngine = deploymentEngine;
        this.wsInfoList = new WSInfoList(deploymentEngine);
        this.init2(isClasspath);
    }

    public void init2(boolean isClasspath) {
        if (!isClasspath) {
            this.init();
        }
        this.loadClassPathModules();
    }

    public void checkModules() {
        File root = this.deploymentEngine.getModulesDir();
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (!DeploymentFileData.isModuleArchiveFile(file.getName())) continue;
                    this.addFileToDeploy(file, this.deploymentEngine.getModuleDeployer(), 1);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.addFileToDeploy(file, this.deploymentEngine.getModuleDeployer(), 1);
            }
        }
    }

    protected boolean isSourceControlDir(File file) {
        String name;
        return file.isDirectory() && ((name = file.getName()).equalsIgnoreCase("CVS") || name.equalsIgnoreCase(".svn"));
    }

    protected void loadClassPathModules() {
        ModuleDeployer deployer = this.deploymentEngine.getModuleDeployer();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> moduleURLs = loader.getResources("META-INF/module.xml");
            while (moduleURLs.hasMoreElements()) {
                try {
                    URI moduleURI;
                    URL url = moduleURLs.nextElement();
                    if (url.getProtocol().equals("file")) {
                        String urlString = url.toString();
                        moduleURI = new URI(urlString.substring(0, urlString.lastIndexOf("/META-INF/module.xml")));
                    } else {
                        String path = url.getPath();
                        int idx = path.lastIndexOf("!/");
                        if (idx == -1 || !path.substring(idx + 2).equals("META-INF/module.xml") || !(moduleURI = new URI(path.substring(0, idx))).getScheme().equals("file")) continue;
                    }
                    log.debug("Deploying module from classpath at '" + moduleURI + "'");
                    File f = new File(moduleURI);
                    this.addFileToDeploy(f, deployer, 1);
                }
                catch (URISyntaxException e) {
                    log.info(e);
                }
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
        String classPath = this.getLocation();
        if (classPath == null) {
            return;
        }
        int lstindex = classPath.lastIndexOf(File.separatorChar);
        File root = new File(classPath = lstindex > 0 ? classPath.substring(0, lstindex) : ".");
        File[] files = root.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory() || !DeploymentFileData.isModuleArchiveFile(file.getName())) continue;
                this.addFileToDeploy(file, deployer, 1);
            }
        }
        for (ClassLoader cl = this.deploymentEngine.getAxisConfig().getModuleClassLoader(); cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)cl).getURLs();
            for (int i = 0; urls != null && i < urls.length; ++i) {
                String path = urls[i].getPath();
                if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
                    path = path.substring(1);
                }
                try {
                    path = URLDecoder.decode(path, Utils.defaultEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                File file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
                if (!file.isFile() || !DeploymentFileData.isModuleArchiveFile(file.getName())) continue;
                this.addFileToDeploy(file, deployer, 1);
            }
        }
        this.deploymentEngine.doDeploy();
    }

    protected String getLocation() {
        try {
            Class clazz = Loader.loadClass("org.apache.axis2.engine.AxisEngine");
            URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
            String location = url.toString();
            if (location.startsWith("jar")) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
                location = url.toString();
            }
            if (location.startsWith("file")) {
                File file = Utils.toFile(url);
                return file.getAbsolutePath();
            }
            return url.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void checkServices() {
        this.findServicesInDirectory();
        this.loadOtherDirectories();
        this.update();
    }

    public void init() {
        this.wsInfoList.init();
        this.checkModules();
        this.deploymentEngine.doDeploy();
    }

    private void loadOtherDirectories() {
        for (Map.Entry<String, Map<String, Deployer>> entry : this.deploymentEngine.getDeployers().entrySet()) {
            String directory = entry.getKey();
            Map<String, Deployer> extensionMap = entry.getValue();
            for (String extension : extensionMap.keySet()) {
                this.findFileForGivenDirectory(directory, extension);
            }
        }
    }

    private void findFileForGivenDirectory(String dir, String extension) {
        try {
            File[] files;
            File directory = this.deploymentEngine.getRepositoryDir();
            String[] strings = dir.split("/");
            for (int i = 0; i < strings.length; ++i) {
                directory = new File(directory, strings[i]);
            }
            if (directory.exists() && (files = directory.listFiles()) != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (this.isSourceControlDir(file) || !extension.equals(DeploymentFileData.getFileExtension(file.getName()))) continue;
                    this.addFileToDeploy(file, this.deploymentEngine.getDeployer(dir, extension), 2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void findServicesInDirectory() {
        File root = this.deploymentEngine.getServicesDir();
        File[] files = root.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (this.isSourceControlDir(file)) continue;
                if (!file.isDirectory()) {
                    if (DeploymentFileData.isServiceArchiveFile(file.getName())) {
                        this.addFileToDeploy(file, this.deploymentEngine.getServiceDeployer(), 0);
                        continue;
                    }
                    String ext = DeploymentFileData.getFileExtension(file.getName());
                    Deployer deployer = this.deploymentEngine.getDeployerForExtension(ext);
                    if (deployer == null) continue;
                    this.addFileToDeploy(file, deployer, 0);
                    continue;
                }
                if ("lib".equalsIgnoreCase(file.getName())) continue;
                this.addFileToDeploy(file, this.deploymentEngine.getServiceDeployer(), 0);
            }
        }
    }

    public void startListener() {
        this.checkServices();
    }

    public void update() {
        this.wsInfoList.update();
    }

    public void updateRemote() throws Exception {
        this.findServicesInDirectory();
        this.update();
    }

    public void addFileToDeploy(File file, Deployer deployer, int type) {
        this.wsInfoList.addWSInfoItem(file, deployer, type);
    }
}

