/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.http.AbstractAgent;
import org.apache.axis2.transport.http.CustomListener;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;

public class ListingAgent
extends AbstractAgent {
    private static final Log log = LogFactory.getLog(ListingAgent.class);
    private static final String LIST_MULTIPLE_SERVICE_JSP_NAME = "listServices.jsp";
    private static final String LIST_SINGLE_SERVICE_JSP_NAME = "listSingleService.jsp";
    private static final String LIST_FAULTY_SERVICES_JSP_NAME = "listFaultyService.jsp";
    public static final String RUNNING_PORT = "RUNNING_PORT";

    public ListingAgent(ConfigurationContext aConfigContext) {
        super(aConfigContext);
    }

    private void addTransportListener(String schema, int port) {
        try {
            TransportInDescription trsIn = this.configContext.getAxisConfiguration().getTransportIn(schema);
            if (trsIn == null) {
                trsIn = new TransportInDescription(schema);
                CustomListener httspReceiver = new CustomListener(port, schema);
                httspReceiver.init(this.configContext, trsIn);
                trsIn.setReceiver(httspReceiver);
                this.configContext.getListenerManager().addListener(trsIn, true);
            }
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.initTransportListener(httpServletRequest);
        String query = httpServletRequest.getQueryString();
        if (query != null) {
            if (query.indexOf("wsdl2") > 0 || query.indexOf("wsdl") > 0 || query.indexOf("xsd") > 0 || query.indexOf("policy") > 0) {
                this.processListService(httpServletRequest, httpServletResponse);
            } else {
                super.handle(httpServletRequest, httpServletResponse);
            }
        } else {
            super.handle(httpServletRequest, httpServletResponse);
        }
    }

    protected void initTransportListener(HttpServletRequest httpServletRequest) {
        String filePart;
        try {
            filePart = httpServletRequest.getRequestURL().toString();
        }
        catch (Throwable t) {
            log.info("Old Servlet API (fallback to HttpServletRequest.getRequestURI) :" + t);
            filePart = httpServletRequest.getRequestURI();
        }
        int ipindex = filePart.indexOf("//");
        if (ipindex >= 0) {
            String ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            String portstr = seperatorIndex >= 0 ? ip.substring(seperatorIndex + 1, slashIndex) : "80";
            try {
                this.addTransportListener(httpServletRequest.getScheme(), Integer.parseInt(portstr));
            }
            catch (NumberFormatException e) {
                log.debug(e.toString(), e);
            }
        }
    }

    protected void processListFaultyServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String serviceName = req.getParameter("serviceName");
        if (serviceName != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            try {
                req.getSession().setAttribute("singleservice", service);
            }
            catch (Throwable t) {
                log.info("Old Servlet API :" + t);
            }
        }
        this.renderView(LIST_FAULTY_SERVICES_JSP_NAME, req, res);
    }

    protected void processIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.processListServices(httpServletRequest, httpServletResponse);
    }

    private String extractHostAndPort(String filePart, boolean isHttp) {
        int ipindex = filePart.indexOf("//");
        String ip = null;
        if (ipindex >= 0) {
            String port;
            ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            if (seperatorIndex >= 0) {
                port = ip.substring(seperatorIndex + 1, slashIndex);
                ip = ip.substring(0, seperatorIndex);
            } else {
                ip = ip.substring(0, slashIndex);
                port = "80";
            }
            if (isHttp) {
                this.configContext.setProperty(RUNNING_PORT, port);
            }
        }
        return ip;
    }

    public void processExplicitSchemaAndWSDL(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
        String filePart = req.getRequestURL().toString();
        String schema = filePart.substring(filePart.lastIndexOf("/") + 1, filePart.length());
        if (services != null && !services.isEmpty()) {
            for (AxisService service : services.values()) {
                InputStream stream = service.getClassLoader().getResourceAsStream("META-INF/" + schema);
                if (stream == null) continue;
                ServletOutputStream out = res.getOutputStream();
                res.setContentType("text/xml");
                IOUtils.copy(stream, out, true);
                return;
            }
        }
    }

    public static void copy(InputStream stream, OutputStream ostream) throws IOException {
        IOUtils.copy(stream, ostream, false);
    }

    public String extractServiceName(String urlString) {
        String serviceName;
        int n = urlString.indexOf(this.configContext.getServiceContextPath());
        if (n != -1 && (serviceName = urlString.substring(n + this.configContext.getServiceContextPath().length(), urlString.length())).length() > 0) {
            if (serviceName.charAt(0) == '/') {
                serviceName = serviceName.substring(1);
            }
            return serviceName;
        }
        return urlString.substring(urlString.lastIndexOf("/") + 1, urlString.length());
    }

    public void processListService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String url;
        try {
            url = req.getRequestURL().toString();
        }
        catch (Throwable t) {
            log.info("Old Servlet API (Fallback to HttpServletRequest.getRequestURI) :" + t);
            url = req.getRequestURI();
        }
        String serviceName = this.extractServiceName(url);
        HashMap<String, AxisService> services = this.configContext.getAxisConfiguration().getServices();
        String query = req.getQueryString();
        int wsdl2 = query.indexOf("wsdl2");
        int wsdl = query.indexOf("wsdl");
        int xsd = query.indexOf("xsd");
        int policy = query.indexOf("policy");
        if (services != null && !services.isEmpty()) {
            AxisService serviceObj = services.get(serviceName);
            if (serviceObj != null) {
                AxisService axisService = serviceObj;
                boolean isHttp = "http".equals(req.getScheme());
                if (wsdl2 >= 0) {
                    res.setContentType("text/xml");
                    String ip = this.extractHostAndPort(url, isHttp);
                    String wsdlName = req.getParameter("wsdl2");
                    int ret = axisService.printWSDL2(res.getOutputStream(), ip, wsdlName);
                    if (ret == 0) {
                        res.sendRedirect("");
                    } else if (ret == -1) {
                        res.sendError(404);
                    }
                    return;
                }
                if (wsdl >= 0) {
                    ServletOutputStream out = res.getOutputStream();
                    res.setContentType("text/xml");
                    String ip = this.extractHostAndPort(url, isHttp);
                    String wsdlName = req.getParameter("wsdl");
                    if (wsdlName != null && wsdlName.length() > 0) {
                        axisService.printUserWSDL(out, wsdlName);
                        out.flush();
                        out.close();
                    } else {
                        axisService.printWSDL(out, ip);
                        out.flush();
                        out.close();
                    }
                    return;
                }
                if (xsd >= 0) {
                    res.setContentType("text/xml");
                    int ret = axisService.printXSD(res.getOutputStream(), req.getParameter("xsd"));
                    if (ret == 0) {
                        res.sendRedirect("");
                    } else if (ret == -1) {
                        res.sendError(404);
                    }
                    return;
                }
                if (policy >= 0) {
                    ExternalPolicySerializer serializer = new ExternalPolicySerializer();
                    serializer.setAssertionsToFilter(this.configContext.getAxisConfiguration().getLocalPolicyAssertions());
                    String idParam = req.getParameter("id");
                    if (idParam != null) {
                        Policy targetPolicy = this.findPolicy(idParam, axisService);
                        if (targetPolicy != null) {
                            try {
                                ServletOutputStream out = res.getOutputStream();
                                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
                                res.setContentType("application/wspolicy+xml");
                                targetPolicy.serialize(writer);
                                writer.flush();
                            }
                            catch (XMLStreamException e) {
                                throw new ServletException("Error occured when serializing the Policy", e);
                            }
                            catch (FactoryConfigurationError e) {
                                throw new ServletException("Error occured when serializing the Policy", e);
                            }
                        } else {
                            ServletOutputStream out = res.getOutputStream();
                            res.setContentType("text/html");
                            String outStr = "<b>No policy found for id=" + idParam + "</b>";
                            out.write(outStr.getBytes());
                        }
                    } else {
                        PolicyInclude policyInclude = axisService.getPolicyInclude();
                        Policy effecPolicy = policyInclude.getEffectivePolicy();
                        if (effecPolicy != null) {
                            try {
                                ServletOutputStream out = res.getOutputStream();
                                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
                                res.setContentType("application/wspolicy+xml");
                                effecPolicy.serialize(writer);
                                writer.flush();
                            }
                            catch (XMLStreamException e) {
                                throw new ServletException("Error occured when serializing the Policy", e);
                            }
                            catch (FactoryConfigurationError e) {
                                throw new ServletException("Error occured when serializing the Policy", e);
                            }
                        } else {
                            ServletOutputStream out = res.getOutputStream();
                            res.setContentType("text/html");
                            String outStr = "<b>No effective policy for " + serviceName + " service</b>";
                            out.write(outStr.getBytes());
                        }
                    }
                    return;
                }
                try {
                    req.getSession().setAttribute("singleservice", serviceObj);
                }
                catch (Throwable t) {
                    log.info("Old Servlet API :" + t);
                }
            } else {
                try {
                    req.getSession().setAttribute("singleservice", null);
                }
                catch (Throwable t) {
                    log.info("Old Servlet API :" + t);
                }
                res.sendError(404, url);
            }
        }
        this.renderView(LIST_SINGLE_SERVICE_JSP_NAME, req, res);
    }

    protected void processListServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.populateSessionInformation(req);
        try {
            req.getSession().setAttribute("errprservicemap", this.configContext.getAxisConfiguration().getFaultyServices());
        }
        catch (Throwable t) {
            log.info("Old Servlet API :" + t);
        }
        this.renderView(LIST_MULTIPLE_SERVICE_JSP_NAME, req, res);
    }

    private Policy findPolicy(String id, AxisDescription des) {
        ArrayList policyElements = des.getPolicyInclude().getPolicyElements();
        PolicyRegistry registry = des.getPolicyInclude().getPolicyRegistry();
        Policy policy = registry.lookup(id);
        if (policy != null) {
            return policy;
        }
        for (Object policyComponent : policyElements) {
            if (!(policyComponent instanceof Policy) || !id.equals(((Policy)policyComponent).getId())) continue;
            return (Policy)policyComponent;
        }
        Iterator<? extends AxisDescription> iterator = des.getChildren();
        while (iterator.hasNext()) {
            AxisDescription child = iterator.next();
            policy = this.findPolicy(id, child);
            if (policy == null) continue;
            return policy;
        }
        return null;
    }
}

