/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.pseudosvadomain;

import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.common.PingResult;
import com.vmware.sva.common.PseudoSvaServerInfo;
import com.vmware.sva.common.mgmtevents.AbstractManagementEvent;
import com.vmware.sva.common.util.PseudoSvaUtility;
import com.vmware.sva.domainservice.AbstractManagementRequest;
import com.vmware.sva.domainservice.AbstractRemoteRequestService;
import com.vmware.sva.domainservice.ManagementMessagingFactory;
import com.vmware.sva.domainservice.ManagementPingRequest;
import com.vmware.sva.domainservice.ManagementPingResponse;
import com.vmware.sva.domainservice.SendManagementEventRequest;
import com.vmware.sva.domainservice.requests.GenericAuthenticateRequest;
import com.vmware.sva.domainservice.requests.GenericGetDiagnosticInfoRequest;
import com.vmware.sva.domainservice.requests.GenericGetSvaVersionRequest;
import com.vmware.sva.domainservice.responses.GenericAuthenticateResponse;
import com.vmware.sva.domainservice.responses.GenericGetDiagnosticInfoResponse;
import com.vmware.sva.domainservice.responses.GenericGetSvaVersionResponse;
import com.vmware.sva.messaging.interfaces.MessagingInterface;
import com.vmware.sva.messaging.interfaces.PseudosvaInterface;
import com.vmware.sva.pseudosvadomain.PseudoSvaServerInfoRequest;
import com.vmware.sva.pseudosvadomain.PseudoSvaServerInfoResponse;
import com.vmware.sva.pseudosvadomain.requests.DestroyPseudoSvaRequest;
import com.vmware.sva.pseudosvadomain.requests.EnterMaintenanceModeRequest;
import com.vmware.sva.pseudosvadomain.requests.ExitMaintenanceModeRequest;
import com.vmware.sva.pseudosvadomain.responses.DestroyPseudoSvaResponse;
import com.vmware.sva.pseudosvadomain.responses.EnterMaintenanceModeResponse;
import com.vmware.sva.pseudosvadomain.responses.ExitMaintenanceModeResponse;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class PseudoSvaManagementClientService
extends AbstractRemoteRequestService
implements PseudosvaInterface {
    private static final long serialVersionUID = 1L;
    public static final UUID SERVICE_ID = UUID.fromString("f8c9fd59-33a2-4d64-a116-637f55627f94");
    private static final String SERVICE_NAME = "PseudoSvaManagementClientService";
    private final MessagingInterface messagingService = ManagementMessagingFactory.getMessagingInterface();

    public PseudoSvaManagementClientService(BusinessLogicDomainServiceAPI domain) throws Exception {
        super(SERVICE_ID, SERVICE_NAME, domain);
    }

    @Override
    public PingResult ping() {
        ManagementPingResponse response;
        ManagementPingRequest request = new ManagementPingRequest(this.getServiceId());
        try {
            this.log(Level.INFO, "Received PING");
            response = (ManagementPingResponse)this.processRequest((AbstractManagementRequest)request);
        }
        catch (Exception e) {
            String errorMsg = "ping should never generate an exception: " + e.getMessage();
            this.log(Level.SEVERE, errorMsg);
            assert (false) : errorMsg;
            return null;
        }
        return response.getResponse();
    }

    @Override
    public PseudoSvaServerInfo getPseudoSvaServerInfo(String pseudoSvaIP) throws Exception {
        PseudoSvaServerInfoRequest request = new PseudoSvaServerInfoRequest(this.getServiceId(), pseudoSvaIP);
        PseudoSvaServerInfoResponse response = (PseudoSvaServerInfoResponse)this.processRequest(request);
        PseudoSvaServerInfo serverInfo = response.getServerInfo();
        if (serverInfo == null) {
            throw response.getException();
        }
        return serverInfo;
    }

    @Override
    public String getSvaVersion() throws Exception {
        GenericGetSvaVersionResponse response = (GenericGetSvaVersionResponse)this.processRequest((AbstractManagementRequest)new GenericGetSvaVersionRequest(this.getServiceId()));
        if (response.isSuccess()) {
            return response.getSvaVersion();
        }
        throw response.getException();
    }

    @Override
    public void authenticate(String user, String password) throws Exception {
        byte[] pass = password.getBytes("ISO-8859-1");
        byte[] hash = PseudoSvaUtility.rehashPassword(user, pass);
        GenericAuthenticateRequest request = new GenericAuthenticateRequest(this.getServiceId(), user, hash);
        GenericAuthenticateResponse resp = (GenericAuthenticateResponse)this.processRequest((AbstractManagementRequest)request);
        if (!resp.isSuccess()) {
            this.log(Level.WARNING, "Failed login attempt from " + user);
        }
        PseudoSvaUtility.zeroOutCachedBytes(pass);
        PseudoSvaUtility.zeroOutCachedBytes(hash);
    }

    @Override
    public void enterMaintenanceMode(boolean shutdownRmi) throws Exception {
        EnterMaintenanceModeRequest request = new EnterMaintenanceModeRequest(this.getServiceId(), shutdownRmi);
        EnterMaintenanceModeResponse response = (EnterMaintenanceModeResponse)this.processRequest(request);
        if (!response.isSuccess()) {
            throw response.getException();
        }
    }

    @Override
    public void exitMaintenanceMode() throws Exception {
        ExitMaintenanceModeRequest request = new ExitMaintenanceModeRequest(this.getServiceId());
        ExitMaintenanceModeResponse response = (ExitMaintenanceModeResponse)this.processRequest(request);
        if (!response.isSuccess()) {
            throw response.getException();
        }
    }

    @Override
    public void restart() throws Exception {
        System.exit(1);
    }

    @Override
    public String faultInsertion(List<String> args) throws Exception {
        return null;
    }

    @Override
    public String listConstants() throws Exception {
        return "Mock List of constants";
    }

    @Override
    public String listDebug() throws Exception {
        return "Mock List of Debug properties";
    }

    public void start() throws Exception {
        super.start();
        this.messagingService.startMessagingService(this);
    }

    public void stop() throws Exception {
        super.stop();
        this.messagingService.stopMessagingService(this);
    }

    @Override
    public void destroyPseudoSva() throws Exception {
        DestroyPseudoSvaResponse response = (DestroyPseudoSvaResponse)this.processRequest(new DestroyPseudoSvaRequest(this.getServiceId()));
        if (!response.isSuccess()) {
            throw response.getException();
        }
    }

    @Override
    public InputStream getDiagnosticInfo() throws Exception {
        GenericGetDiagnosticInfoRequest request = new GenericGetDiagnosticInfoRequest(this.getServiceId(), false);
        GenericGetDiagnosticInfoResponse response = (GenericGetDiagnosticInfoResponse)this.processRequest((AbstractManagementRequest)request);
        if (!response.isSuccess()) {
            throw response.getException();
        }
        return new FileInputStream(response.getBundlePath());
    }

    protected void handleManagementEvent(SendManagementEventRequest request) {
        AbstractManagementEvent event = request.getEvent();
        this.log(Level.FINE, this.getName() + ".handleManagementEvent(): received management event " + event);
        this.messagingService.sendEvent(event);
    }
}

