/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.pseudosvadomain;

import com.vmware.sva.common.PseudoSVAPathUtil;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.database.AbstractBldDatabase;
import com.vmware.sva.pseudosvadomain.PseudoSvaDomain;
import com.vmware.sva.zkmgmtserver.ZkMgmtServer;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class PseudoSvaServer {
    private static final Logger logger = Logger.getLogger(PseudoSvaServer.class.getName());

    public static void main(String[] args) throws RemoteException, MalformedURLException, Exception {
        if (args.length > 0) {
            PseudoSVAPathUtil.setPsvaConfigPath(args[0]);
        } else {
            PseudoSVAPathUtil.setPsvaConfigPath("");
        }
        SvaConstants.class.getClassLoader();
        if (SvaDebug.CLUSTER_SERVICE_LOG_HEARTBEAT > 0L) {
            Timer timer = new Timer("VSA Cluster Service Heartbeat Logger", true);
            timer.schedule((TimerTask)new LogHeartbeatTask(), SvaDebug.CLUSTER_SERVICE_LOG_HEARTBEAT, SvaDebug.CLUSTER_SERVICE_LOG_HEARTBEAT);
        }
        if (SvaConstants.DESTROY_BEFORE_RESTART) {
            PseudoSvaServer.destroy();
        }
        try {
            PseudoSvaDomain psvaBld = new PseudoSvaDomain();
            psvaBld.start();
            logger.log(Level.INFO, "DONE");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to start PseudoSvaDomain" + PseudoSvaDomain.class.getName(), e);
            System.exit(2);
        }
    }

    private static void destroy() {
        try {
            logger.log(Level.INFO, "Attempting to destroy");
            ZkMgmtServer.deleteZooKeeperFiles();
            logger.log(Level.INFO, "Done deleting ZooKeeper state");
            PseudoSvaServer.deleteDatabases();
            logger.log(Level.INFO, "Done deleting SVA state");
            SvaConstants.setProp("pseudosva.destroy", "false");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Destroy failed, exiting...", e);
            System.exit(1);
        }
    }

    private static void deleteDatabases() throws Exception {
        String[] dirs;
        assert (SvaConstants.DESTROY_BEFORE_RESTART) : "Can only delete SVA databases when attempting to destroy";
        for (String dir : dirs = AbstractBldDatabase.getDatabasePaths()) {
            File d = new File(dir);
            if (!d.exists()) continue;
            FileUtils.deleteDirectory((File)d);
        }
        File f = new File(SvaConstants.PSEUDOSVA_METADATA_FILE);
        if (!f.delete()) {
            logger.log(Level.WARNING, "Failed to delete " + SvaConstants.PSEUDOSVA_METADATA_FILE);
        }
    }

    private static class LogHeartbeatTask
    extends TimerTask {
        private LogHeartbeatTask() {
        }

        @Override
        public void run() {
            logger.log(Level.INFO, "OK");
        }
    }
}

