/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.jms.test;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.messaging.jms.test.EasySSLProtocolSocketFactory;
import com.vmware.sva.messaging.ws.sas.NoPermissionException;
import com.vmware.sva.messaging.ws.sas.SasserviceStub;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.TrustManager;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class TestMessaging {
    private ClassPathXmlApplicationContext ctx;
    private DefaultMessageListenerContainer subscriber;

    @Test
    public void testWebService() throws Exception {
        SasserviceStub sas = new SasserviceStub("https://localhost:" + SvaConstants.HTTPS_PORT + "/services/sasservice");
        TestMessaging.updateStub(sas);
        sas.login("testuser", "testpass");
        sas.enterStorageClusterMaintenanceMode(false);
        sas.logout();
        try {
            sas.enterStorageClusterMaintenanceMode(false);
        }
        catch (NoPermissionException e) {
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testJms() {
        this.startSubscriber();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ClassPathXmlApplicationContext getAppContext() {
        if (this.ctx == null) {
            this.ctx = new ClassPathXmlApplicationContext(new String[]{"classpath:com/vmware/sva/messaging/jms/test/jms-client.xml"});
        }
        return this.ctx;
    }

    private void startSubscriber() {
        if (this.subscriber != null) {
            return;
        }
        ActiveMQSslConnectionFactory sslConn = (ActiveMQSslConnectionFactory)this.getAppContext().getBean("sslConnectionFactory");
        try {
            sslConn.setKeyAndTrustManagers(null, new TrustManager[]{new EasySSLProtocolSocketFactory.EasyX509TrustManager(null)}, SecureRandom.getInstance("SHA1PRNG"));
            this.subscriber = (DefaultMessageListenerContainer)this.getAppContext().getBean("clusterTopicSubscriber");
        }
        catch (NoSuchAlgorithmException e1) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    private static void updateStub(Stub stub) {
        EasySSLProtocolSocketFactory sslFactory = new EasySSLProtocolSocketFactory();
        Protocol myhttps = new Protocol("https", (SecureProtocolSocketFactory)sslFactory, SvaConstants.HTTPS_PORT);
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        if (params == null) {
            params = new HttpConnectionManagerParams();
            httpConnectionManager.setParams(params);
        }
        params.setMaxTotalConnections(10);
        params.setDefaultMaxConnectionsPerHost(10);
        HttpClient httpClient = new HttpClient((HttpConnectionManager)httpConnectionManager);
        ServiceClient serviceClient = stub._getServiceClient();
        Options opts = stub._getServiceClient().getOptions();
        opts.setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)myhttps);
        opts.setManageSession(true);
        ConfigurationContext context = serviceClient.getServiceContext().getConfigurationContext();
        context.setProperty("CACHED_HTTP_CLIENT", (Object)httpClient);
    }
}

