/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtcli;

import com.vmware.sva.common.PseudoSvaClusterMetadata;
import com.vmware.sva.common.PseudoSvaPasswordInfo;
import com.vmware.sva.common.RmiUtilities;
import com.vmware.sva.zkmgmtserver.ZkConfiguration;
import com.vmware.sva.zkmgmtserver.ZkMgmtServerInterface;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class ZkMgmtCli {
    private static ZkMgmtServerInterface zkMgmtSvr;
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;

    public static void main(String[] args) {
        int ret = 0;
        if (args.length < 2) {
            ZkMgmtCli.printUsage();
        } else {
            InetAddress svrAddress = null;
            try {
                svrAddress = InetAddress.getByName(args[0]);
            }
            catch (UnknownHostException e) {
                System.err.println("Invalid server \"" + args[0] + "\": " + e.getMessage());
                System.exit(1);
            }
            try {
                zkMgmtSvr = ZkMgmtCli.getZkMgmtSvrRmiObject(svrAddress);
            }
            catch (Exception e) {
                System.err.println("Could not access server: " + e);
                System.exit(1);
            }
            if (args.length == 2) {
                if (args[1].equals("start")) {
                    ret = ZkMgmtCli.startZk();
                } else if (args[1].equals("stop")) {
                    ret = ZkMgmtCli.stopZk(false);
                } else if (args[1].equals("cleanup")) {
                    ret = ZkMgmtCli.stopZk(true);
                } else if (args[1].equals("get")) {
                    ret = ZkMgmtCli.getConfig();
                } else if (args[1].equals("setpasswd")) {
                    ret = ZkMgmtCli.setPasswd(Arrays.copyOfRange(args, 2, args.length));
                } else {
                    System.out.println(args[1] + " Not supported");
                    ZkMgmtCli.printUsage();
                    ret = 1;
                }
            } else if (args.length % 2 != 0) {
                System.out.println("In correct number of args ");
                ZkMgmtCli.printUsage();
                ret = 1;
            } else if (args[1].equals("set")) {
                ret = ZkMgmtCli.setConfig(Arrays.copyOfRange(args, 2, args.length));
            } else {
                ZkMgmtCli.printUsage();
                ret = 1;
            }
        }
        System.exit(ret);
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("\tzkmgmtcli <rmi server address> set <psva/sva> <local Id> [ <service ID> <server address> ... ]");
        System.out.println("\tzkmgmtcli <rmi server address> get");
        System.out.println("\tzkmgmtcli <rmi server address> start");
        System.out.println("\tzkmgmtcli <rmi server address> stop");
        System.out.println("\tzkmgmtcli <rmi server address> cleanup");
        System.out.println("\tzkmgmtcli <rmi server address> setpasswd user oldpasswd newpasswd overwritepass=<true|false>");
    }

    private static ZkMgmtServerInterface getZkMgmtSvrRmiObject(InetAddress address) throws RemoteException, NotBoundException {
        return (ZkMgmtServerInterface)RmiUtilities.getRemoteObject(address, "ZkMgmtServer");
    }

    private static int startZk() {
        try {
            zkMgmtSvr.startZooKeeper();
        }
        catch (Exception e) {
            System.err.println("Could not start zookeeper: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private static int stopZk(boolean cleanup) {
        try {
            zkMgmtSvr.stopZooKeeper(cleanup);
        }
        catch (Exception e) {
            System.err.println("Could not stop zookeeper: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private static int getConfig() {
        try {
            ZkConfiguration zkConfig = zkMgmtSvr.getZkConfiguration();
            if (zkConfig == null) {
                System.out.println("No current configuration");
            } else {
                System.out.println("Running = " + zkConfig.getRunning());
                System.out.println("Local ZooKeeper service ID = " + zkConfig.getLocalId());
                Map servers = zkConfig.getServers();
                Iterator i$ = servers.keySet().iterator();
                while (i$.hasNext()) {
                    int serverId = (Integer)i$.next();
                    InetAddress address = (InetAddress)servers.get(serverId);
                    System.out.println("\tServer " + serverId + " address = " + address.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Could not get zookeeper configuration: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private static int setConfig(String[] args) {
        int localId = -1;
        String cur = null;
        try {
            int serverId = -1;
            localId = Integer.parseInt(args[1]);
            ZkConfiguration zkConfig = new ZkConfiguration(true, localId, null);
            if (args[0].equals("psva")) {
                zkConfig.pseudoSva(true);
            } else if (args[0].equals("sva")) {
                zkConfig.pseudoSva(false);
            } else {
                throw new Exception("psva/sva not specified");
            }
            String[] arr$ = Arrays.copyOfRange(args, 2, args.length);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String arg;
                cur = arg = arr$[i$];
                if (serverId == -1) {
                    serverId = Integer.parseInt(arg);
                    continue;
                }
                zkConfig.addServer(serverId, InetAddress.getByName(arg));
                serverId = -1;
            }
            cur = null;
            System.out.println("Set configuration to: \n" + zkConfig.getZkConfigString());
            zkMgmtSvr.setZkConfiguration(zkConfig);
        }
        catch (Exception e) {
            if (localId == -1) {
                System.err.println("Invalid or missing local id");
            } else if (cur != null) {
                System.err.println("Invalid arg: " + cur + ": " + e.getMessage());
            } else {
                System.err.println("Failed to set ZK configuration: " + e.getMessage());
            }
            return 1;
        }
        return 0;
    }

    private static int setPasswd(String[] args) {
        PseudoSvaPasswordInfo pinfo = null;
        try {
            pinfo = new PseudoSvaPasswordInfo(args[0], args[1].getBytes("ISO-8859-1"), args[2].getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Failed to get bytes " + e.getMessage());
        }
        HashMap<String, PseudoSvaPasswordInfo> list = new HashMap<String, PseudoSvaPasswordInfo>();
        list.put(pinfo.getUsername(), pinfo);
        PseudoSvaClusterMetadata mdata = new PseudoSvaClusterMetadata(list, UUID.randomUUID());
        try {
            System.out.println("Setting " + mdata.toString());
            String[] str = args[3].split("=");
            boolean force = false;
            if (!str[0].equals("overwritepass")) {
                System.out.println("Unrecognized flag " + str[0] + " try overwritepass=<true|flase>");
                return 1;
            }
            force = Boolean.parseBoolean(str[1]);
            zkMgmtSvr.setClusterMetaData(mdata, force);
        }
        catch (Exception e) {
            System.err.println("Failed to set meta data " + e.getMessage());
            return 1;
        }
        return 0;
    }
}

