/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserver;

import java.io.File;
import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.server.PurgeTxnLog;

public class PurgeZooKeeperTxnLog
extends TimerTask {
    private final File dataDir;
    private final File snapDir;
    private final int keepNumFiles;
    private Logger logger = null;
    private static final Object lock = new Object();

    public PurgeZooKeeperTxnLog(String dataLogDir, String snapDir, int keepNumFiles) {
        this.dataDir = new File(dataLogDir);
        this.snapDir = new File(snapDir);
        this.keepNumFiles = keepNumFiles;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = lock;
        synchronized (object) {
            this.logger.log(Level.FINE, "Starting LogPurger");
            try {
                PurgeTxnLog.purge(this.dataDir, this.snapDir, this.keepNumFiles);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Unable to purge ZooKeeper transaction logs ", e.getMessage());
            }
            this.logger.log(Level.FINE, "Leaving LogPurger");
        }
    }
}

