/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.DiskState;
import java.util.UUID;

public class Disk
extends AbstractUniqueObject {
    private UUID ownerSvaId;
    private DiskState state;
    private double syncProgress;
    private boolean diskSynced = true;
    private long timeToSyncComplete;
    private static final long serialVersionUID = 1L;

    public Disk() {
    }

    public Disk(UUID id, String name) {
        super(id, name);
    }

    public Disk(UUID id, String name, UUID ownerSvaId, DiskState state, boolean syncState, int syncProgress, long timeToSyncComplete) {
        super(id, name);
        this.ownerSvaId = ownerSvaId;
        this.state = state;
        this.diskSynced = syncState;
        this.syncProgress = (double)syncProgress / 100.0;
        this.timeToSyncComplete = timeToSyncComplete;
    }

    public UUID getOwnerSvaId() {
        return this.ownerSvaId;
    }

    public DiskState getState() {
        return this.state;
    }

    public boolean isDiskSynced() {
        return this.diskSynced;
    }

    public double getSyncProgress() {
        return this.syncProgress;
    }

    public long getTimeToSyncComplete() {
        return this.timeToSyncComplete;
    }

    public void setOwnerSvaId(UUID ownerSvaId) {
        this.ownerSvaId = ownerSvaId;
    }

    public void setState(DiskState state) {
        this.state = state;
    }

    public void setDiskSynced(boolean diskSynced) {
        this.diskSynced = diskSynced;
    }

    public void setSyncProgress(int syncProgress) {
        this.syncProgress = syncProgress;
    }

    public void setTimeToSyncComplete(long timeToSyncComplete) {
        this.timeToSyncComplete = timeToSyncComplete;
    }
}

