/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.SerialGeneration;
import com.vmware.sva.common.SerialMinorVersionUtils;
import com.vmware.sva.common.SimpleSerialGenerationInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class HistorySerialGenerationInfo
extends SimpleSerialGenerationInfo {
    private final NavigableMap<String, Short> map = new TreeMap<String, Short>();
    private final int numEntries;

    public HistorySerialGenerationInfo(Reader in) throws IOException {
        String line;
        BufferedReader bufferedReader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        int lineno = 0;
        int numEntries = 0;
        while ((line = bufferedReader.readLine()) != null) {
            ++lineno;
            if (line.startsWith("#")) continue;
            String[] items = line.split(" ");
            if (items.length != 3) {
                throw new IOException("Line " + lineno + ": Wrong number of items: " + line);
            }
            String classname = items[0];
            int generationNumber = -1;
            IndexOutOfBoundsException cause = null;
            try {
                generationNumber = Integer.parseInt(items[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                SerialGeneration.get(generationNumber);
            }
            catch (IndexOutOfBoundsException e) {
                generationNumber = -1;
                cause = e;
            }
            if (generationNumber < 0) {
                throw new IOException("Line " + lineno + ": Bad generation number: " + line, cause);
            }
            short serialMinorVersion = -1;
            try {
                serialMinorVersion = Short.parseShort(items[2]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (serialMinorVersion < 1) {
                throw new IOException("Line " + lineno + ": Bad serial minor version: " + line);
            }
            if (!this.addEntry(line, lineno, classname, generationNumber, serialMinorVersion)) continue;
            ++numEntries;
        }
        this.numEntries = numEntries;
    }

    private boolean addEntry(String line, int lineno, String classname, int generationNumber, short serialMinorVersion) throws IOException {
        try {
            Class<?> cl = Class.forName(classname);
            short currentVersion = SerialMinorVersionUtils.getSerialMinorVersion(cl);
            if (serialMinorVersion > currentVersion) {
                throw new IOException("Line " + lineno + ": Serial minor version number " + serialMinorVersion + " is higher than current version " + currentVersion + ": " + line);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String key = HistorySerialGenerationInfo.createKey(classname, generationNumber);
        Short value = (Short)this.map.get(key);
        if (value == null) {
            this.map.put(key, serialMinorVersion);
            return true;
        }
        if (value.equals(serialMinorVersion)) {
            return false;
        }
        throw new IOException("Line " + lineno + ": Previous serial minor version " + value + " does not match: " + line);
    }

    @Override
    public short getSerialMinorVersion(Class<?> cl, SerialGeneration generation) {
        if (generation.compareTo(this.currentGeneration) >= 0) {
            return SerialMinorVersionUtils.getSerialMinorVersion(cl);
        }
        String classname = cl.getName();
        Map.Entry<String, Short> entry = this.map.floorEntry(HistorySerialGenerationInfo.createKey(classname, generation.ordinal()));
        if (entry != null && classname.equals(HistorySerialGenerationInfo.getKeyClassName(entry.getKey()))) {
            return entry.getValue();
        }
        throw new IllegalArgumentException("No serial minor number version for generation " + (Object)((Object)generation) + " found for class " + cl.getName());
    }

    public void write(Writer out, Collection<? extends Class<?>> classes) throws IOException {
        out.write("# HistorySerialGenerationInfo " + this.currentGeneration.ordinal() + "\n" + "# CLASSNAME GENERATION-NUMBER SERIAL-MINOR-VERSION\n");
        for (Class<?> cl : classes) {
            String classname = cl.getName();
            short currentSerialMinorVersion = SerialMinorVersionUtils.getSerialMinorVersion(cl);
            boolean wroteCurrent = false;
            SortedMap<String, Short> submap = this.map.subMap(HistorySerialGenerationInfo.createKey(classname, 0), HistorySerialGenerationInfo.createKey(classname, Integer.MAX_VALUE));
            for (Map.Entry entry : submap.entrySet()) {
                String key = (String)entry.getKey();
                int generationNumber = HistorySerialGenerationInfo.getKeyGenerationNumber(key);
                short version = (Short)entry.getValue();
                this.writeEntry(out, classname, generationNumber, version);
                if (version != currentSerialMinorVersion) continue;
                wroteCurrent = true;
            }
            if (wroteCurrent) continue;
            this.writeEntry(out, classname, this.currentGeneration.ordinal(), currentSerialMinorVersion);
        }
    }

    int getNumEntries() {
        return this.numEntries;
    }

    private void writeEntry(Writer out, String classname, int serialGeneration, short serialMinorVersion) throws IOException {
        out.write(classname + " " + serialGeneration + " " + serialMinorVersion + "\n");
    }

    private static String createKey(String classname, int generationNumber) {
        return String.format("%s %08x", classname, generationNumber);
    }

    private static String getKeyClassName(String key) {
        return key.substring(0, key.indexOf(32));
    }

    private static int getKeyGenerationNumber(String key) {
        return Integer.parseInt(key.substring(key.length() - 8), 16);
    }
}

