/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.NetConfigProtocol;
import com.vmware.sva.common.NetworkState;
import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialMinorVersion;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.net.InetAddress;

@SerialMinorVersion(value=2)
public class NetworkInterface
extends AbstractSerializable {
    private InetAddress ipAddress;
    private int ipPrefix;
    private NetConfigProtocol netConfigProtocol = NetConfigProtocol.NONE;
    private NetworkState state = NetworkState.UP;
    private String interfaceName;
    private static final long serialVersionUID = 1L;

    public NetworkInterface() {
    }

    public NetworkInterface(InetAddress ipAddress, int ipPrefix, NetConfigProtocol netConfigProtocol, NetworkState state, String name) {
        this.ipAddress = ipAddress;
        this.ipPrefix = ipPrefix;
        this.netConfigProtocol = netConfigProtocol == null ? NetConfigProtocol.NONE : netConfigProtocol;
        this.state = state == null ? NetworkState.UP : state;
        this.interfaceName = name;
    }

    public NetworkInterface(InetAddress ipAddress, int ipPrefix, String name) {
        this(ipAddress, ipPrefix, NetConfigProtocol.NONE, NetworkState.UP, name);
    }

    public NetworkInterface(InetAddress ipAddress, int ipPrefix, NetConfigProtocol netConfigProtocol, String name) {
        this(ipAddress, ipPrefix, netConfigProtocol, NetworkState.UP, name);
    }

    public NetworkInterface(String string) throws Exception {
        String[] split = string.split("/");
        this.ipAddress = InetAddress.getByName(split[0]);
        this.ipPrefix = Integer.parseInt(split[1]);
        this.netConfigProtocol = NetConfigProtocol.NONE;
        this.state = NetworkState.UP;
        this.interfaceName = split[2];
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public int getIpPrefix() {
        return this.ipPrefix;
    }

    public NetConfigProtocol getNetConfigProtocol() {
        return this.netConfigProtocol;
    }

    public NetworkState getState() {
        return this.state;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setState(NetworkState state) {
        this.state = state;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setIpPrefix(int ipPrefix) {
        this.ipPrefix = ipPrefix;
    }

    public void setInterfaceName(String name) {
        this.interfaceName = name;
    }

    public void setNetConfigProtocol(NetConfigProtocol netConfigProtocol) {
        this.netConfigProtocol = netConfigProtocol;
    }

    public String toString() {
        String outTmpl = "[NetworkInterface {Name: %s; ipAddress: %s; ipPrefix: %s; netConfigProtocol: %s; state: %s;}]";
        return String.format(outTmpl, new Object[]{this.interfaceName, this.ipAddress.getHostAddress(), this.ipPrefix, this.netConfigProtocol, this.state});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidClassException {
        SerialFields fields = this.getSerialGeneration().setDefaultFields(this, NetworkInterface.class, in);
        if (fields != null) {
            switch (fields.getSerialMinorVersion()) {
                case 1: {
                    this.interfaceName = "Unknown";
                    break;
                }
                default: {
                    throw new InvalidClassException("Unknown serial minor version " + fields.getSerialMinorVersion() + " for class " + NetworkInterface.class.getName());
                }
            }
        }
    }
}

