/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.ClientOverrideHostRmiClientSocketFactory;
import com.vmware.sva.common.SubnetRMIServerSocketFactory;
import com.vmware.sva.common.SvaConstants;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RmiUtilities {
    private static final Logger LOGGER = Logger.getLogger(RmiUtilities.class.getName());
    private static Map<String, Remote> exportedObjects = new Hashtable<String, Remote>();
    private static List<Registry> localRegistries = new ArrayList<Registry>();
    private static volatile RMIServerSocketFactory serverSocketFactory;
    private static final ClientOverrideHostRmiClientSocketFactory clientSocketFactory;

    private RmiUtilities() {
    }

    public static synchronized Registry createRegistry() throws RemoteException {
        Registry registry = LocateRegistry.createRegistry(SvaConstants.RMI_REGISTRY_PORT, clientSocketFactory, RmiUtilities.getServerSocketFactory());
        localRegistries.add(registry);
        return registry;
    }

    public static Remote getRemoteObject(InetAddress address, final String name) throws RemoteException, NotBoundException {
        if (address == null) {
            throw new NullPointerException("The address must not be null");
        }
        if (name == null) {
            throw new NullPointerException("The name must not be null");
        }
        final Registry registry = LocateRegistry.getRegistry(address.getHostAddress(), SvaConstants.RMI_REGISTRY_PORT);
        try {
            return ClientOverrideHostRmiClientSocketFactory.callWithHost(address.getHostAddress(), new Callable<Remote>(){

                @Override
                public Remote call() throws RemoteException, NotBoundException {
                    return registry.lookup(name);
                }
            });
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (NotBoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            AssertionError err = new AssertionError((Object)("Unexpected exception: " + e));
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
    }

    public static boolean isObjectExported(String name) {
        return exportedObjects.containsKey(name);
    }

    public static synchronized Remote exportObject(String name, Remote object) throws RemoteException {
        if (name == null) {
            throw new NullPointerException("The name must not be null");
        }
        if (object == null) {
            throw new NullPointerException("The object must not be null");
        }
        Registry registry = LocateRegistry.getRegistry(SvaConstants.RMI_REGISTRY_PORT);
        Remote remote = UnicastRemoteObject.exportObject(object, SvaConstants.RMI_REGISTRY_PORT, clientSocketFactory, RmiUtilities.getServerSocketFactory());
        exportedObjects.put(name, object);
        registry.rebind(name, remote);
        return remote;
    }

    public static synchronized void unexportObject(String name, Remote object) throws NoSuchObjectException, NotBoundException, RemoteException {
        if (name == null) {
            throw new NullPointerException("The name must not be null");
        }
        if (object == null) {
            throw new NullPointerException("The object must not be null");
        }
        Registry registry = LocateRegistry.getRegistry(SvaConstants.RMI_REGISTRY_PORT);
        registry.unbind(name);
        UnicastRemoteObject.unexportObject(object, true);
        exportedObjects.remove(name);
    }

    public static synchronized void shutdownRMI() throws Exception {
        ArrayList<String> keysCopy = new ArrayList<String>(exportedObjects.keySet());
        for (String key : keysCopy) {
            try {
                RmiUtilities.unexportObject(key, exportedObjects.get(key));
            }
            catch (NoSuchObjectException ex) {
                LOGGER.log(Level.WARNING, "A remote object '" + key + "' is not currently exported.");
            }
        }
        if (!localRegistries.isEmpty()) {
            Registry localRegistry = localRegistries.get(localRegistries.size() - 1);
            try {
                UnicastRemoteObject.unexportObject(localRegistry, true);
            }
            catch (NoSuchObjectException ex) {
                LOGGER.log(Level.WARNING, "The RMI Registry is not currently exported.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final RMIServerSocketFactory getServerSocketFactory() {
        if (serverSocketFactory != null) return serverSocketFactory;
        Class<RmiUtilities> clazz = RmiUtilities.class;
        synchronized (RmiUtilities.class) {
            if (serverSocketFactory != null) return serverSocketFactory;
            if (SvaConstants.ENABLE_SUBNET_FILTER) {
                serverSocketFactory = new SubnetRMIServerSocketFactory();
            } else {
                serverSocketFactory = RMISocketFactory.getSocketFactory();
                if (serverSocketFactory != null) return serverSocketFactory;
                serverSocketFactory = RMISocketFactory.getDefaultSocketFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverSocketFactory;
        }
    }

    static {
        clientSocketFactory = new ClientOverrideHostRmiClientSocketFactory();
    }
}

