/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.SerialMinorVersion;
import java.io.Serializable;

public final class SerialMinorVersionUtils {
    private SerialMinorVersionUtils() {
    }

    public static short getSerialMinorVersion(Class<?> cl) {
        if (!Serializable.class.isAssignableFrom(cl)) {
            throw new IllegalArgumentException("The class must be serializable: " + cl.getName());
        }
        SerialMinorVersion serialVersion = cl.getAnnotation(SerialMinorVersion.class);
        if (serialVersion == null) {
            return 1;
        }
        short value = serialVersion.value();
        if (value < 1) {
            throw new IllegalArgumentException("Class " + cl.getName() + " has an illegal serial minor version: " + value);
        }
        return value;
    }
}

