/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common.util;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.common.util.NamedThreadFactory;
import com.vmware.sva.common.util.SystemCommandException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemCommand {
    private StringWriter stdinDebug;
    private StringWriter stdoutDebug;
    private StringWriter stderrDebug;
    private static final Logger logger = SvaDebug.LOG_SYSTEM_COMMANDS ? Logger.getLogger(SystemCommand.class.getName()) : null;
    private final Redirector stdin;
    private final Redirector stdout;
    private final Redirector stderr;
    private final ProcessBuilder builder;
    private final long commandId = nextCommandId.getAndIncrement();
    private static final long IO_TIMEOUT = 3000L;
    private static final AtomicLong nextCommandId = new AtomicLong(0L);
    private static Timer timer = null;

    private SystemCommand(Reader stdinReader, Writer stdoutWriter, Writer stderrWriter, String ... args) {
        if (args.length == 1) {
            args = args[0].split("\\s+");
        }
        this.builder = new ProcessBuilder(args);
        this.beginLogging();
        this.stdin = stdinReader != null ? new Redirector(stdinReader, (Writer)this.stdinDebug) : null;
        this.stdout = stdoutWriter != null ? new Redirector(stdoutWriter, (Writer)this.stdoutDebug) : null;
        this.stderr = stderrWriter != null ? new Redirector(stderrWriter, (Writer)this.stderrDebug) : null;
    }

    private void beginLogging() {
        if (SvaDebug.LOG_SYSTEM_COMMANDS) {
            if (SvaDebug.LOG_SYSTEM_COMMANDS_STDIN) {
                this.stdinDebug = new StringWriter();
            }
            if (SvaDebug.LOG_SYSTEM_COMMANDS_STDOUT) {
                this.stdoutDebug = new StringWriter();
            }
            if (SvaDebug.LOG_SYSTEM_COMMANDS_STDERR) {
                this.stderrDebug = new StringWriter();
            }
            logger.log(Level.INFO, "SystemCommand(" + this.commandId + "): " + this.builder.command());
        }
    }

    private void endLoggingOf(String msg, StringWriter debugWriter) {
        if (debugWriter != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(msg);
            pw.println(debugWriter.toString());
            pw.flush();
            this.log(Level.INFO, sw.toString());
        }
    }

    private void endLogging(String msg) {
        if (SvaDebug.LOG_SYSTEM_COMMANDS) {
            String prefix = "SystemCommand(" + this.commandId + "): ";
            this.endLoggingOf(prefix + "stdin:", this.stdinDebug);
            this.endLoggingOf(prefix + "stdout:", this.stdoutDebug);
            this.endLoggingOf(prefix + "stderr:", this.stderrDebug);
            if (msg != null) {
                logger.log(Level.INFO, prefix + msg);
            }
        }
    }

    private void log(Level level, String msg, Throwable t) {
        if (logger != null) {
            logger.log(level, msg, t);
        }
    }

    private void log(Level level, String msg) {
        if (logger != null) {
            logger.log(level, msg);
        }
    }

    private int execute(Long timeout) throws IOException, InterruptedException {
        int exitCode;
        StringBuffer endLogMsg;
        Process p;
        block21: {
            p = this.builder.start();
            TimeoutTask timeoutTask = null;
            endLogMsg = new StringBuffer("Command Exited. Code = %d");
            if (timeout != null) {
                timeoutTask = new TimeoutTask(Thread.currentThread());
                SystemCommand.getTimer().schedule((TimerTask)timeoutTask, timeout);
            }
            if (this.stdin != null) {
                this.stdin.start(p.getOutputStream());
            }
            if (this.stdout != null) {
                this.stdout.start(p.getInputStream());
            }
            if (this.stderr != null) {
                this.stderr.start(p.getErrorStream());
            }
            try {
                exitCode = p.waitFor();
                if (this.stdout != null) {
                    try {
                        this.stdout.join();
                    }
                    catch (Exception e) {
                        this.log(Level.SEVERE, this.builder.command() + " failed to join stdout", e);
                    }
                }
                if (exitCode != 0 && this.stderr != null) {
                    try {
                        this.stderr.join();
                    }
                    catch (Exception e) {
                        this.log(Level.SEVERE, this.builder.command() + " failed to join stderr", e);
                    }
                }
                if (timeoutTask == null) break block21;
            }
            catch (InterruptedException e) {
                try {
                    this.endLogging("Command Interrupted after " + timeout / 1000L + " seconds");
                    p.destroy();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (timeoutTask != null) {
                        long taskRunTimeRemainingMs = timeoutTask.scheduledExecutionTime() - System.currentTimeMillis();
                        long taskRunTimeMs = timeout - taskRunTimeRemainingMs;
                        endLogMsg.append(String.format(", Run Time = %.3f seconds, Time Remaining = %.3f seconds", Float.valueOf((float)taskRunTimeMs / 1000.0f), Float.valueOf((float)taskRunTimeRemainingMs / 1000.0f)));
                        timeoutTask.cancel();
                    }
                    if (this.stdin != null) {
                        SystemCommand.close(p.getOutputStream());
                    }
                    if (this.stdout != null) {
                        SystemCommand.close(p.getInputStream());
                    }
                    if (this.stderr != null) {
                        SystemCommand.close(p.getErrorStream());
                    }
                    throw throwable;
                }
            }
            long taskRunTimeRemainingMs = timeoutTask.scheduledExecutionTime() - System.currentTimeMillis();
            long taskRunTimeMs = timeout - taskRunTimeRemainingMs;
            endLogMsg.append(String.format(", Run Time = %.3f seconds, Time Remaining = %.3f seconds", Float.valueOf((float)taskRunTimeMs / 1000.0f), Float.valueOf((float)taskRunTimeRemainingMs / 1000.0f)));
            timeoutTask.cancel();
        }
        if (this.stdin != null) {
            SystemCommand.close(p.getOutputStream());
        }
        if (this.stdout != null) {
            SystemCommand.close(p.getInputStream());
        }
        if (this.stderr != null) {
            SystemCommand.close(p.getErrorStream());
        }
        this.endLogging(String.format(endLogMsg.toString(), exitCode));
        return exitCode;
    }

    private static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int execute(Reader stdinReader, Writer stdoutWriter, Writer stderrWriter, Long timeout, String ... args) throws IOException, InterruptedException {
        SystemCommand cmd = new SystemCommand(stdinReader, stdoutWriter, stderrWriter, args);
        return cmd.execute(timeout);
    }

    public static int execute(Reader stdinReader, Long timeout, String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(stdinReader, null, null, timeout, args);
    }

    public static int execute(Writer stdoutWriter, Writer stderrWriter, Long timeout, String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(null, stdoutWriter, stderrWriter, timeout, args);
    }

    public static int execute(Long timeout, String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(null, null, null, timeout, args);
    }

    public static int execute(Reader stdinReader, Writer stdoutWriter, Writer stderrWriter, String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(stdinReader, stdoutWriter, stderrWriter, null, args);
    }

    public static int execute(Reader stdinReader, String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(stdinReader, null, null, null, args);
    }

    public static int execute(Writer stdoutWriter, Writer stderrWriter, String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(null, stdoutWriter, stderrWriter, null, args);
    }

    public static int execute(String ... args) throws IOException, InterruptedException {
        return SystemCommand.execute(null, null, null, null, args);
    }

    public static String executePlatformCommand(String ... command) throws Exception {
        return SystemCommand.executePlatformCommand(SvaConstants.PLATFORM_COMMAND_TIMEOUT, command);
    }

    public static String executePlatformCommand(long timeout, String ... command) throws Exception {
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        int exitCode = SystemCommand.execute((Writer)stdout, (Writer)stderr, timeout, command);
        if (exitCode != 0) {
            throw new SystemCommandException(exitCode, "Platform command failed: " + command[0] + ": " + stderr.toString());
        }
        return stdout.toString();
    }

    private static synchronized Timer getTimer() {
        if (timer == null) {
            timer = new Timer("SystemCommand Timer");
        }
        return timer;
    }

    private static class Redirector
    implements Runnable {
        private Reader reader = null;
        private Writer writer = null;
        private Writer debugWriter = null;
        private Future<?> future = null;
        private static final ExecutorService executor = Executors.newCachedThreadPool(new NamedThreadFactory("SystemCommand-Redirector-Thread-"));

        Redirector(Reader theReader, Writer theDebugWriter) {
            this.reader = theReader;
            this.debugWriter = theDebugWriter;
        }

        Redirector(Writer theWriter, Writer theDebugWriter) {
            this.writer = theWriter;
            this.debugWriter = theDebugWriter;
        }

        void start(InputStream inputStream) throws IllegalThreadStateException, IOException, NullPointerException {
            if (inputStream == null) {
                throw new NullPointerException();
            }
            if (this.writer == null) {
                inputStream.close();
            } else {
                this.reader = new InputStreamReader(inputStream);
                this.future = executor.submit(this);
            }
        }

        void start(OutputStream outputStream) throws IllegalThreadStateException, IOException, NullPointerException {
            if (outputStream == null) {
                throw new NullPointerException();
            }
            if (this.reader == null) {
                outputStream.close();
            } else {
                this.writer = new OutputStreamWriter(outputStream);
                this.future = executor.submit(this);
            }
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.reader.read()) != -1) {
                    try {
                        if (this.debugWriter != null) {
                            this.debugWriter.write(c);
                        }
                        this.writer.write(c);
                    }
                    catch (IOException e) {
                        this.reader.close();
                        return;
                    }
                }
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void join() throws InterruptedException, ExecutionException {
            if (this.future != null) {
                try {
                    this.future.get(3000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
        }
    }

    private static class TimeoutTask
    extends TimerTask {
        private final Thread thread;

        TimeoutTask(Thread theThread) {
            this.thread = theThread;
        }

        @Override
        public void run() {
            this.thread.interrupt();
        }
    }
}

