/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserver;

import com.vmware.sva.common.AbstractSerializable;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaUtilities;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ZkConfiguration
extends AbstractSerializable {
    private static final long serialVersionUID = 1L;
    private final Properties configProperties = new Properties();

    public ZkConfiguration(boolean running, int localId, Map<Integer, InetAddress> servers) {
        this.setRunning(running);
        this.setLocalId(localId);
        this.setServers(servers);
        this.pseudoSva(false);
    }

    public ZkConfiguration(String filename) throws Exception {
        this.loadConfiguration(filename);
    }

    public void addServer(int id, InetAddress address) {
        this.configProperties.setProperty("server." + id, address.getHostAddress());
    }

    public void removeServer(int id) {
        this.configProperties.remove("server." + id);
    }

    public boolean isPseudoSva() {
        return Boolean.valueOf(this.configProperties.getProperty(ConfigProperty.PSVA.toString().toLowerCase()));
    }

    public void pseudoSva(boolean mode) {
        this.configProperties.setProperty(ConfigProperty.PSVA.toString().toLowerCase(), Boolean.toString(mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeZkProperties() throws Exception {
        Properties p = this.getZkProperties();
        FileWriter confFile = new FileWriter(SvaConstants.ZK_CONF_FILE);
        try {
            p.store(confFile, null);
        }
        finally {
            confFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMyId() throws Exception {
        FileWriter myidFile = new FileWriter(SvaConstants.ZK_MYID_FILE);
        try {
            myidFile.write(Integer.valueOf(this.getLocalId()).toString());
        }
        finally {
            myidFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfiguration() throws Exception {
        FileWriter confFile = new FileWriter(SvaConstants.SVA_ZK_PROPERTIES_FILE);
        try {
            this.configProperties.store(confFile, null);
        }
        finally {
            confFile.close();
        }
    }

    public void storeAll() throws Exception {
        this.storeConfiguration();
        this.storeZkProperties();
        this.storeMyId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(String filename) throws IOException {
        FileReader confFile = new FileReader(filename);
        try {
            this.configProperties.load(confFile);
        }
        finally {
            confFile.close();
        }
    }

    private void setServers(Map<Integer, InetAddress> servers) {
        if (servers != null) {
            for (Map.Entry<Integer, InetAddress> entry : servers.entrySet()) {
                this.addServer(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setRunning(boolean running) {
        this.configProperties.setProperty(ConfigProperty.RUNNING.toString().toLowerCase(), Boolean.toString(running));
    }

    public void setLocalId(int localId) {
        this.configProperties.setProperty(ConfigProperty.LOCALID.toString().toLowerCase(), Integer.toString(localId));
    }

    private Properties getZkProperties() {
        Properties zkProp = new Properties();
        Set<String> pNames = this.configProperties.stringPropertyNames();
        zkProp.setProperty("clientPort", Integer.toString(SvaConstants.ZK_CLIENT_PORT));
        zkProp.setProperty("dataDir", SvaConstants.ZK_DATA_DIRECTORY);
        zkProp.setProperty("tickTime", Integer.toString(SvaConstants.ZK_TICKTIME));
        zkProp.setProperty("initLimit", Integer.toString(SvaConstants.ZK_INIT_LIMIT));
        zkProp.setProperty("syncLimit", Integer.toString(SvaConstants.ZK_SYNC_LIMIT));
        zkProp.setProperty("snapCount", Integer.toString(SvaConstants.ZK_SNAP_COUNT));
        zkProp.setProperty("maxClientCnxns", Integer.toString(SvaConstants.ZK_MAX_CLIENT_CNXNS));
        for (String name : pNames) {
            if (!name.contains("server")) continue;
            zkProp.setProperty(name, this.configProperties.getProperty(name) + ":" + SvaConstants.ZK_PEER_PORT + ":" + SvaConstants.ZK_ELECTION_PORT);
        }
        return zkProp;
    }

    public String getZkConfigString() throws IOException {
        Properties p = new Properties();
        Set<String> pNames = this.configProperties.stringPropertyNames();
        p.setProperty("tickTime", Integer.toString(SvaConstants.ZK_TICKTIME));
        p.setProperty("dataDir", SvaConstants.ZK_DATA_DIRECTORY);
        p.setProperty("clientPort", Integer.toString(SvaConstants.ZK_CLIENT_PORT));
        p.setProperty("initLimit", Integer.toString(SvaConstants.ZK_INIT_LIMIT));
        p.setProperty("syncLimit", Integer.toString(SvaConstants.ZK_SYNC_LIMIT));
        p.setProperty("snapCount", Integer.toString(SvaConstants.ZK_SNAP_COUNT));
        p.setProperty("maxClientCnxns", Integer.toString(SvaConstants.ZK_MAX_CLIENT_CNXNS));
        for (String name : pNames) {
            if (!name.contains("server")) continue;
            p.setProperty(name, this.configProperties.getProperty(name) + ":" + SvaConstants.ZK_PEER_PORT + ":" + SvaConstants.ZK_ELECTION_PORT);
        }
        StringWriter sw = new StringWriter();
        p.store(sw, null);
        return sw.toString();
    }

    public boolean getRunning() {
        return Boolean.valueOf(this.configProperties.getProperty(ConfigProperty.RUNNING.toString().toLowerCase()));
    }

    public int getLocalId() {
        return Integer.parseInt(this.configProperties.getProperty(ConfigProperty.LOCALID.toString().toLowerCase()));
    }

    public InetAddress getServerAddress(int id) throws Exception {
        return InetAddress.getByName(this.configProperties.getProperty("server." + id));
    }

    public int getZkId(InetAddress serverAddress) throws Exception {
        Map<Integer, InetAddress> serverMap = this.getServers();
        for (Map.Entry<Integer, InetAddress> entry : serverMap.entrySet()) {
            if (!entry.getValue().equals(serverAddress)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public Map<Integer, InetAddress> getServers() throws Exception {
        return SvaUtilities.getZkServerMap(this.configProperties);
    }

    public static List<String> getZkServerAddresses() throws IOException {
        return SvaUtilities.getZkServerAddresses();
    }

    private static enum ConfigProperty {
        RUNNING,
        LOCALID,
        PSVA;

    }
}

