/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserver;

import com.vmware.sva.common.PseudoSvaClusterMetadata;
import com.vmware.sva.common.RmiUtilities;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaLogConstants;
import com.vmware.sva.common.SvaUtilities;
import com.vmware.sva.common.util.PseudoSvaUtility;
import com.vmware.sva.zkmgmtserver.PurgeZooKeeperTxnLog;
import com.vmware.sva.zkmgmtserver.ZkConfiguration;
import com.vmware.sva.zkmgmtserver.ZkMgmtClient;
import com.vmware.sva.zkmgmtserver.ZkMgmtServerInterface;
import com.vmware.sva.zkmgmtserver.ZkQuorumPeer;
import com.vmware.sva.zkmgmtserver.ZkServerAlreadyRunningException;
import com.vmware.sva.zkmgmtserver.ZkStandaloneServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ZkMgmtServer
implements ZkMgmtServerInterface {
    private static volatile ZkMgmtServer zkMgmtServer;
    private final Logger logger;
    private ZkConfiguration zkConfiguration = null;
    private boolean running;
    private ZkStandaloneServer zkStandaloneServer;
    private ZkQuorumPeer zkQuorumServer;
    private QuorumPeerConfig qPeerConfig = null;
    private boolean distributed;
    private ZkMgmtClient zkClient = null;
    private Timer purgerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZkMgmtServer() throws Exception {
        ZkMgmtServer zkMgmtServer = this;
        synchronized (zkMgmtServer) {
            this.logger = Logger.getLogger(this.getClass().getName());
            this.running = false;
            try {
                this.zkConfiguration = new ZkConfiguration(SvaConstants.SVA_ZK_PROPERTIES_FILE);
                this.zkConfiguration.storeZkProperties();
                this.zkConfiguration.storeMyId();
            }
            catch (FileNotFoundException fe) {
                this.logger.log(Level.INFO, "ZooKeeper configuration is absent. It is expected if the cluster has not been formed.");
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Error while accessing " + SvaConstants.SVA_ZK_PROPERTIES_FILE, e.getMessage());
                throw e;
            }
        }
    }

    public synchronized void startRmiService() throws RemoteException, Exception {
        if (!RmiUtilities.isObjectExported("ZkMgmtServer")) {
            RmiUtilities.exportObject("ZkMgmtServer", this);
        }
    }

    @Override
    public synchronized ZkConfiguration getZkConfiguration() {
        return this.zkConfiguration;
    }

    @Override
    public synchronized void setZkConfiguration(ZkConfiguration zkConfiguration) throws Exception {
        this.logger.log(Level.FINE, "Received request to set ZK configuration");
        if (this.zkConfiguration != null && this.zkConfiguration.isPseudoSva() != zkConfiguration.isPseudoSva()) {
            this.logger.log(Level.WARNING, "Received unsupported request to change Pseudo SVA to SVA.");
            throw new Exception("Changing Pseudo SVA to SVA not supported");
        }
        this.zkConfiguration = zkConfiguration;
        zkConfiguration.storeAll();
        if (this.running && !zkConfiguration.getRunning()) {
            this.stopZooKeeper(false);
        } else if (!this.running && zkConfiguration.getRunning()) {
            this.startZooKeeper();
        } else if (this.running && zkConfiguration.getRunning()) {
            this.restartZooKeeper();
        }
    }

    public void restartZooKeeper() throws Exception {
        this.stopZooKeeper(false);
        this.startZooKeeper();
    }

    @Override
    public synchronized void startZooKeeper() throws Exception {
        this.logger.log(Level.FINE, "Starting ZK server");
        if (!this.running) {
            this.qPeerConfig = new QuorumPeerConfig();
            try {
                this.qPeerConfig.parse(SvaConstants.ZK_CONF_FILE);
            }
            catch (QuorumPeerConfig.ConfigException e) {
                this.logger.log(Level.WARNING, "Invalid config, exiting abnormally");
                this.logger.log(Level.WARNING, e.getMessage());
                this.logger.log(Level.WARNING, "A set operation needs to be performed before start");
                throw e;
            }
            this.distributed = this.qPeerConfig.isDistributed();
            this.zkConfiguration.setRunning(true);
            this.zkConfiguration.storeConfiguration();
            this.logger.log(Level.INFO, "Going to call startServer()");
            if (this.distributed) {
                this.zkQuorumServer = new ZkQuorumPeer(SvaConstants.ZK_CONF_FILE, this.logger);
                this.zkQuorumServer.startServer();
            } else {
                this.zkStandaloneServer = new ZkStandaloneServer(SvaConstants.ZK_CONF_FILE, this.logger);
                this.zkStandaloneServer.startServer();
            }
            if (this.zkConfiguration.isPseudoSva()) {
                this.zkClient = new ZkMgmtClient(this.logger);
            }
        } else {
            boolean run = this.zkConfiguration.getRunning();
            if (!run) {
                try {
                    this.zkConfiguration.setRunning(true);
                    this.zkConfiguration.storeConfiguration();
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Not able to update ZkConfiguration to set running = true.", e);
                    this.zkConfiguration.setRunning(run);
                }
            }
            throw new ZkServerAlreadyRunningException("ZooKeeper already started");
        }
        this.running = true;
        this.purgerThread = new Timer("ZkMgmtServer Purger Timer");
        this.purgerThread.schedule((TimerTask)new PurgeZooKeeperTxnLog(SvaConstants.ZK_DATA_DIRECTORY, SvaConstants.ZK_DATA_DIRECTORY, SvaConstants.ZK_MAX_SNAPSHOT_FILES), (long)SvaConstants.ZK_PURGE_FREQUENCY * 1000L, (long)SvaConstants.ZK_PURGE_FREQUENCY * 1000L);
    }

    public synchronized void startZooKeeperWithCondition() throws Exception {
        this.logger.log(Level.FINE, "Starting ZK server with Condition");
        if (this.zkConfiguration != null && this.zkConfiguration.getRunning()) {
            this.startZooKeeper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopZooKeeper(boolean cleanup) throws Exception {
        this.logger.log(Level.FINE, "Stopping ZK server");
        try {
            if (this.running) {
                this.purgerThread.cancel();
                this.purgerThread = null;
                this.zkConfiguration.setRunning(false);
                this.zkConfiguration.storeConfiguration();
                this.logger.log(Level.INFO, "Going to call shutdownServer()");
                if (this.distributed) {
                    this.zkQuorumServer.shutdownServer();
                } else {
                    this.zkStandaloneServer.shutdownServer();
                }
                if (this.zkConfiguration.isPseudoSva()) {
                    this.zkClient.close();
                }
                this.running = false;
            }
        }
        finally {
            if (cleanup) {
                ZkMgmtServer.deleteZooKeeperFiles();
            }
        }
    }

    public static ZkMgmtServerInterface getZkMgmtServer(InetAddress address) throws Exception {
        return (ZkMgmtServerInterface)RmiUtilities.getRemoteObject(address, "ZkMgmtServer");
    }

    public static ZkMgmtServer getLocalZkMgmtServerInstance() {
        return zkMgmtServer;
    }

    public static synchronized ZkMgmtServer createLocalZkMgmtServer() throws Exception {
        if (zkMgmtServer == null) {
            SvaLogConstants.initializeLog4jProperties();
            zkMgmtServer = new ZkMgmtServer();
        }
        return zkMgmtServer;
    }

    public static void deleteZooKeeperFiles() throws IOException {
        SvaUtilities.deleteFiles(new File(SvaConstants.SVA_ZK_PROPERTIES_FILE), new File(SvaConstants.ZK_CONF_FILE), new File(SvaConstants.ZK_MYID_FILE), new File(SvaConstants.ZK_CACHE_DIRECTORY));
    }

    @Override
    public synchronized void setClusterMetaData(PseudoSvaClusterMetadata psvaMetaData, boolean overwritePassword) throws Exception {
        this.logger.log(Level.INFO, "Received request to set cluster metadata ");
        PseudoSvaUtility.writeMetaData(psvaMetaData, overwritePassword);
    }
}

