/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserver;

import com.vmware.sva.util.SvaHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public class ZkQuorumPeer
extends QuorumPeerMain {
    private final String configFile;
    private final ZooKeeperInstance zkInstance;
    private final Logger logger;

    public ZkQuorumPeer(String configFile, Logger logger) {
        this.configFile = configFile;
        this.zkInstance = new ZooKeeperInstance();
        this.logger = logger;
    }

    public void startServer() {
        this.zkInstance.start();
    }

    public void shutdownServer() throws Exception {
        System.out.println("Printing Quorum Peer ");
        System.out.println(this.quorumPeer.toString());
        this.quorumPeer.shutdown();
        this.zkInstance.join();
    }

    private class ZooKeeperInstance
    extends Thread {
        ZooKeeperInstance() {
            super("ZooKeeper QuorumPeer Wrapper");
        }

        @Override
        public void run() {
            String[] s = new String[]{ZkQuorumPeer.this.configFile};
            try {
                ZkQuorumPeer.this.initializeAndRun(s);
            }
            catch (IllegalArgumentException e) {
                ZkQuorumPeer.this.logger.log(Level.WARNING, "Invalid arguments, exiting abnormally: " + e.getMessage());
            }
            catch (QuorumPeerConfig.ConfigException e) {
                ZkQuorumPeer.this.logger.log(Level.WARNING, "Invalid configuration, exiting abnormally: " + e.getMessage());
            }
            catch (AssertionError e) {
                SvaHelper.handleAssertionError((String)"ZkQuorumPeer.ZooKeeperInstance", (AssertionError)e, (Logger)ZkQuorumPeer.this.logger);
            }
            catch (Throwable e) {
                ZkQuorumPeer.this.logger.log(Level.SEVERE, "Unexpected exception, exiting abnormally: " + e.getMessage(), e);
            }
        }
    }
}

