/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserverapp;

import com.vmware.sva.common.PseudoSVAPathUtil;
import com.vmware.sva.common.RmiUtilities;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.zkmgmtserver.ZkMgmtServer;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZkMgmtServerApp {
    private static final Logger logger = Logger.getLogger(ZkMgmtServer.class.getName());

    public static void main(String[] args) throws RemoteException, MalformedURLException, Exception {
        String os = System.getProperty("os.name");
        if (os.toLowerCase(Locale.ENGLISH).contains("windows")) {
            if (args.length != 1) {
                System.err.println("Path to SVA Manager XML config file not specified");
                System.exit(2);
            }
            PseudoSVAPathUtil.setPsvaConfigPath(args[0]);
        }
        RmiUtilities.createRegistry();
        ZkMgmtServer zkMgmtServer = ZkMgmtServer.createLocalZkMgmtServer();
        zkMgmtServer.startRmiService();
        zkMgmtServer.startZooKeeperWithCondition();
        if (SvaDebug.CLUSTER_SERVICE_LOG_HEARTBEAT > 0L) {
            Timer timer = new Timer("VSA Cluster Service Heartbeat Logger", true);
            timer.schedule((TimerTask)new LogHeartbeatTask(), SvaDebug.CLUSTER_SERVICE_LOG_HEARTBEAT, SvaDebug.CLUSTER_SERVICE_LOG_HEARTBEAT);
        }
    }

    private static class LogHeartbeatTask
    extends TimerTask {
        private LogHeartbeatTask() {
        }

        @Override
        public void run() {
            logger.log(Level.INFO, "OK");
        }
    }
}

