/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.project.ProjectPlugin;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public abstract class AbstractCommandRunner {
    public static final String PROPERTY_EXECPATH = "ExecutePath";
    protected String runnerid;
    private IConsole defconsole = null;

    public abstract IStatus execute(Shell var1, IProject var2, String var3, int var4, Map<String, String> var5, Map<String, String> var6, IProgressMonitor var7) throws Exception;

    public abstract boolean isBlock();

    public AbstractCommandRunner(String id) {
        this.runnerid = id;
    }

    public boolean isValid() {
        return this.runnerid != null && !this.runnerid.isEmpty();
    }

    public String getID() {
        return this.runnerid;
    }

    public boolean isRunnable(IProject project) {
        return this.isValid() && project != null;
    }

    public Job run(Shell shell, IProject project, final String command, final int sequence, final Map<String, String> commandproperties, final Map<String, String> envs) throws Exception {
        final IProject curproject = project;
        final Shell curshell = shell;
        Job job = new Job(command){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status;
                try {
                    status = AbstractCommandRunner.this.execute(curshell, curproject, command, sequence, commandproperties, envs, monitor);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    status = Status.CANCEL_STATUS;
                }
                return status;
            }
        };
        job.setPriority(20);
        job.schedule();
        return job;
    }

    public final IConsole createConsole(boolean showconsole) {
        final MessageConsole console = new MessageConsole(this.runnerid, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        if (showconsole) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                        view.display((IConsole)console);
                    }
                    catch (PartInitException partInitException) {}
                }
            });
        }
        return console;
    }

    private IConsole _writeMsgInConsole(IConsole console, final String message, final Color color) {
        if (console == null) {
            console = this.createConsole(true);
        }
        if (console instanceof MessageConsole) {
            final MessageConsole msgconsole = (MessageConsole)console;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageConsoleStream stream = msgconsole.newMessageStream();
                    Display display = Display.getCurrent();
                    Color black = null;
                    if (display != null) {
                        black = display.getSystemColor(2);
                    }
                    AbstractCommandRunner.this.switchConsole(msgconsole);
                    stream.setColor(color != null ? color : black);
                    stream.println(message);
                }
            });
        }
        return console;
    }

    private void switchConsole(MessageConsole console) {
        IViewPart view;
        IWorkbenchPage awp;
        IWorkbenchWindow aww = ProjectPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (aww != null && (awp = aww.getActivePage()) != null && (view = awp.findView("org.eclipse.ui.console.ConsoleView")) instanceof IConsoleView) {
            ((IConsoleView)view).display((IConsole)console);
        }
    }

    public final synchronized void writeMsgInDefaultConsole(String message, Color color) {
        this._writeMsgInConsole(this.getDefaultConsole(), message, color);
    }

    public final synchronized IConsole writeMsgInConsole(IConsole console, String message, Color color) {
        return this._writeMsgInConsole(console, message, color);
    }

    private IConsole getDefaultConsole() {
        if (this.defconsole == null) {
            this.defconsole = this.createConsole(true);
        }
        return this.defconsole;
    }

    protected final void configureEnvironments(Map<String, String> environments, Map<String, String> envs) {
        for (Map.Entry<String, String> ent : envs.entrySet()) {
            String var = ent.getKey();
            String val = ent.getValue();
            if (environments.containsKey(var)) {
                environments.remove(var);
                if (val == null) continue;
                environments.put(var, val);
                continue;
            }
            environments.put(var, val);
        }
    }
}

