/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.menu;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.ProjectMenu;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.handlers.HandlerUtil;

public class CommandHandler
extends AbstractHandler {
    private static ILog logger = ProjectPlugin.getDefault().getLog();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String menutext = this.getCurrentMenuText(event);
        IProject project = this.getSelectedProject(event);
        if (menutext != null && project != null) {
            ProjectMenu projectmenu = ProjectPlugin.getConfig().getMenuInfoOfProject(menutext, project);
            if (projectmenu == null) {
                String msg = String.format("Failed to get project menu for the item [%s] in the project [%s].", menutext, project.getName());
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                return null;
            }
            try {
                projectmenu.menuClicked(project);
            }
            catch (VIDEProjectException e) {
                Utils.openDialog(e);
            }
        }
        return null;
    }

    private String getCurrentMenuText(ExecutionEvent event) {
        MenuItem menu = this.getCurrentMenuItem(event);
        if (menu != null) {
            return menu.getText();
        }
        return null;
    }

    private MenuItem getCurrentMenuItem(ExecutionEvent event) {
        if (event.getTrigger() instanceof Event) {
            Event e = (Event)event.getTrigger();
            if (e.widget instanceof MenuItem) {
                return (MenuItem)e.widget;
            }
        }
        return null;
    }

    public IProject getSelectedProject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project;
                if (element instanceof IProject) {
                    return (IProject)element;
                }
                if (!(element instanceof IAdaptable) || (project = (IProject)((IAdaptable)element).getAdapter(IProject.class)) == null) continue;
                return project;
            }
        }
        return null;
    }
}

