/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBFileManager;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.VIBDesignPage;
import java.io.File;

public class DescriptorFileInfo
extends VIBFileInfo {
    private static final String PAGE_NAME = "descriptor";
    private static final String PAGE_ID = "page_descriptor";
    private static final String ROOT_TAG = "vib";
    private static final String ROOT_PROPERTY = "vib.relationships";
    private static final String DESCRIPTOR_XML = "descriptor.xml";
    private static final String TEMPLAGE_XML = "descriptor-template.xml";
    private static final File DEFAULT_TEMPLATE = VIBFileManager.VIB_SAMPLEPATH.append("descriptor-template.xml").toFile();
    private static final String DESCRIPTOR_XSDFILE = "/resources/xmlschemas/vib20-descriptor.xsd";
    private static final String DESCROPTOR_RNGFILE_FROM_VIBSUITE = "/opt/vmware/vibtools/schemas/vib20-descriptor.rng";
    private VIBDesignPage relationshipspage;
    private File schemaFile;

    public DescriptorFileInfo(VIBFileManager manager) {
        super(manager, PAGE_NAME, ROOT_TAG, DESCRIPTOR_XML, DEFAULT_TEMPLATE);
    }

    @Override
    public boolean isPrimaryVIBfile() {
        return true;
    }

    @Override
    public File getXSDSchemaFile() {
        if (this.schemaFile != null) {
            return this.schemaFile;
        }
        this.schemaFile = new File(DESCROPTOR_RNGFILE_FROM_VIBSUITE);
        if (this.schemaFile.exists()) {
            return this.schemaFile;
        }
        this.schemaFile = ProjectPlugin.getDefault().getResource(DESCRIPTOR_XSDFILE);
        return this.schemaFile;
    }

    @Override
    public VIBDesignPage[] getDesignPages() {
        VIBProperty rootproperty = this.getPropertyManager().getProperty(ROOT_PROPERTY);
        if (this.isValid() && rootproperty != null && rootproperty.getVIBFile() != null) {
            return new VIBDesignPage[]{this.getRelationshipsPage(rootproperty)};
        }
        return new VIBDesignPage[0];
    }

    private VIBDesignPage getRelationshipsPage(VIBProperty rootproperty) {
        if (this.relationshipspage != null) {
            return this.relationshipspage;
        }
        this.relationshipspage = new VIBDesignPage(this.getFileManager().getEditor(), PAGE_ID, this, rootproperty, "relationships", "relationships", "VIB's Relationships with Other VIBs", "This section defines a VIB's relationships with other VIBs or with external entities.", null, null);
        return this.relationshipspage;
    }
}

