/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.newwizard;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.wizard.ui.SelCategoryPage;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class NewCategoryPage
extends SelCategoryPage {
    private static final String WIZARDPAGE_NAME = "Create VMware Development Kit Projects:";
    private static final String WIZARDPAGE_TITLE = "Create a VMware Development Kit project";
    private static final String WIZARDPAGE_DESC = "Select your project type:";
    private static final String CONTEXT_HELP_CONTENTS_ID = "context-newwizard-select-project-type";
    private ProjectData projectdata;

    protected NewCategoryPage(String pageName, String title, String description) {
        super(pageName, title, description);
    }

    protected NewCategoryPage() {
        this(WIZARDPAGE_NAME, WIZARDPAGE_TITLE, WIZARDPAGE_DESC);
    }

    @Override
    public Object[] getCategoryElements() {
        return ProjectPlugin.getConfig().getWizardTypes("new_project");
    }

    @Override
    public void selectionChanged_CategoryList(SelectionChangedEvent event) {
        this.updateDescription(event, WIZARDPAGE_DESC);
        ProjectData pdata = this.getProjectDataFromSelection(event);
        if (pdata != null && pdata.isValid()) {
            this.projectdata = pdata;
            this.nextButtonAvailable(true);
        } else {
            this.nextButtonAvailable(false);
        }
    }

    public ProjectData getSelectedProjectData() {
        return this.projectdata;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.vmware.vide.project.help.context-newwizard-select-project-type");
    }
}

