/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.ui;

import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.UserInputHelper;
import com.vmware.vide.project.config.vib.UserInputHelperCommand;
import com.vmware.vide.project.utils.StreamReaderThread;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.wizard.ui.UserInputHelperCommandRunner;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;

public class ExternalCommandRunner
extends UserInputHelperCommandRunner {
    private static final String CMD_CONTROL = "control:";
    private static final String CURRENT_TEXT = "current_text";
    private static final String CMD_CONTROL_PIPE = "control:pipe";
    private static final String CMD_CONTROL_CHARSET = "control:charset";
    private static final String CMD_CONTROL_KEEPEOL = "control:keepeol";
    private static final String CMD_CONTROL_READFROM = "control:readfrom";
    private static final String READFROM_SEPARATOR = ";";
    private static final String READFROM_OUT = "out";
    private static final String READFROM_ERR = "err";
    private static final String READFROM_EXIT = "exit";
    private static final String MSG_UNSUPPORTED_CHARSET = "Specified charset [%s] is not supported. Use default charset.";

    ExternalCommandRunner(SelectionEvent event, UserInputHelperCommand command, Map<String, String> properties, String text, UserInput inputdata, UserInputHelper helper) {
        super(event, command, properties, text, inputdata, helper);
    }

    String[] getCommandLine(UserInputHelperCommand command, Map<String, String> properties, String text) {
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(Utils.replaceContent(command.getCommand(), properties));
        for (String arg : command.getArgs()) {
            if (arg.startsWith(CMD_CONTROL)) {
                if (!arg.equals("control:current_text")) continue;
                cmdline.add(text);
                continue;
            }
            cmdline.add(Utils.replaceContent(arg, properties));
        }
        return cmdline.toArray(new String[cmdline.size()]);
    }

    private boolean isPipe() {
        return this.getArgBooleanValue(CMD_CONTROL_PIPE);
    }

    private boolean keepEol() {
        return this.getArgBooleanValue(CMD_CONTROL_KEEPEOL);
    }

    private String getCharsetName() {
        String charset = this.getArgValue(CMD_CONTROL_CHARSET);
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                return charset;
            }
            String msg = String.format(MSG_UNSUPPORTED_CHARSET, charset);
            logger.log((IStatus)new Status(2, "com.vmware.vide.project", msg));
        }
        return null;
    }

    private String getResultReadfrom(String readfrom, StreamReaderThread ot, StreamReaderThread et, Process process) {
        String[] froms;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = froms = readfrom.split(READFROM_SEPARATOR);
        int n = froms.length;
        int n2 = 0;
        while (n2 < n) {
            String from = stringArray[n2];
            if (from.equals(READFROM_OUT)) {
                sb.append(ot.getRead());
            } else if (from.equals(READFROM_ERR)) {
                sb.append(et.getRead());
            } else if (from.equals(READFROM_EXIT)) {
                int retVal = process.exitValue();
                sb.append(retVal);
            } else {
                String msg = String.format("Unexpected value [%s] is specified in readfrom.", from);
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
            }
            ++n2;
        }
        return sb.toString();
    }

    private void writeToStdin(Process process) {
        OutputStream out = process.getOutputStream();
        String charsetName = this.getCharsetName();
        byte[] inputs = null;
        try {
            try {
                inputs = charsetName != null ? this.text.getBytes(charsetName) : this.text.getBytes();
                out.write(inputs);
                out.flush();
            }
            catch (UnsupportedEncodingException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                try {
                    out.close();
                }
                catch (IOException e2) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e2));
                }
            }
            catch (IOException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                try {
                    out.close();
                }
                catch (IOException e3) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e3));
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
            }
        }
    }

    private String removeTheLastEol(String result) {
        if (result.length() > 1) {
            if (result.endsWith("\r\n")) {
                result = result.substring(0, result.length() - 2);
            } else if (result.endsWith("\n") || result.endsWith("\r")) {
                result = result.substring(0, result.length() - 1);
            }
        } else if (result.length() > 0 && (result.endsWith("\n") || result.endsWith("\r"))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Override
    String run(Map<String, String> results) {
        String[] cmdline = this.getCommandLine(this.command, this.properties, this.text);
        ProcessBuilder pb = new ProcessBuilder(cmdline);
        Thread ot = null;
        Thread et = null;
        try {
            Process process = pb.start();
            String charset = this.getCharsetName();
            ot = new StreamReaderThread(String.valueOf(cmdline[0]) + " reading stdout", process.getInputStream(), logger, charset);
            et = new StreamReaderThread(String.valueOf(cmdline[0]) + " reading stderr", process.getErrorStream(), logger, charset);
            ot.start();
            et.start();
            if (this.isPipe()) {
                this.writeToStdin(process);
            }
            process.waitFor();
            ot.join();
            et.join();
            String readfrom = this.getArgValue(CMD_CONTROL_READFROM);
            String result = readfrom != null ? this.getResultReadfrom(readfrom, (StreamReaderThread)ot, (StreamReaderThread)et, process) : ((StreamReaderThread)ot).getRead();
            if (!this.keepEol()) {
                result = this.removeTheLastEol(result);
            }
            result = Utils.replaceContent(result, this.properties);
            String string = result = this.extractResults(result, results);
            return string;
        }
        catch (IOException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
        }
        catch (InterruptedException e) {
            logger.log((IStatus)new Status(1, "com.vmware.vide.project", null, (Throwable)e));
        }
        finally {
            if (ot != null && ot.isAlive()) {
                ((StreamReaderThread)ot).kill();
            }
            if (et != null && et.isAlive()) {
                ((StreamReaderThread)et).kill();
            }
        }
        return null;
    }

    private String extractResults(String result, Map<String, String> results) {
        return result;
    }
}

