/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.ui;

import com.vmware.vide.project.config.wizard.AbstractContent;
import com.vmware.vide.project.config.wizard.IContentTreeVisitor;
import com.vmware.vide.project.config.wizard.WizardCategory;
import com.vmware.vide.project.config.wizard.project.ProjectData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class SelCategoryPage
extends WizardPage {
    private static final String CATLIST_TITLE = "&Available project types :";
    private static final String CATLIST_ERROR = "No available VMware development kit";
    protected TreeViewer categorylist;
    protected String catlist_title;
    protected String catlist_error;
    private boolean is_next_available;
    private Text filterText;

    public abstract void selectionChanged_CategoryList(SelectionChangedEvent var1);

    public abstract Object[] getCategoryElements();

    protected SelCategoryPage(String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
        this.catlist_title = CATLIST_TITLE;
        this.catlist_error = CATLIST_ERROR;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createList(container);
    }

    public boolean canFlipToNextPage() {
        return this.is_next_available;
    }

    public void nextButtonAvailable(boolean available) {
        if (available == this.is_next_available) {
            return;
        }
        this.is_next_available = available;
        this.getWizard().getContainer().updateButtons();
    }

    public WizardCategory getWizardCategoryFromSelection(SelectionChangedEvent event) {
        TreeSelection element;
        Object sel;
        if (event.getSelection() instanceof TreeSelection && (sel = (element = (TreeSelection)event.getSelection()).getFirstElement()) instanceof WizardCategory) {
            return (WizardCategory)sel;
        }
        return null;
    }

    public ProjectData getProjectDataFromSelection(SelectionChangedEvent event) {
        WizardCategory category = this.getWizardCategoryFromSelection(event);
        if (category != null) {
            return category.getProjectData();
        }
        return null;
    }

    private void createList(Composite workArea) {
        Composite comp = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 0, true, false);
        comp.setLayoutData((Object)gd);
        Label title = new Label(comp, 0);
        title.setText(this.catlist_title);
        int index = this.catlist_title.indexOf(38);
        if (index != -1 && index + 1 < this.catlist_title.length()) {
            final char titleMnemonic = Character.toLowerCase(this.catlist_title.charAt(index + 1));
            title.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128 && e.character == titleMnemonic) {
                        e.doit = false;
                        SelCategoryPage.this.categorylist.getTree().setFocus();
                    }
                }
            });
        }
        Label l = new Label(comp, 0);
        l.setText("F&ilter:");
        gd = new GridData(0x1000008, 0x1000000, true, false);
        l.setLayoutData((Object)gd);
        Text t = new Text(comp, 2052);
        gd = new GridData(4, 0, true, false);
        t.setLayoutData((Object)gd);
        t.setText("");
        this.filterText = t;
        t.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    SelCategoryPage.this.categorylist.refresh();
                }
            }
        });
        Composite listComposite = new Composite(workArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.categorylist = new TreeViewer(listComposite, 2048);
        this.categorylist.getControl().setLayoutData((Object)new GridData(1808));
        this.categorylist.setContentProvider((IContentProvider)this.getDefaultTreeContentProvider());
        this.categorylist.setLabelProvider((IBaseLabelProvider)this.getDefaultLabelProvider());
        this.categorylist.addSelectionChangedListener(this.getDefaultSelectionChangedList());
        this.categorylist.setInput((Object)this);
        this.categorylist.setComparator(new ViewerComparator());
        this.categorylist.collapseAll();
        this.categorylist.getTree().addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseHover(MouseEvent e) {
                Tree t = SelCategoryPage.this.categorylist.getTree();
                TreeItem o = t.getItem(new Point(e.x, e.y));
                if (o != null && o.getData() instanceof AbstractContent) {
                    AbstractContent ac = (AbstractContent)o.getData();
                    if (!o.getExpanded()) {
                        Object[] objs = ac.getChildren();
                        StringBuilder sb = new StringBuilder();
                        if (objs.length == 0) {
                            if (ac instanceof WizardCategory) {
                                sb.append(((WizardCategory)ac).getDescription());
                            }
                        } else {
                            Object[] objectArray = objs;
                            int n = objs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object obj = objectArray[n2];
                                if (obj instanceof WizardCategory) {
                                    sb.append(((WizardCategory)obj).getTitle());
                                    sb.append('\n');
                                }
                                ++n2;
                            }
                        }
                        t.setToolTipText(sb.toString());
                    }
                }
            }
        });
        this.categorylist.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (SelCategoryPage.this.filterText.getText().isEmpty()) {
                    return true;
                }
                boolean found = false;
                if (element instanceof AbstractContent) {
                    AbstractContent ac = (AbstractContent)element;
                    try {
                        ac.accept(new IContentTreeVisitor(){

                            @Override
                            public boolean visit(AbstractContent c) throws Exception {
                                if (c instanceof WizardCategory) {
                                    WizardCategory wc = (WizardCategory)c;
                                    if (!c.hasChildren() && this.matchWithFilter(wc.getTitle())) {
                                        throw new FilterMatchException();
                                    }
                                }
                                return true;
                            }

                            boolean matchWithFilter(String s) {
                                return s.toLowerCase().contains(SelCategoryPage.this.filterText.getText().toLowerCase());
                            }
                        });
                    }
                    catch (FilterMatchException filterMatchException) {
                        found = true;
                    }
                    catch (Exception exception) {
                        found = false;
                    }
                }
                return found;
            }
        });
    }

    public ITreeContentProvider getDefaultTreeContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] kits = SelCategoryPage.this.getCategoryElements();
                if (kits.length == 0) {
                    return new String[]{SelCategoryPage.this.catlist_error};
                }
                return kits;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof AbstractContent) {
                    return ((AbstractContent)element).getChildren();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof AbstractContent) {
                    return ((AbstractContent)element).hasChildren();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof AbstractContent) {
                    return ((AbstractContent)element).getParent();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public ISelectionChangedListener getDefaultSelectionChangedList() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelCategoryPage.this.selectionChanged_CategoryList(event);
            }
        };
    }

    public LabelProvider getDefaultLabelProvider() {
        return new CategoryLabelProvider();
    }

    protected final void updateDescription(SelectionChangedEvent event, String defaultMsg) {
        WizardCategory wc = this.getWizardCategoryFromSelection(event);
        String desc = null;
        if (wc != null) {
            desc = wc.getDescription();
        }
        if (desc != null && !desc.isEmpty()) {
            this.setDescription(desc);
        } else {
            this.setDescription(defaultMsg);
        }
    }

    public final class CategoryLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof AbstractContent) {
                return ((AbstractContent)element).getText();
            }
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof AbstractContent) {
                return ((AbstractContent)element).getBackground();
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof AbstractContent) {
                return ((AbstractContent)element).getForeground();
            }
            return null;
        }
    }

    final class FilterMatchException
    extends Exception {
        private static final long serialVersionUID = 1L;

        FilterMatchException() {
        }
    }
}

