/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.Activator;
import com.vmware.vide.deploy.AutoDeployOperation;
import com.vmware.vide.deploy.FileDeployExportData;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.IFileDeployExportDataReader;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public class FileDeployOperationsDatabase
implements IAutoDeployOperationsDatabase {
    private static final String PROPERTY_DEPLOY_OPERATIONS = "deploy-operations";
    static final String DEPLOY_PROPERTY_PREFIX = "deploy*";

    public static void put(String operationName, String value) {
        IPreferenceStore preference = Activator.getDefault().getPreferenceStore();
        FileDeployOperationsDatabase.putOperationName(preference, operationName);
        preference.setValue(DEPLOY_PROPERTY_PREFIX + operationName, value);
    }

    private static void putOperationName(IPreferenceStore preference, String operationName) {
        String[] operationNames;
        String[] stringArray = operationNames = FileDeployOperationsDatabase.getOperationNames(preference);
        int n = operationNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.equals(operationName)) {
                return;
            }
            ++n2;
        }
        String names = preference.getString(PROPERTY_DEPLOY_OPERATIONS);
        preference.setValue(PROPERTY_DEPLOY_OPERATIONS, String.valueOf(names) + DEPLOY_PROPERTY_PREFIX + operationName);
    }

    private static String[] getOperationNames(IPreferenceStore preference) {
        String names = preference.getString(PROPERTY_DEPLOY_OPERATIONS);
        return FileDeployOperationsDatabase.extractOperations(names);
    }

    public static String[] getOperationNames() {
        IPreferenceStore preference = Activator.getDefault().getPreferenceStore();
        return FileDeployOperationsDatabase.getOperationNames(preference);
    }

    public static String get(String operationName) {
        IPreferenceStore preference = Activator.getDefault().getPreferenceStore();
        return preference.getString(DEPLOY_PROPERTY_PREFIX + operationName);
    }

    public static void remove(String[] operations) {
        IPreferenceStore preference = Activator.getDefault().getPreferenceStore();
        FileDeployOperationsDatabase.removeOperationNames(preference, operations);
        String[] stringArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            preference.setValue(DEPLOY_PROPERTY_PREFIX + name, "");
            ++n2;
        }
    }

    private static void removeOperationNames(IPreferenceStore preference, String[] operations) {
        String[] operationNames = FileDeployOperationsDatabase.getOperationNames(preference);
        StringBuffer ops = new StringBuffer();
        String[] stringArray = operationNames;
        int n = operationNames.length;
        int n2 = 0;
        while (n2 < n) {
            String operationName = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = operations;
            int n3 = operations.length;
            int n4 = 0;
            while (n4 < n3) {
                String operation = stringArray2[n4];
                if (operationName.equals(operation)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                ops.append(DEPLOY_PROPERTY_PREFIX + operationName);
            }
            ++n2;
        }
        preference.setValue(PROPERTY_DEPLOY_OPERATIONS, ops.toString());
    }

    public static void addListener(IPropertyChangeListener listener) {
        IPreferenceStore preference = Activator.getDefault().getPreferenceStore();
        preference.addPropertyChangeListener(listener);
    }

    public static void removeListener(IPropertyChangeListener listener) {
        IPreferenceStore preference = Activator.getDefault().getPreferenceStore();
        preference.removePropertyChangeListener(listener);
    }

    public static boolean isDeployOperationsProperty(String property) {
        return property.equals(PROPERTY_DEPLOY_OPERATIONS);
    }

    public static String[] extractOperations(String internalOperations) {
        if (internalOperations != null && internalOperations.startsWith(DEPLOY_PROPERTY_PREFIX)) {
            return internalOperations.substring(DEPLOY_PROPERTY_PREFIX.length()).split("deploy\\*");
        }
        return new String[0];
    }

    @Override
    public IFileDeployExportDataReader[] getAllFileDeployExportDataReaders() {
        String[] names = FileDeployOperationsDatabase.getOperationNames();
        ArrayList<FileDeployExportData> readers = new ArrayList<FileDeployExportData>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                String name = stringArray[n2];
                FileDeployExportData reader = new FileDeployExportData();
                try {
                    reader.restore(name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block3;
                }
                readers.add(reader);
            }
            ++n2;
        }
        return readers.toArray(new FileDeployExportData[readers.size()]);
    }

    @Override
    public AutoDeployOperation[] getAutoDeployOperations() {
        String[] names = FileDeployOperationsDatabase.getOperationNames();
        ArrayList<AutoDeployOperation> ops = new ArrayList<AutoDeployOperation>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ops.add(new AutoDeployOperation(name, "", ""));
            ++n2;
        }
        return ops.toArray(new AutoDeployOperation[ops.size()]);
    }

    @Override
    public IFileDeployExportDataReader getFileDeployExportDataReader(String name) {
        FileDeployExportData reader = new FileDeployExportData();
        try {
            reader.restore(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reader;
    }
}

