/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.service.api;

import com.vmware.vide.project.service.Activator;
import com.vmware.vide.project.service.api.IProjectManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public enum ProjectService {
    INSTANCE;

    private final ILog logger = Activator.getDefault().getLog();
    List<IProjectManager> projectManagers = new ArrayList<IProjectManager>();
    private IProjectManager projectManager = null;
    private String version = Integer.toString(Integer.MIN_VALUE);

    private ProjectService() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.vmware.vide.project.service.ProjectManagerService");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n2 = extensions.length;
            int n3 = 0;
            while (n3 < n2) {
                IExtension ext = iExtensionArray[n3];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n4 = iConfigurationElementArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IConfigurationElement ce = iConfigurationElementArray[n5];
                    String id = null;
                    try {
                        Object o = ce.createExecutableExtension("class");
                        if (o instanceof IProjectManager) {
                            String version = ce.getAttribute("version");
                            id = ext.getUniqueIdentifier();
                            String string2 = id = id == null ? "Unknown extension" : id;
                            if (version == null) {
                                String msg = String.format("The version is not specified by [%s].", id);
                                this.logger.log((IStatus)new Status(4, "com.vmware.vide.project.service", msg));
                            } else {
                                int v = Integer.parseInt(version);
                                if (v > Integer.parseInt(this.version)) {
                                    this.version = version;
                                    this.projectManager = (IProjectManager)o;
                                }
                                this.projectManagers.add((IProjectManager)o);
                            }
                        } else {
                            this.logger.log((IStatus)new Status(4, "com.vmware.vide.project.service", "The class does not implement IProjectManager"));
                        }
                    }
                    catch (NumberFormatException e) {
                        String msg = String.format("Extension [%s] has bad version format.", id);
                        this.logger.log((IStatus)new Status(4, "com.vmware.vide.project.service", msg, (Throwable)e));
                    }
                    catch (CoreException e) {
                        this.logger.log((IStatus)new Status(4, "com.vmware.vide.project.service", "No class element", (Throwable)e));
                    }
                    ++n5;
                }
                ++n3;
            }
        }
    }

    public IProjectManager getProjectManager() {
        if (this.hasProjectManager()) {
            return this.projectManager;
        }
        return null;
    }

    public boolean hasProjectManager() {
        return !this.projectManagers.isEmpty();
    }
}

