/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.menu;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.ProjectMenu;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.menu.DynamicMenuContributionFactory;
import com.vmware.vide.project.menu.ProjectMenuExpression;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public abstract class DynamicGroupMenuVisibleWhenExpression
extends ProjectMenuExpression {
    private static final ILog logger = ProjectPlugin.getDefault().getLog();
    private final String devkitId;
    private final String groupId;
    private final String name;
    private final String groupContributionId;
    private final List<ProjectMenuAction> actions = new ArrayList<ProjectMenuAction>();
    private MenuManager groupMenuManager;

    DynamicGroupMenuVisibleWhenExpression(String devkitId, String groupName, List<ProjectMenu> menus) {
        this.devkitId = devkitId;
        this.name = groupName;
        this.groupId = DynamicMenuContributionFactory.getGroupMenuId(groupName);
        StringBuilder sb = new StringBuilder(this.groupId).append(".instance");
        this.groupContributionId = sb.toString();
        int i = 0;
        while (i < menus.size()) {
            ProjectMenu menu = menus.get(i);
            String id = this.getGroupItemId(menu, i);
            ProjectMenuAction action = new ProjectMenuAction(menu.getTitle(), menu);
            action.setId(id);
            this.actions.add(action);
            ++i;
        }
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        IProject project = this.getProject(context);
        String id = ProjectManager.getDevkitId(project);
        if (id == null || !this.devkitId.equals(id)) {
            return EvaluationResult.FALSE;
        }
        Evaluator evaluator = new Evaluator();
        LinkedHashSet<ProjectMenuAction> validActions = new LinkedHashSet<ProjectMenuAction>();
        for (ProjectMenuAction action : this.actions) {
            ProjectMenu menu = action.projectMenu;
            if (evaluator.evaluate(context, menu, project, menu.getProjectNatureIds()) == EvaluationResult.TRUE) {
                validActions.add(action);
                action.project = project;
                continue;
            }
            action.project = null;
        }
        this.updateGroupMenu(validActions, context);
        return EvaluationResult.FALSE;
    }

    protected abstract void updateGroupMenu(Set<ProjectMenuAction> var1, IEvaluationContext var2);

    protected final String getGroupId() {
        return this.groupId;
    }

    protected final String getGroupContributionId() {
        return this.groupContributionId;
    }

    protected final void removeGroupMenuContributionFromManager(IMenuManager manager) {
        if (manager.find(this.groupContributionId) != null) {
            manager.remove(this.groupContributionId);
        }
    }

    protected final MenuManager getGroupMenuManager() {
        if (this.groupMenuManager == null) {
            this.groupMenuManager = new MenuManager(this.name, this.groupContributionId);
        }
        return this.groupMenuManager;
    }

    protected final void updateGroupActions(IMenuManager manager, Set<ProjectMenuAction> validActions) {
        MenuManager groupMenuManager = this.getGroupMenuManager();
        for (ProjectMenuAction action : this.actions) {
            IContributionItem actionItem;
            if (validActions.contains((Object)action)) {
                actionItem = groupMenuManager.find(action.getId());
                if (actionItem != null) continue;
                groupMenuManager.add((IAction)action);
                continue;
            }
            actionItem = groupMenuManager.find(action.getId());
            if (actionItem == null) continue;
            groupMenuManager.remove(actionItem);
        }
    }

    private String getGroupItemId(ProjectMenu menu, int index) {
        StringBuilder sb = new StringBuilder(this.groupId);
        sb.append('.').append(menu.getTitle()).append(index);
        return sb.toString();
    }

    class Evaluator
    extends ProjectMenuExpression {
        Evaluator() {
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            return null;
        }
    }

    class ProjectMenuAction
    extends Action {
        private final ProjectMenu projectMenu;
        private IProject project;

        ProjectMenuAction(String name, ProjectMenu projectMenu) {
            super(name);
            this.projectMenu = projectMenu;
        }

        public void run() {
            if (this.project == null) {
                String msg = String.format("The action [%s] was invoked without project.", this.getText());
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                return;
            }
            try {
                try {
                    this.projectMenu.menuClicked(this.project);
                }
                catch (VIDEProjectException e) {
                    Utils.openDialog(e);
                    this.project = null;
                }
            }
            finally {
                this.project = null;
            }
        }
    }
}

