/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StreamReaderThread
extends Thread {
    private static final int INIT_BUFFER_SIZE = 128;
    private static final int EXTEND_BUFFER_SIZE = 256;
    private static final int MAX = 4096;
    public int max = 4096;
    private final InputStream is;
    private byte[] buffer = new byte[128];
    private int index = 0;
    private final ILog logger;
    public String charset;

    public StreamReaderThread(String name, InputStream is, ILog logger, String charset) {
        super(name);
        this.is = is;
        this.logger = logger;
        this.charset = charset;
    }

    @Override
    public void run() {
        try {
            try {
                int b;
                while ((b = this.is.read()) != -1) {
                    if (this.index == this.max) continue;
                    this.buffer[this.index++] = (byte)b;
                    if (this.buffer.length == this.index) {
                        byte[] newbuffer = Arrays.copyOf(this.buffer, this.buffer.length + 256);
                        this.buffer = newbuffer;
                    }
                    if (!this.isInterrupted()) continue;
                    break;
                }
            }
            catch (IOException e) {
                this.logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
                try {
                    this.is.close();
                }
                catch (IOException e2) {
                    this.logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e2));
                }
            }
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {
                this.logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
            }
        }
    }

    public String getRead() {
        if (this.charset != null) {
            try {
                return new String(Arrays.copyOf(this.buffer, this.index), this.charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String msg = String.format("Unsupported charset %s.", this.charset);
                this.logger.log((IStatus)new Status(2, "com.vmware.vide.project", msg));
            }
        }
        return new String(Arrays.copyOf(this.buffer, this.index));
    }

    public void kill() {
        this.interrupt();
        if (this.isAlive() && this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                this.logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
            }
        }
    }
}

