/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.vib.PropertyManager;
import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBFileManager;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.BulletinSpecificPage;
import com.vmware.vide.project.vib.ui.VIBDesignPage;
import java.io.File;
import org.eclipse.ui.forms.editor.IFormPage;

public class BulletinFileInfo
extends VIBFileInfo {
    private static final String PAGE_NAME = "bulletin";
    private static final String PAGE_ID = "page_bulletin";
    private static final String ROOT_TAG = "bulletin";
    private static final String ROOT_PROPERTY = "bulletin.platforms";
    private static final String BULLETIN_XML = "bulletin.xml";
    private static final String TEMPLATE_XML = "bulletin-template.xml";
    private static final File DEFAULT_TEMPLATE = VIBFileManager.VIB_SAMPLEPATH.append("bulletin-template.xml").toFile();
    private static final String BULLETIN_XSDFILE = "/resources/xmlschemas/vib20-bulletin.xsd";
    VIBDesignPage platformpage;
    private BulletinSpecificPage specificPage;
    File schemaFile;

    public BulletinFileInfo(VIBFileManager manager) {
        super(manager, "bulletin", "bulletin", BULLETIN_XML, DEFAULT_TEMPLATE);
    }

    @Override
    public File getXSDSchemaFile() {
        if (this.schemaFile != null) {
            return this.schemaFile;
        }
        this.schemaFile = ProjectPlugin.getDefault().getResource(BULLETIN_XSDFILE);
        return this.schemaFile;
    }

    @Override
    public VIBDesignPage[] getDesignPages() {
        VIBProperty rootproperty = this.getPropertyManager().getProperty(ROOT_PROPERTY);
        if (this.isValid() && rootproperty != null && rootproperty.getVIBFile() != null) {
            return new VIBDesignPage[]{this.getPlatformPage(rootproperty)};
        }
        return new VIBDesignPage[0];
    }

    private IFormPage[] createSpecificPages() {
        PropertyManager pm = this.getPropertyManager();
        VIBFileManager fm = this.getFileManager();
        if (pm.hasTheRoot("bulletin")) {
            this.specificPage = new BulletinSpecificPage(fm.getEditor(), this);
            return new IFormPage[]{this.specificPage};
        }
        return new IFormPage[0];
    }

    @Override
    public IFormPage[] getSpecificPages() {
        if (this.specificPage == null) {
            return this.createSpecificPages();
        }
        return new IFormPage[]{this.specificPage};
    }

    private VIBDesignPage getPlatformPage(VIBProperty rootproperty) {
        if (this.platformpage != null) {
            return this.platformpage;
        }
        this.platformpage = new VIBDesignPage(this.getFileManager().getEditor(), PAGE_ID, this, rootproperty, "platforms", "platforms", "Software Platform", "List the platforms to which this software will apply.", null, null);
        return this.platformpage;
    }
}

