/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib.ui;

import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.ui.IVIBFormPage;
import com.vmware.vide.project.vib.ui.VIBOverviewPage;
import com.vmware.vide.vxmleditor.Schema;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class UIBlock {
    private FormToolkit toolkit;
    private Composite parent;
    private IMessageManager mmanager;
    private VIBProperty property;
    private Text textwidget;
    private Button checkbuttonwidget;
    private Table elementTable;
    private TableViewer tableViewer;
    private IVIBFormPage owner;
    private static final int ADD_BUTTON = 1;
    private static final int EDIT_BUTTON = 2;
    private static final int INDENT_SIZE = 15;
    private static final String ATTRBUTE_KEY = "ATTRIBUTE_KEY";

    public UIBlock(IVIBFormPage owner, FormToolkit toolkit, Composite parent, IMessageManager mmanager, VIBProperty property) {
        this.owner = owner;
        this.toolkit = toolkit;
        this.parent = parent;
        this.mmanager = mmanager;
        this.property = property;
        if (property.isCheckBoxWidget()) {
            this.createCheckBoxField();
        } else if (property.isListbox()) {
            this.createListBox();
        } else if (property.isMultiTextWidget()) {
            this.createMultiTextField();
        } else {
            this.createTextField();
        }
    }

    public void refresh(VIBFileInfo vibfile) {
        if (this.property.isValidVibFileInfo(vibfile)) {
            String value;
            String string = value = this.property.getPropertyValue() == null ? "" : this.property.getPropertyValue();
            if (this.property.isCheckBoxWidget()) {
                this.checkbuttonwidget.setSelection(Boolean.parseBoolean(value));
            } else {
                if (this.property.isListbox()) {
                    this.loadTable();
                    this.updateListItemsInXML();
                    return;
                }
                this.textwidget.setText(value);
            }
            this.property.valueChagned(value);
            this.owner.setDirty(false);
            this.owner.getVIBEditor().firePropertyChange();
        }
    }

    private void createTextField() {
        final Label label = this.toolkit.createLabel(this.parent, String.valueOf(this.property.getTitle()) + ":");
        label.setToolTipText(this.property.getDescription());
        this.textwidget = this.toolkit.createText(this.parent, this.property.getPropertyValue(), 2052);
        GridData gd = new GridData(4);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.textwidget.setLayoutData((Object)gd);
        this.textwidget.setData((Object)this.property);
        final String inputformat = this.property.getInputFormat();
        this.verifyText(label, this.textwidget.getText(), inputformat);
        this.textwidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textvalue = UIBlock.this.textwidget.getText();
                UIBlock.this.verifyText(label, textvalue, inputformat);
                UIBlock.this.property.valueChagned(textvalue);
                UIBlock.this.owner.setDirty(true);
                UIBlock.this.owner.getVIBEditor().firePropertyChange();
                UIBlock.this.textwidget.setToolTipText(textvalue);
            }
        });
        this.textwidget.setToolTipText(this.property.getPropertyValue());
    }

    private void createMultiTextField() {
        final Label label = this.toolkit.createLabel(this.parent, String.valueOf(this.property.getTitle()) + ":");
        GridData gd = new GridData(4);
        gd.verticalSpan = 4;
        label.setLayoutData((Object)gd);
        label.setToolTipText(this.property.getDescription());
        this.textwidget = this.toolkit.createText(this.parent, this.property.getPropertyValue(), 770);
        gd = new GridData(4);
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        gd.verticalSpan = 4;
        gd.heightHint = this.textwidget.getLineHeight() * 4;
        this.textwidget.setLayoutData((Object)gd);
        this.textwidget.setData((Object)this.property);
        final String inputformat = this.property.getInputFormat();
        this.verifyText(label, this.textwidget.getText(), inputformat);
        this.textwidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textvalue = UIBlock.this.textwidget.getText();
                UIBlock.this.verifyText(label, textvalue, inputformat);
                UIBlock.this.property.valueChagned(textvalue);
                UIBlock.this.owner.setDirty(true);
                UIBlock.this.owner.getVIBEditor().firePropertyChange();
                UIBlock.this.textwidget.setToolTipText(textvalue);
            }
        });
        this.textwidget.setToolTipText(this.property.getPropertyValue());
    }

    private void createListBox() {
        Label label = this.toolkit.createLabel(this.parent, String.valueOf(this.property.getTitle()) + ":");
        label.setToolTipText(this.property.getDescription());
        this.elementTable = this.toolkit.createTable(this.parent, 2562);
        GridData gd = new GridData(4);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = this.elementTable.getItemHeight() * 3;
        label.setLayoutData((Object)gd);
        this.elementTable.setLayoutData((Object)gd);
        this.elementTable.setHeaderVisible(false);
        this.createTableViewer(this.elementTable);
        GridData buttonGrid = new GridData(4);
        buttonGrid.horizontalSpan = 1;
        buttonGrid.horizontalAlignment = 131072;
        buttonGrid.grabExcessHorizontalSpace = false;
        Button bAdd = new Button(this.parent, 1024);
        bAdd.setText("Add");
        bAdd.setLayoutData((Object)buttonGrid);
        bAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                popUpDialog dialog = new popUpDialog(UIBlock.this.parent.getShell(), UIBlock.this.elementTable.getSelectionIndex(), 1);
                dialog.open();
            }
        });
        final Button bEdit = new Button(this.parent, 1024);
        bEdit.setText("Edit");
        bEdit.setEnabled(false);
        bEdit.setLayoutData((Object)buttonGrid);
        final Button bDelete = new Button(this.parent, 1024);
        bDelete.setText("Delete");
        bDelete.setLayoutData((Object)buttonGrid);
        bDelete.setEnabled(false);
        bEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectedIndex = UIBlock.this.elementTable.getSelectionIndex();
                popUpDialog dialog = new popUpDialog(UIBlock.this.parent.getShell(), selectedIndex, 2);
                dialog.open();
                UIBlock.this.elementTable.setSelection(selectedIndex);
            }
        });
        bDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox userConfirmationbox = new MessageBox(UIBlock.this.parent.getShell(), 288);
                userConfirmationbox.setMessage("Are you sure you want to remove the item?");
                userConfirmationbox.setText("Remove " + UIBlock.this.property.getTitle());
                int userconfirmation = userConfirmationbox.open();
                if (userconfirmation == 32) {
                    int[] selectionIndices = UIBlock.this.elementTable.getSelectionIndices();
                    UIBlock.this.elementTable.remove(selectionIndices);
                    int i = selectionIndices.length - 1;
                    while (i > -1) {
                        UIBlock.this.property.getListElements().remove(selectionIndices[i]);
                        --i;
                    }
                    UIBlock.this.updateListItemsInXML();
                    bEdit.setEnabled(false);
                    bDelete.setEnabled(false);
                }
            }
        });
        this.elementTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UIBlock.this.elementTable.getSelectionCount() == 1) {
                    bEdit.setEnabled(true);
                    bDelete.setEnabled(true);
                } else if (UIBlock.this.elementTable.getSelectionCount() == 0) {
                    bEdit.setEnabled(false);
                    bDelete.setEnabled(false);
                } else {
                    bDelete.setEnabled(true);
                    bEdit.setEnabled(false);
                }
            }
        });
        this.loadTable();
    }

    private void loadTable() {
        this.elementTable.removeAll();
        List<Map<String, String>> elemetsTableList = this.property.getListElements();
        if (elemetsTableList != null) {
            for (Map<String, String> element : elemetsTableList) {
                String elementValue = element.get("::XMLTAGVALUE::");
                this.tableViewer.add((Object)elementValue);
            }
        }
    }

    public void updateListItemsInXML() {
        this.property.updateXML();
        this.owner.setDirty(true);
        this.owner.getVIBEditor().firePropertyChange();
    }

    private void createTableViewer(Table table) {
        this.tableViewer = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
        table.setLayout((Layout)layout);
        table.setHeaderVisible(false);
    }

    private void verifyText(Label label, String value, String inputformat) {
        String textvalue = this.textwidget.getText();
        if (inputformat != null) {
            if (!textvalue.matches(inputformat)) {
                this.mmanager.addMessage((Object)label.getText(), "not matched with input format " + inputformat, null, 3, (Control)this.textwidget);
                this.owner.addErrorOnPage(this.property);
            } else {
                this.owner.removeErrorOnPage(this.property);
                this.mmanager.removeMessage((Object)label.getText(), (Control)this.textwidget);
            }
        }
    }

    private void createCheckBoxField() {
        this.checkbuttonwidget = this.toolkit.createButton(this.parent, this.property.getTitle(), 32);
        this.checkbuttonwidget.setSelection(this.property.isCheckBoxSelected());
        this.checkbuttonwidget.setData((Object)this.property);
        GridData gd = new GridData(4);
        gd.horizontalSpan = 3;
        this.checkbuttonwidget.setLayoutData((Object)gd);
        this.checkbuttonwidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIBlock.this.property.valueChagned(UIBlock.this.checkbuttonwidget.getSelection() ? "true" : "false");
                UIBlock.this.owner.setDirty(true);
                UIBlock.this.owner.getVIBEditor().firePropertyChange();
            }
        });
        this.checkbuttonwidget.setToolTipText(this.property.getDescription());
    }

    public class popUpDialog
    extends Dialog {
        String value;
        Text text;
        Text[] attributesTextboxes;
        Label[] attributeKeyLabels;
        int index;
        int buttonType;
        Map<String, String> selectedElementvalues;
        List<Schema.Elem> possibleListofAttributes;

        popUpDialog(Shell parentShell, int index, int buttonType) {
            super(parentShell);
            this.index = index;
            if (index > -1) {
                this.selectedElementvalues = UIBlock.this.property.getListElements().get(index);
                this.value = this.selectedElementvalues.get("::XMLTAGVALUE::");
            }
            this.possibleListofAttributes = UIBlock.this.property.getVIBFile().getAttributeList(UIBlock.this.property);
            this.buttonType = buttonType;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridData gd = new GridData(1808);
            gd.verticalIndent = 5;
            gd.horizontalIndent = 5;
            composite.setLayoutData((Object)gd);
            composite.setLayout((Layout)new GridLayout(3, true));
            Label descr = new Label(composite, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            gd.horizontalAlignment = 4;
            descr.setLayoutData((Object)gd);
            descr.setText(UIBlock.this.property.getTitle());
            descr = new Label(composite, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.horizontalAlignment = 4;
            descr.setLayoutData((Object)gd);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = 15;
            descr.setLayoutData((Object)gd);
            descr.setText("Enter a value:");
            this.text = new Text(composite, 2048);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 4;
            this.text.setLayoutData((Object)gd);
            this.text.setToolTipText(UIBlock.this.property.getTitle().trim());
            switch (this.buttonType) {
                case 1: {
                    this.text.setText("");
                    if (this.possibleListofAttributes.size() <= 0) break;
                    this.loadAttributeValues(composite, gd, false);
                    break;
                }
                case 2: {
                    this.text.setText(this.value);
                    if (this.possibleListofAttributes.size() <= 0) break;
                    this.loadAttributeValues(composite, gd, true);
                }
            }
            this.getShell().setText(UIBlock.this.property.getTitle());
            return composite;
        }

        public void loadAttributeValues(Composite composite, GridData gd, boolean fillValues) {
            this.attributeKeyLabels = new Label[this.possibleListofAttributes.size()];
            this.attributesTextboxes = new Text[this.possibleListofAttributes.size()];
            int i = 0;
            while (i < this.possibleListofAttributes.size()) {
                String key = this.possibleListofAttributes.get((int)i).name.trim();
                String value = "";
                if (fillValues) {
                    value = this.selectedElementvalues.get(key) == null ? "" : this.selectedElementvalues.get(key);
                }
                this.attributeKeyLabels[i] = new Label(composite, 0);
                gd = new GridData(768);
                gd.horizontalSpan = 1;
                gd.horizontalAlignment = 4;
                gd.horizontalIndent = 15;
                this.attributeKeyLabels[i].setLayoutData((Object)gd);
                this.attributeKeyLabels[i].setText(VIBOverviewPage.capitalizeFirstCharOnly(key));
                this.attributesTextboxes[i] = new Text(composite, 2048);
                gd = new GridData(768);
                gd.horizontalAlignment = 4;
                gd.horizontalSpan = 2;
                this.attributesTextboxes[i].setLayoutData((Object)gd);
                this.attributesTextboxes[i].setData(UIBlock.ATTRBUTE_KEY, (Object)key);
                this.attributesTextboxes[i].setToolTipText(key);
                if (fillValues) {
                    this.attributesTextboxes[i].setText(value);
                } else {
                    this.attributesTextboxes[i].setText("");
                }
                ++i;
            }
        }

        protected void okPressed() {
            switch (this.buttonType) {
                case 1: {
                    String errorTextboxName = this.getEmptyTextboxeName();
                    if (errorTextboxName != null) {
                        MessageDialog.openError((Shell)UIBlock.this.parent.getShell(), (String)UIBlock.this.property.getTitle(), (String)(String.valueOf(errorTextboxName) + " cannot be empty."));
                        return;
                    }
                    UIBlock.this.tableViewer.insert((Object)this.text.getText().trim(), this.index + 1);
                    this.selectedElementvalues = new TreeMap<String, String>();
                    this.updateListValues(true);
                    break;
                }
                case 2: {
                    String errorTextboxName = this.getEmptyTextboxeName();
                    if (errorTextboxName != null) {
                        MessageDialog.openError((Shell)UIBlock.this.parent.getShell(), (String)UIBlock.this.property.getTitle(), (String)(String.valueOf(errorTextboxName) + " cannot be empty."));
                        return;
                    }
                    this.updateListValues(false);
                    UIBlock.this.loadTable();
                }
            }
            super.okPressed();
        }

        private String getEmptyTextboxeName() {
            if (this.text.getText().trim().length() == 0) {
                return this.text.getToolTipText();
            }
            Text[] textArray = this.attributesTextboxes;
            int n = this.attributesTextboxes.length;
            int n2 = 0;
            while (n2 < n) {
                Text attrTextbox = textArray[n2];
                if (attrTextbox.getText().trim().length() == 0) {
                    return attrTextbox.getToolTipText();
                }
                ++n2;
            }
            return null;
        }

        public void updateListValues(boolean isadd) {
            int i = 0;
            while (i < this.possibleListofAttributes.size()) {
                String key = this.attributesTextboxes[i].getData(UIBlock.ATTRBUTE_KEY).toString();
                String value = this.attributesTextboxes[i].getText().trim();
                if (value.length() > 0) {
                    this.selectedElementvalues.put(key, value);
                }
                ++i;
            }
            this.selectedElementvalues.put("::XMLTAGVALUE::", this.text.getText().trim());
            if (isadd) {
                UIBlock.this.property.getListElements().add(this.index + 1, this.selectedElementvalues);
            } else {
                UIBlock.this.property.getListElements().set(this.index, this.selectedElementvalues);
            }
            UIBlock.this.updateListItemsInXML();
        }
    }
}

