/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import java.util.ArrayList;

public class AutoDeployOperation {
    private String name;
    private String preCommands;
    private String postCommands;

    public AutoDeployOperation(String name, String preCommands, String postCommands) {
        this.name = name;
        this.preCommands = preCommands;
        this.postCommands = postCommands;
    }

    public String getName() {
        return this.name;
    }

    public String getPreCommands() {
        return this.preCommands;
    }

    public String getPostCommands() {
        return this.postCommands;
    }

    public String[] getPreCommandList() {
        return this.parse(this.preCommands);
    }

    public String[] getPostCommandList() {
        return this.parse(this.postCommands);
    }

    private boolean isConcatenate(String s) {
        return !s.isEmpty() && s.lastIndexOf(92) == s.length() - 1;
    }

    private boolean isBlanksOrComments(String s) {
        if (s.isEmpty()) {
            return true;
        }
        if (s.matches("\\s+")) {
            return true;
        }
        return s.matches("\\s*#.*$");
    }

    private String[] parse(String commands) {
        ArrayList<String> commandList = new ArrayList<String>();
        if (commands != null && !commands.isEmpty()) {
            String[] lines = commands.split("\n");
            String current = "";
            int i = 0;
            while (i < lines.length) {
                if (this.isConcatenate(current)) {
                    current = String.valueOf(current.substring(0, current.length() - 1)) + lines[i];
                } else if (this.isBlanksOrComments(current)) {
                    current = lines[i];
                } else {
                    commandList.add(current);
                    current = lines[i];
                }
                ++i;
            }
            if (this.isConcatenate(current)) {
                current = current.substring(0, current.length() - 1);
            }
            if (!this.isBlanksOrComments(current)) {
                commandList.add(current);
            }
        }
        return commandList.toArray(new String[commandList.size()]);
    }
}

