/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.AutoDeployOperation;
import com.vmware.vide.deploy.CommandOutputConsoleAdaptor;
import com.vmware.vide.deploy.FileDeployExportOperation;
import com.vmware.vide.deploy.FileDeployUtilities;
import com.vmware.vide.deploy.IAutoDeployOperationsDatabase;
import com.vmware.vide.deploy.IFileDeployExportDataReader;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.TargetManagerPlugin;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class AutoDeployer {
    private static final int OK = 0;
    private static final int ERR_NO_CONNECTION = 1;
    private static final int ERR_NO_DIRECTORY = 2;
    private static final int CANCELED = 3;
    private static final int ERR_COMMAND_FAILED = 4;
    private static final int ERR_NO_COMMAND_SERVICE = 5;
    private static final int ERR_NO_TARGET = 6;
    private static final int ERR_NO_TARGET_MANAGER = 7;
    private static final String PREDEPLOY = ">>> PRE DEPLOY COMMANDS: ";
    private static final String COPYING = ">>> COPYING ";
    private static final String POSTDEPLOY = ">>> POST DEPLOY COMMANDS: ";
    private static final String DONE = ">>> DONE.";
    private static final String COMMAND = ">>> EXECUTING '";
    private static final String COMMAND_END = "'";
    private IAutoDeployOperationsDatabase database;
    private MessageConsole console;

    public AutoDeployer(IAutoDeployOperationsDatabase database, MessageConsole console) {
        this.database = database;
        this.console = console;
    }

    public AutoDeployer(IAutoDeployOperationsDatabase database) {
        this(database, null);
    }

    public void run(IProgressMonitor monitor) {
        AutoDeployOperation[] operations = this.database.getAutoDeployOperations();
        if (operations == null) {
            return;
        }
        IOverwriteQuery copyAll = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                return "ALL";
            }
        };
        AutoDeployOperation[] autoDeployOperationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            int status;
            AutoDeployOperation operation = autoDeployOperationArray[n2];
            IFileDeployExportDataReader exportConfigData = this.database.getFileDeployExportDataReader(operation.getName());
            if (exportConfigData != null && (status = this.runPreCommands(operation, exportConfigData, monitor)) == 0 && (status = this.deployFiles(exportConfigData, monitor, copyAll)) == 0) {
                this.runPostCommands(operation, exportConfigData, monitor);
            }
            ++n2;
        }
        this.sendMessageToDeployConsole(DONE, true, false);
    }

    protected void errorMessage(String message, Throwable e) {
        if (e != null) {
            String completeMessage = String.valueOf(message) + " " + e.getMessage();
            System.err.println(completeMessage);
            this.sendMessageToDeployConsole(completeMessage, true, true);
        } else {
            this.sendMessageToDeployConsole(message, true, true);
        }
    }

    private void sendMessageToDeployConsole(String message, boolean isStatusMessage, boolean isError) {
        if (this.console != null) {
            try {
                MessageConsoleStream stream = this.console.newMessageStream();
                stream.println(message);
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (isError) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    private int runPreCommands(AutoDeployOperation operation, IFileDeployExportDataReader exportConfigData, IProgressMonitor monitor) {
        String[] commands = operation.getPreCommandList();
        if (commands.length > 0) {
            this.sendMessageToDeployConsole(PREDEPLOY, true, false);
        }
        return this.runCommands(exportConfigData, commands, monitor);
    }

    private int runPostCommands(AutoDeployOperation operation, IFileDeployExportDataReader exportConfigData, IProgressMonitor monitor) {
        String[] commands = operation.getPostCommandList();
        if (commands.length > 0) {
            this.sendMessageToDeployConsole(POSTDEPLOY, true, false);
        }
        return this.runCommands(exportConfigData, commands, monitor);
    }

    private int runCommands(IFileDeployExportDataReader exportConfigData, String[] commands, IProgressMonitor monitor) {
        int status = this.validateOrCreateDestinationFolder(exportConfigData);
        if (status != 0) {
            return status;
        }
        CommandOutputConsoleAdaptor commandOutputConsoleAdaptor = this.console != null ? new CommandOutputConsoleAdaptor(this.console) : null;
        String targetDestination = exportConfigData.getTargetDestination();
        int index = targetDestination.indexOf(":");
        String location = index == -1 ? targetDestination : targetDestination.substring(index + 1);
        ITarget target = FileDeployUtilities.getTargetByName(targetDestination);
        if (target == null) {
            this.errorMessage("Cannot get commands service.", null);
            return 6;
        }
        ITargetManager tm = TargetManagerPlugin.getTheTargetManager();
        if (tm == null) {
            this.errorMessage("Cannot get the target manager.", null);
            return 7;
        }
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            try {
                String cmdLine = "cd " + location + " && " + command;
                this.sendMessageToDeployConsole(COMMAND + cmdLine + COMMAND_END, true, false);
                int retval = target.executeCommand(cmdLine, (ICommandOutputListener)commandOutputConsoleAdaptor, monitor);
                if (retval != 0) {
                    String message = "Command " + command + " failed returning " + retval + " at " + targetDestination;
                    this.errorMessage(message, null);
                    status = 4;
                }
            }
            catch (Exception e) {
                String message = "Exception executing command " + command + ". details: " + e.getMessage();
                this.errorMessage(message, e);
                status = 4;
            }
            ++n2;
        }
        if (commandOutputConsoleAdaptor != null) {
            commandOutputConsoleAdaptor.close();
        }
        return status;
    }

    private int validateOrCreateDestinationFolder(IFileDeployExportDataReader exportConfigData) {
        String targetDestination = exportConfigData.getTargetDestination();
        String targetType = exportConfigData.getTargetType();
        if (!FileDeployUtilities.isValidTarget(targetDestination) && !FileDeployUtilities.createTarget(targetDestination, targetType)) {
            this.errorMessage("Cannot create the new target: " + targetDestination, null);
            return 1;
        }
        File dstFolder = FileDeployUtilities.getFolderOrCreateFullPath(targetDestination);
        if (dstFolder == null || !dstFolder.exists() || !dstFolder.isDirectory()) {
            this.errorMessage("No target directory " + targetDestination, null);
            return 2;
        }
        return 0;
    }

    private int deployFiles(IFileDeployExportDataReader exportConfigData, IProgressMonitor monitor, IOverwriteQuery query) {
        String destination = exportConfigData.getTargetDestination();
        List<IResource> resources = exportConfigData.getResources();
        if (resources.size() > 0) {
            StringBuilder files = new StringBuilder();
            for (IResource r : resources) {
                if (files.length() != 0) {
                    files.append(",");
                }
                files.append(r.getName());
            }
            files.insert(0, COPYING);
            this.sendMessageToDeployConsole(files.toString(), true, false);
            int status = this.validateOrCreateDestinationFolder(exportConfigData);
            if (status != 0) {
                return status;
            }
            FileDeployExportOperation op = new FileDeployExportOperation(null, resources, destination, query);
            op.setCreateLeadupStructure(exportConfigData.getCreateEntireDirsOption());
            op.setOverwriteFiles(true);
            try {
                op.run(monitor);
            }
            catch (InterruptedException e) {
                String message = "Canceled the operation: " + exportConfigData.getName();
                this.errorMessage(message, e);
                return 3;
            }
        }
        return 0;
    }
}

