/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.FileDeployExporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExportOperation;

public class FileDeployExportOperation
extends FileSystemExportOperation
implements IRunnableWithProgress {
    private IPath path;
    private IProgressMonitor monitor;
    private FileDeployExporter exporter;
    private List<IStatus> errorTable = new ArrayList<IStatus>(1);
    private List<IResource> resourcesToExport;
    private IResource resource;
    private boolean createLeadupStructure = true;

    public FileDeployExportOperation(IResource res, List<IResource> resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        super(res, resources, destinationPath, overwriteImplementor);
        this.resourcesToExport = resources;
        this.path = new Path(destinationPath);
        this.exporter = new FileDeployExporter(destinationPath);
        this.resource = res;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        for (IResource res : this.resourcesToExport) {
            result += this.countChildrenOf(res);
        }
        return result;
    }

    protected void createLeadupDirectoriesFor(IResource childResource) {
        IPath resourcePath = childResource.getFullPath().removeLastSegments(1);
        int i = 0;
        while (i < resourcePath.segmentCount()) {
            this.path = this.path.append(resourcePath.segment(i));
            this.exporter.createFolder(this.path);
            ++i;
        }
    }

    protected void exportAllResources() throws InterruptedException {
        if (this.resource.getType() == 1) {
            this.exportFile((IFile)this.resource, this.path);
        } else {
            try {
                this.exportChildren(((IContainer)this.resource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    protected void exportChildren(IResource[] children, IPath currentPath) throws InterruptedException {
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            if (child.isAccessible()) {
                if (child.getType() == 1) {
                    this.exportFile((IFile)child, currentPath);
                } else {
                    IPath destination = currentPath.append(child.getName());
                    this.exporter.createFolder(destination);
                    try {
                        this.exportChildren(((IContainer)child).members(), destination);
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
            }
            ++i;
        }
    }

    protected void exportFile(IFile file, IPath location) throws InterruptedException {
        IPath fullPath = location.append(file.getName());
        this.monitor.subTask(file.getFullPath().toString());
        String properPathString = fullPath.toOSString();
        File targetFile = new File(properPathString);
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", "Cannot overwrite target file [" + targetFile.getAbsolutePath() + "]"));
            this.monitor.worked(1);
            return;
        }
        try {
            this.exporter.write(file, fullPath);
        }
        catch (IOException e) {
            this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", "File Deploy Export error [" + fullPath + "] " + e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            this.errorTable.add((IStatus)new Status(4, "org.eclipse.ui", "File Deploy Export error [" + fullPath + "] " + e.getMessage(), (Throwable)e));
        }
        this.monitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        IPath initPath = (IPath)this.path.clone();
        for (IResource currentResource : this.resourcesToExport) {
            if (!currentResource.isAccessible()) continue;
            this.path = initPath;
            if (this.resource == null) {
                if (this.createLeadupStructure) {
                    this.createLeadupDirectoriesFor(currentResource);
                }
            } else {
                IPath containersToCreate = currentResource.getFullPath().removeFirstSegments(this.resource.getFullPath().segmentCount()).removeLastSegments(1);
                int i = 0;
                while (i < containersToCreate.segmentCount()) {
                    this.path = this.path.append(containersToCreate.segment(i));
                    this.exporter.createFolder(this.path);
                    ++i;
                }
            }
            if (currentResource.getType() == 1) {
                this.exportFile((IFile)currentResource, this.path);
                continue;
            }
            this.path = this.path.append(currentResource.getName());
            this.exporter.createFolder(this.path);
            try {
                this.exportChildren(((IContainer)currentResource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, "Problems were encountered during file deploy export:", null);
    }

    public void run(IProgressMonitor progressMonitor) throws InterruptedException {
        this.monitor = progressMonitor;
        if (this.resource != null) {
            if (this.createLeadupStructure) {
                this.createLeadupDirectoriesFor(this.resource);
            }
            if (this.resource.getType() != 1) {
                this.path = this.path.append(this.resource.getName());
                this.exporter.createFolder(this.path);
            }
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
            this.monitor.beginTask("File deploy exporting:", totalWork);
            if (this.resourcesToExport == null) {
                this.exportAllResources();
            } else {
                this.exportSpecifiedResources();
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateLeadupStructure(boolean value) {
        super.setCreateLeadupStructure(value);
        this.createLeadupStructure = value;
    }
}

