/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vmwbrepository.service.impl;

import com.vmware.vide.vmwbrepository.Artifact;
import com.vmware.vide.vmwbrepository.WebServiceController;
import com.vmware.vide.vmwbrepository.service.api.IArtifact;
import com.vmware.vide.vmwbrepository.service.api.IVMWBRepositoryService;
import java.util.ArrayList;
import java.util.List;

public class VMWBRepositoryService
implements IVMWBRepositoryService {
    private final WebServiceController webController = new WebServiceController();

    public IArtifact getArtifact(String ident, boolean credentialsRequired) throws Exception {
        return this.webController.getArtifact(ident, credentialsRequired);
    }

    public List<IArtifact> getArtifacts(String type) throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        this.webController.getArtifacts(artifacts, type);
        ArrayList<IArtifact> results = new ArrayList<IArtifact>();
        for (Artifact a : artifacts) {
            results.add(a);
        }
        return results;
    }

    public List<IArtifact> getDependencies(String id) throws Exception {
        List<Artifact> artifacts = this.webController.getDependencies(id);
        ArrayList<IArtifact> results = new ArrayList<IArtifact>();
        for (Artifact a : artifacts) {
            results.add(a);
        }
        return results;
    }

    public List<IArtifact> getVMWBPackagesArtifacts() throws Exception {
        List<Artifact> artifacts = this.webController.getVMWBPackagesArtifacts();
        ArrayList<IArtifact> results = new ArrayList<IArtifact>();
        for (Artifact a : artifacts) {
            results.add(a);
        }
        return results;
    }

    public String getTextualContent(String name) {
        return this.webController.getTextualContent(name);
    }

    public void setCredentials(String username, String password) {
        this.webController.setCredentials(username, password);
    }

    public String getUserName() {
        return this.webController.getUserName();
    }

    public String getPassword() {
        return this.webController.getPassword();
    }

    public boolean hasUserName() {
        return this.webController.getUserName() != null && !this.webController.getUserName().isEmpty();
    }
}

