/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.translate.Formats;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import com.vmware.vide.utils.xml.XMLParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Schema
extends XMLParser {
    private String schemafilePathLocation;
    public String xmlComment;
    public Type myStringType;
    public Type myBooleanType;
    public ArrayList<Elem> symbols = new ArrayList();
    public ArrayList<Elem> attrs = new ArrayList();
    Document myDoc;

    public Schema() {
        this.myStringType = new Type();
        this.myStringType.isString = true;
        this.myBooleanType = new Type();
        this.myBooleanType.isBoolean = true;
    }

    public Elem elementNode(Node node, boolean isgroup) {
        NamedNodeMap attrs;
        Elem el = new Elem();
        if (this.xmlComment != null && !this.xmlComment.isEmpty()) {
            el.comment = this.xmlComment;
            this.xmlComment = null;
        }
        if ((attrs = node.getAttributes()) != null) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                el.name = attr.getNodeValue();
            }
            if (isgroup) {
                el.tagType = "group";
            }
            if ((attr = attrs.getNamedItem("ref")) != null) {
                el.refName = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("minOccurs")) != null) {
                el.min = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("maxOccurs")) != null) {
                el.max = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("description")) != null) {
                el.contextInfomationDescription = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("type")) != null) {
                String tname = attr.getNodeValue();
                if (tname.equals("xs:string")) {
                    el.typeDef = this.myStringType;
                } else if (tname.equals("xs:boolean")) {
                    el.typeDef = this.myBooleanType;
                }
            }
        }
        NodeList nodes = node.getChildNodes();
        int j = 0;
        while (j < nodes.getLength()) {
            Node child = nodes.item(j);
            if (child.getNodeType() == 1) {
                this.parse(el, null, child);
            }
            ++j;
        }
        return el;
    }

    public Elem attributeNode(Node node) {
        Elem a = new Elem();
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                a.name = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("description")) != null) {
                a.contextInfomationDescription = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("ref")) != null) {
                a.refName = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("use")) != null) {
                a.use = attr.getNodeValue();
            }
            if ((attr = attrs.getNamedItem("type")) != null) {
                String tname = attr.getNodeValue();
                if (tname.equals("xs:string")) {
                    a.typeDef = this.myStringType;
                } else if (tname.equals("xs:boolean")) {
                    a.typeDef = this.myBooleanType;
                }
            }
        }
        NodeList nodes = node.getChildNodes();
        int j = 0;
        while (j < nodes.getLength()) {
            Node child = nodes.item(j);
            if (child.getNodeType() == 1) {
                this.parse(a, null, child);
            }
            ++j;
        }
        return a;
    }

    public Type typeNode(Elem parent, Node node, String type) {
        Type typ = new Type();
        typ.type = type;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            Node attr = attrs.getNamedItem("name");
            if (attr != null) {
                typ.name = attr.getNodeValue();
            }
            typ.content = (attr = attrs.getNamedItem("content")) != null ? attr.getNodeValue() : "elementOnly";
        }
        return typ;
    }

    public void parseIncludedSchema(Node child) {
        Document incDocObject;
        Node attr;
        NamedNodeMap attrs = child.getAttributes();
        String includefileName = null;
        if (attrs != null && (attr = attrs.getNamedItem("schemaLocation")) != null) {
            includefileName = attr.getNodeValue();
        }
        if ((incDocObject = this.parseIncludeDoc(String.valueOf(this.schemafilePathLocation) + "/" + includefileName)) == null) {
            return;
        }
        this.traverse(incDocObject);
    }

    public Document parseIncludeDoc(String includeFilePath) {
        Document includeDoc = null;
        try {
            includeDoc = super.parseXml((Object)includeFilePath);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (includeDoc == null) {
            return null;
        }
        return includeDoc;
    }

    public Elem parse(Elem parent, Type parentType, Node child) {
        String tag = child.getNodeName();
        if (tag == "xs:include") {
            this.parseIncludedSchema(child);
        } else {
            if (tag == "xs:element") {
                return this.elementNode(child, false);
            }
            if (tag == "xs:group") {
                return this.elementNode(child, true);
            }
            if (tag == "xs:complexType" || tag == "xs:choice" || tag == "xs:simpleContent" || tag == "xs:extension") {
                if (parent.typeDef == null) {
                    parent.typeDef = this.typeNode(parent, child, tag);
                } else if (tag == "xs:complexType") {
                    parent.typeDef = this.typeNode(parent, child, tag);
                } else if (tag == "xs:simpleContent") {
                    parent.typeDef = this.typeNode(parent, child, tag);
                }
                NodeList nodes = child.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    Node n = nodes.item(i);
                    Elem el = this.parse(parent, parent.typeDef, n);
                    if (el != null) {
                        parent.typeDef.elems.add(el);
                    }
                    ++i;
                }
            } else if (tag == "xs:attribute") {
                Elem attr = this.attributeNode(child);
                if (parentType == null) {
                    this.attrs.add(attr);
                } else {
                    parentType.attrs.add(attr);
                }
            } else if (tag == "xs:simpleType") {
                if (parent == null) {
                    return this.elementNode(child, false);
                }
                parent.typeDef = this.typeNode(parent, child, tag);
                NodeList nodes = child.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    Node n = nodes.item(i);
                    this.parse(parent, parentType, n);
                    ++i;
                }
            } else if (tag == "xs:enumeration") {
                Node attr;
                NamedNodeMap attrs = child.getAttributes();
                if (attrs != null && (attr = attrs.getNamedItem("value")) != null) {
                    if (parentType == null) {
                        System.out.println("Null parent type for enumeration " + attr.getNodeValue());
                    } else {
                        parentType.isEnum = true;
                        parentType.values.add(attr.getNodeValue());
                    }
                }
            } else if (tag == "xs:restriction" || tag == "xs:all" || tag == "xs:sequence" || tag == "xs:union") {
                NodeList nodes = child.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    Node n = nodes.item(i);
                    Elem el = this.parse(parent, parent.typeDef, n);
                    if (el != null) {
                        parent.typeDef.elems.add(el);
                    }
                    ++i;
                }
            } else if (tag == "xs:pattern" || tag == "xs:maxLength" || tag == "xs:length" || tag == "xs:minLength") {
                Node attr;
                NamedNodeMap attrs = child.getAttributes();
                if (attrs != null && (attr = attrs.getNamedItem("value")) != null) {
                    if (parentType == null) {
                        parent.properties.put(tag, attr.getNodeValue());
                    } else {
                        parentType.properties.put(tag, attr.getNodeValue());
                    }
                }
            } else if (tag != "#text") {
                if (tag == "#comment") {
                    String s = child.getNodeValue();
                    if (s == null) {
                        return null;
                    }
                    this.xmlComment = s;
                } else {
                    System.out.println("Unrecognized tag: " + tag);
                }
            }
        }
        return null;
    }

    public void resolveReferences(Elem e) {
        if (e.refName != null) {
            e.ref = this.getElementNamed(e.refName);
            if (e.ref == null) {
                System.out.println("Unknown reference '" + e.refName + "' in element '" + e.name + "'");
            } else {
                e.comment = e.ref.comment;
                e.contextInfomationDescription = e.ref.contextInfomationDescription;
            }
        } else if (e.typeDef != null) {
            Type typ = e.typeDef;
            for (Elem el : typ.elems) {
                if (el.refName == null) continue;
                el.ref = this.getElementNamed(el.refName);
                if (el.ref == null) {
                    System.out.println("Unknown reference '" + el.refName + "' in element '" + el.name + "'");
                    continue;
                }
                el.comment = el.ref.comment;
                el.contextInfomationDescription = el.ref.contextInfomationDescription;
            }
            for (Elem at : typ.attrs) {
                if (at.refName == null) continue;
                at.ref = this.getElementNamed(at.refName);
                if (at.ref == null) continue;
                at.comment = at.ref.comment;
                at.contextInfomationDescription = at.ref.contextInfomationDescription;
            }
        }
    }

    public void traverse(Document doc) {
        int i = 0;
        while (i < doc.getChildNodes().getLength()) {
            String tag;
            Node node = doc.getChildNodes().item(i);
            if (node.getNodeType() == 1 && (tag = node.getNodeName()).compareTo("xs:schema") == 0) {
                int j = 0;
                while (j < node.getChildNodes().getLength()) {
                    Node child;
                    Elem el;
                    if (node.getNodeType() == 1 && (el = this.parse(null, null, child = node.getChildNodes().item(j))) != null) {
                        this.symbols.add(el);
                    }
                    ++j;
                }
            }
            ++i;
        }
        for (Elem e : this.symbols) {
            this.resolveReferences(e);
        }
        for (Elem e : this.attrs) {
            this.resolveReferences(e);
        }
    }

    public Elem getElementNamed(String name) {
        for (Elem e : this.symbols) {
            if (!e.name.equals(name)) continue;
            return e;
        }
        for (Elem e : this.attrs) {
            if (!e.name.equals(name)) continue;
            return e;
        }
        return null;
    }

    public Document parseXml(File file) throws SAXException {
        this.schemafilePathLocation = null;
        if (file == null) {
            return null;
        }
        File translated = null;
        try {
            if (!this.isXdsSchemaType(file) && (file = (translated = this.translateToXsd(file))) == null) {
                return null;
            }
            this.schemafilePathLocation = file.getParent();
            this.myDoc = super.parseXml((Object)file);
            if (this.myDoc == null) {
                return null;
            }
            this.traverse(this.myDoc);
        }
        finally {
            if (translated != null) {
                this.cleanupTranslation(file);
            }
        }
        return this.myDoc;
    }

    public Document parseXml(String filename) throws SAXException {
        File file = new File(filename);
        return this.parseXml(file);
    }

    private boolean isXdsSchemaType(File file) {
        String extension = new Path(file.getName()).getFileExtension();
        return "xsd".equalsIgnoreCase(extension);
    }

    private File translateToXsd(File file) throws SAXException {
        String outputType = "xsd";
        if (!file.exists()) {
            System.err.println("Schema file not found " + file.getAbsolutePath());
            return null;
        }
        File output = this.getXsdOutputFile(file);
        if (output == null) {
            System.err.println("Failed to create output file for " + file.getAbsolutePath());
            return null;
        }
        String inputType = this.getSchemaFileType(file);
        InputFormat inputFormat = Formats.createInputFormat((String)inputType);
        if (inputFormat == null) {
            System.err.println("Unrecognized input type: " + inputType);
            return null;
        }
        OutputFormat outputFormat = Formats.createOutputFormat((String)outputType);
        if (outputFormat == null) {
            System.err.println("Unrecognized output type: " + outputType);
            return null;
        }
        ErrorHandlerImpl handler = new ErrorHandlerImpl();
        SchemaCollection s = null;
        try {
            s = inputFormat.load(UriOrFile.toUri((String)file.getCanonicalPath()), new String[0], outputType, (ErrorHandler)handler, null);
            LocalOutputDirectory o = new LocalOutputDirectory(s.getMainUri(), output, outputType, "UTF-8", 80, 3);
            outputFormat.output(s, (OutputDirectory)o, new String[0], inputType.toLowerCase(), (ErrorHandler)handler);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            System.err.println(e.getMessage());
            return null;
        }
        return output;
    }

    private File getXsdOutputFile(File file) {
        Path path = new Path(file.getName());
        File f = null;
        try {
            File d = File.createTempFile("translatedXsd", "");
            d.delete();
            d.mkdir();
            f = new File(d.getAbsoluteFile() + File.separator + path.removeFileExtension() + ".xsd");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }

    private String getSchemaFileType(File file) {
        return new Path(file.getName()).getFileExtension();
    }

    private void cleanupTranslation(File file) {
        File parent = file.getParentFile();
        this.deleteFiles(parent);
    }

    private void deleteFiles(File file) {
        File[] files;
        File[] fileArray = files = file.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.deleteFiles(f);
                f.delete();
            } else {
                f.delete();
            }
            ++n2;
        }
        file.delete();
    }

    public Elem[] getRootElements() {
        return this.symbols.toArray(new Elem[this.symbols.size()]);
    }

    public class Elem {
        public String name;
        public String min;
        public String max;
        public String refName;
        public Elem ref;
        public String use;
        public Type typeDef;
        public String comment;
        public String contextInfomationDescription;
        public String tagType;
        public HashMap<String, String> properties = new HashMap();

        public boolean isOptional() {
            if (this.min == null || this.min.isEmpty()) {
                return false;
            }
            return this.min.equals("0");
        }

        public String getName() {
            String tag = this.name;
            if (tag == null || tag.isEmpty()) {
                tag = this.refName;
            }
            return tag == null ? "" : tag;
        }

        public String getTagType() {
            String tag = this.tagType;
            if (tag == null || tag.isEmpty()) {
                tag = this.refName;
            }
            return tag == null ? "" : tag;
        }

        public String getDescription() {
            String tooltip = this.contextInfomationDescription;
            if (tooltip == null) {
                tooltip = "";
            }
            return tooltip;
        }

        public String getComment() {
            String c = this.comment;
            if ((c == null || c.isEmpty()) && this.ref != null) {
                c = this.ref.comment;
            }
            return c;
        }

        public Type getType() {
            if (this.typeDef != null) {
                return this.typeDef;
            }
            if (this.ref != null) {
                return this.ref.typeDef;
            }
            return null;
        }

        public boolean isString() {
            Type base = this.getType();
            return base == Schema.this.myStringType;
        }

        public boolean isBoolean() {
            Type base = this.getType();
            return base == Schema.this.myBooleanType;
        }

        public boolean isArray() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean isBasicType() {
            return this.isString() || this.isBoolean();
        }

        public boolean isEnum() {
            Type t = this.getType();
            return t != null && t.isEnum;
        }

        public boolean isRequired() {
            return this.use != null && this.use.equals("required");
        }
    }

    public class Type {
        public String name;
        public boolean isString;
        public boolean isBoolean;
        public boolean isEnum;
        public ArrayList<Elem> attrs = new ArrayList();
        public ArrayList<Elem> elems = new ArrayList();
        public ArrayList<String> values = new ArrayList();
        public HashMap<String, String> properties = new HashMap();
        public String type;
        public String content;

        public boolean isSimple() {
            return this.type.equals("xs:simpleType") || this.type.equals("xs:simpleContent");
        }

        public boolean isComplex() {
            return this.type.equals("xs:complexType");
        }

        public boolean isMixedModel() {
            return this.content.equals("mixed");
        }
    }
}

