/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

class ContentOutlineScanner
implements ITreeContentProvider {
    private Element[] rootElements;
    private IDocumentProvider documentProvider;

    public ContentOutlineScanner(IDocumentProvider docProvider) {
        this.documentProvider = docProvider;
    }

    public Element[] getrootElements() {
        return this.rootElements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IDocument document;
        if (newInput != null && this.documentProvider != null && (document = this.documentProvider.getDocument(newInput)) != null) {
            this.parse(document);
        }
    }

    private void parse(IDocument document) {
        ITypedRegion[] region = document.getDocumentPartitioner().computePartitioning(0, document.getLength());
        Element currentElement = null;
        Vector<Element> rootElements = new Vector<Element>();
        int i = 0;
        while (i < region.length) {
            if (region[i].getType().equals("__xml_tag")) {
                try {
                    String tag = document.get(region[i].getOffset() + 1, region[i].getLength());
                    if (tag.charAt(0) == '/') {
                        if (currentElement != null) {
                            currentElement = currentElement.getParent();
                        }
                    } else {
                        boolean closeTag = false;
                        if (tag.contains("/>")) {
                            closeTag = true;
                        }
                        StringTokenizer str = new StringTokenizer(tag, ">");
                        String tagName = str.nextToken();
                        String value = "";
                        while (str.hasMoreTokens()) {
                            value = str.nextToken();
                            if (!value.toUpperCase().contains("TAG") && !value.toUpperCase().contains("USE") && !value.toUpperCase().contains("NAME")) continue;
                            value = value.substring(value.indexOf("\"") + 1, value.lastIndexOf("\""));
                            break;
                        }
                        Element newElement = new Element(tagName);
                        newElement.setValue(value.trim());
                        newElement.setLength(region[i].getLength());
                        newElement.setOffset(region[i].getOffset() + 1);
                        if (currentElement == null) {
                            currentElement = newElement;
                            rootElements.add(currentElement);
                        } else {
                            currentElement.getChildren().add(newElement);
                            newElement.setParent(currentElement);
                            if (!closeTag) {
                                currentElement = newElement;
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else if (region[i].getType().equals("__xml_text")) {
                try {
                    String tagValue = document.get(region[i].getOffset(), region[i].getLength());
                    currentElement.setValue(tagValue);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Object[] tempArray = rootElements.toArray();
        Element[] result = new Element[tempArray.length];
        int i2 = 0;
        while (i2 < tempArray.length) {
            result[i2] = (Element)tempArray[i2];
            ++i2;
        }
        this.rootElements = result;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Element) {
            Element element = (Element)parentElement;
            return element.getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof Element) {
            Element tempElement = (Element)element;
            return tempElement.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Element) {
            Element tempElement = (Element)element;
            return !tempElement.getChildren().isEmpty();
        }
        return false;
    }

    public Element[] getElements(Object inputElement) {
        return this.rootElements;
    }

    public class Element {
        private String name;
        private Element parent;
        private Vector children = new Vector();
        private int offset;
        private int length;
        private String value;

        public Element(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public Vector getChildren() {
            return this.children;
        }

        public String toString() {
            if (!this.value.isEmpty()) {
                return String.valueOf(this.name) + " : " + this.value;
            }
            return this.name;
        }

        public Element getParent() {
            return this.parent;
        }

        public void setParent(Element parent) {
            this.parent = parent;
        }
    }
}

