/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import com.vmware.vide.vxmleditor.editors.ColorManager;
import com.vmware.vide.vxmleditor.editors.MarkingErrorHandler;
import com.vmware.vide.vxmleditor.editors.XMLConfiguration;
import com.vmware.vide.vxmleditor.editors.XMLDocumentProvider;
import com.vmware.vide.vxmleditor.editors.XSDErrorHandler;
import com.vmware.vide.vxmleditor.editors.XmlContentOutlinePage;
import com.vmware.vide.vxmleditor.editors.myEntityResolver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.SAXException;

public class XMLEditor
extends TextEditor {
    private ColorManager colorManager;
    public DocumentBuilder parser;
    public Validator validator;
    public XmlContentOutlinePage outlinePage;
    private long counter;
    public String xdsfile = "/opt/vmware/VTAF/Framework/Common/VTAF.xsd";
    private XMLConfiguration xmlConfig;
    public static final String EDITOR_CONTEXT = "com.vmware.vide.vxmleditor.context";
    public static final String RULER_CONTEXT = "com.vmware.vide.vxmleditor.context.ruler";

    public XMLEditor() {
        this.colorManager = new ColorManager();
        this.xmlConfig = new XMLConfiguration(this.colorManager);
        this.xmlConfig.setXSDFile(this.getXSDFile());
        this.setSourceViewerConfiguration(this.xmlConfig);
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
        this.counter = System.currentTimeMillis();
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public XMLEditor(String xsdPath) {
        this.setXSDFile(xsdPath);
        this.colorManager = new ColorManager();
        this.xmlConfig = new XMLConfiguration(this.colorManager);
        this.xmlConfig.setXSDFile(this.getXSDFile());
        this.setSourceViewerConfiguration(this.xmlConfig);
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
        this.initiateXSDSchemas();
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.counter = System.currentTimeMillis();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        this.validateAndMark();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    public ISourceViewer getEditorSourceViewer() {
        return this.getSourceViewer();
    }

    protected void createActions() {
        super.createActions();
        this.getSourceViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                long currentime = System.currentTimeMillis();
                if (currentime - XMLEditor.this.counter > 3000L) {
                    XMLEditor.this.validateAndMark();
                    XMLEditor.this.counter = currentime;
                }
            }
        });
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        IResource ires = (IResource)input.getAdapter(IResource.class);
        if (ires == null || !ires.exists()) {
            return;
        }
        String XMLContent = this.readFileContent(ires.getLocation().toOSString());
        if (this.parser == null) {
            return;
        }
        MarkingErrorHandler myErrorHandler = new MarkingErrorHandler(ires, XMLContent);
        String originalPath = System.getProperty("user.dir");
        try {
            try {
                String newpath = ires.getLocation().toFile().getParent();
                System.setProperty("user.dir", newpath);
                this.parser.setErrorHandler(myErrorHandler);
                this.parser.setEntityResolver(new myEntityResolver());
                Document document = this.parser.parse(new ByteArrayInputStream(XMLContent.getBytes()));
                DocumentType doctype = document.getDoctype();
                if (doctype != null) {
                    File dtdPath = new File(System.getProperty("user.dir"), doctype.getSystemId());
                    this.setXSDFile(dtdPath.getAbsolutePath());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.setProperty("user.dir", originalPath);
            }
        }
        finally {
            System.setProperty("user.dir", originalPath);
        }
    }

    public void initiateXSDSchemas() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            XSDErrorHandler xsderrorHandler = new XSDErrorHandler();
            schemaFactory.setErrorHandler(xsderrorHandler);
            Schema schemaXSD = schemaFactory.newSchema(new File(this.getXSDFile()));
            this.validator = schemaXSD.newValidator();
        }
        catch (Exception exception) {}
    }

    protected void validateAndMark() {
        IResource fName = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (fName == null) {
            return;
        }
        ISourceViewer sv = this.getSourceViewer();
        if (sv == null) {
            return;
        }
        IDocument dv = sv.getDocument();
        if (dv == null) {
            return;
        }
        if (this.parser == null) {
            return;
        }
        String s = dv.get();
        MarkingErrorHandler myErrorHandler = new MarkingErrorHandler(fName, s);
        int depth = 2;
        try {
            fName.deleteMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        String originalPath = System.getProperty("user.dir");
        try {
            try {
                String newpath = fName.getLocation().toFile().getParent();
                System.setProperty("user.dir", newpath);
                this.parser.setErrorHandler(myErrorHandler);
                this.parser.setEntityResolver(new myEntityResolver());
                Document document = this.parser.parse(new ByteArrayInputStream(s.getBytes()));
                DocumentType doctype = document.getDoctype();
                if (doctype != null) {
                    File dtdPath = new File(System.getProperty("user.dir"), doctype.getSystemId());
                    this.setXSDFile(dtdPath.getAbsolutePath());
                }
                if (this.validator != null) {
                    this.validator.validate(new DOMSource(document));
                }
            }
            catch (SAXException sAXException) {
                System.setProperty("user.dir", originalPath);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.setProperty("user.dir", originalPath);
            }
        }
        finally {
            System.setProperty("user.dir", originalPath);
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.outlinePage == null) {
                this.outlinePage = new XmlContentOutlinePage(this.getDocumentProvider(), this);
                if (this.getEditorInput() != null) {
                    this.outlinePage.setInput(this.getEditorInput());
                }
            }
            return this.outlinePage;
        }
        return super.getAdapter(required);
    }

    public String getXSDFile() {
        if (this.xdsfile != null && new File(this.xdsfile).exists()) {
            return this.xdsfile;
        }
        return null;
    }

    public void setXSDFile(String filename) {
        if (filename != null && !this.xdsfile.equals(filename)) {
            this.xdsfile = filename;
            this.initiateXSDSchemas();
        }
        if (this.xmlConfig != null && !filename.equals(this.xmlConfig.getXSDFile())) {
            this.xmlConfig.setXSDFile(this.getXSDFile());
        }
    }

    public String readFileContent(String path) {
        StringBuilder page = new StringBuilder();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                page.append(strLine);
                page.append("\n");
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return page.toString();
    }
}

