/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XMLTextRule
implements IPredicateRule {
    private final IToken token;
    private int charsRead;
    private boolean whiteSpace;
    boolean isCdata;

    public XMLTextRule(IToken text) {
        this.token = text;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        this.reinit();
        int c = 0;
        while (this.isOK(c = this.read(scanner), scanner)) {
            if (c == -1) {
                return Token.UNDEFINED;
            }
            boolean bl = this.whiteSpace = this.whiteSpace && Character.isWhitespace((char)c);
        }
        this.unread(scanner);
        if (this.whiteSpace) {
            this.rewind(scanner, this.charsRead);
            return Token.UNDEFINED;
        }
        return this.token;
    }

    private boolean isOK(int cc, ICharacterScanner scanner) {
        char c = (char)cc;
        if (!this.isCdata) {
            if (c == '<') {
                int cdataCharsRead = 0;
                int i = 0;
                while (i < "![CDATA[".length()) {
                    c = (char)this.read(scanner);
                    ++cdataCharsRead;
                    if (c != "![CDATA[".charAt(i)) {
                        this.rewind(scanner, cdataCharsRead);
                        this.isCdata = false;
                        return false;
                    }
                    ++i;
                }
                this.isCdata = true;
                return true;
            }
        } else if (c == ']') {
            int i = 0;
            while (i < "]>".length()) {
                c = (char)this.read(scanner);
                if (c != "]>".charAt(i)) {
                    return true;
                }
                ++i;
            }
            this.isCdata = false;
            return true;
        }
        return true;
    }

    private void unread(ICharacterScanner scanner) {
        scanner.unread();
        --this.charsRead;
    }

    private int read(ICharacterScanner scanner) {
        int c = scanner.read();
        ++this.charsRead;
        return c;
    }

    private void reinit() {
        this.charsRead = 0;
        this.whiteSpace = true;
    }

    private void rewind(ICharacterScanner scanner, int theCharsRead) {
        while (theCharsRead > 0) {
            --theCharsRead;
            this.unread(scanner);
        }
    }
}

