/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.editors;

import com.vmware.vide.vxmleditor.editors.ContentOutlineScanner;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class XmlContentOutlinePage
extends ContentOutlinePage {
    private TreeViewer viewer;
    private IDocumentProvider documentProvider;
    private TextEditor editorPart;

    public XmlContentOutlinePage(IDocumentProvider documentProvider, TextEditor editorPart) {
        this.documentProvider = documentProvider;
        this.editorPart = editorPart;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        if (this.viewer != null) {
            this.viewer.setContentProvider((IContentProvider)new ContentOutlineScanner(this.documentProvider));
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.editorPart != null) {
                this.viewer.setInput((Object)this.editorPart.getEditorInput());
                this.viewer.expandAll();
            }
        }
    }

    public void setInput(IEditorInput editorInput) {
        if (this.viewer != null) {
            this.viewer.setInput((Object)editorInput);
        }
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput((Object)this.editorPart.getEditorInput());
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public Object getElement(String segmentName, Object[] structElement) {
        int i = 0;
        while (i < structElement.length) {
            ContentOutlineScanner.Element tagName = (ContentOutlineScanner.Element)structElement[i];
            if (tagName.toString().equalsIgnoreCase(segmentName)) {
                return structElement[i];
            }
            ++i;
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editorPart.resetHighlightRange();
        } else {
            TreeSelection sel = (TreeSelection)selection;
            TreePath[] s = sel.getPaths();
            Object[] StrucElements = ((ContentOutlineScanner)this.viewer.getContentProvider()).getrootElements();
            ContentOutlineScanner.Element myElement = null;
            int i = 0;
            while (i < s[0].getSegmentCount()) {
                myElement = (ContentOutlineScanner.Element)this.getElement(s[0].getSegment(i).toString(), StrucElements);
                if (myElement != null && (StrucElements = ((ContentOutlineScanner)this.viewer.getContentProvider()).getChildren(myElement)) == null) {
                    System.out.println("No children found");
                    break;
                }
                ++i;
            }
            if (myElement == null) {
                this.editorPart.resetHighlightRange();
                return;
            }
            try {
                this.editorPart.setHighlightRange(myElement.getOffset(), myElement.getLength(), true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.editorPart.resetHighlightRange();
            }
        }
    }
}

