/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vxmleditor.multipageeditor;

import com.vmware.vide.vxmleditor.editors.XMLEditor;
import com.vmware.vide.vxmleditor.model.XMLDataModel;
import com.vmware.vide.vxmleditor.multipageeditor.XMLDesignPage;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class XMLPageEditor
extends FormEditor {
    private static final String TITLE_EDITOR = "XML Editor";
    private static final String TITLE_TEXTEDITOR = "Source";
    XMLDataModel datamodel;
    XMLEditor textpage;
    XMLDesignPage designpage;
    int texteditorindex;
    int designeditorindex;
    public String filePath;
    boolean isinitializepage = false;

    protected abstract File getXSDFile(IEditorInput var1);

    public XMLPageEditor() {
        File xsdfile = this.getXSDFile(this.getEditorInput());
        this.textpage = new XMLEditor(xsdfile != null ? xsdfile.getAbsolutePath() : null);
        this.designpage = new XMLDesignPage(this, this.getTabTitle(), this.getPageTitle(), this.getXMLTreeBlockTitle(), this.getXMLTreeBlockDescription(), this.getXMLDatailsBlockTitle(), this.getXMLNodeDescriptions());
        this.datamodel = new XMLDataModel(xsdfile);
        this.datamodel.addModelListener(this.designpage.getModelListener());
    }

    public XMLDataModel getDataModel() {
        return this.datamodel;
    }

    protected String getEditorTitle() {
        return TITLE_EDITOR;
    }

    protected String getTabTitle() {
        return "Design";
    }

    protected String getPageTitle() {
        return "XML Design Page";
    }

    protected String getXMLTreeBlockTitle() {
        return "XML Objects";
    }

    protected String getXMLTreeBlockDescription() {
        return "The tree contains objects from the model whose details are editable on the right";
    }

    protected String getXMLDatailsBlockTitle() {
        return null;
    }

    protected Map<String, String> getXMLNodeDescriptions() {
        return null;
    }

    public String getFileName() {
        return this.filePath;
    }

    protected void addPages() {
        try {
            this.designeditorindex = this.addPage((IFormPage)this.designpage);
            this.texteditorindex = this.addPage((IEditorPart)this.textpage, this.getEditorInput());
            File file = XMLDataModel.getFile(this.getEditorInput());
            this.filePath = file.getAbsolutePath();
            this.setPageText(this.texteditorindex, file != null ? file.getName() : TITLE_TEXTEDITOR);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)this.getEditorTitle(), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        try {
            super.init(site, input);
            File file = XMLDataModel.getFile(input);
            this.setPartName(file.getName());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.datamodel.setInput(this.textpage, input, this.getXSDFile(input));
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() == this.designeditorindex) {
            this.datamodel.doSave();
        }
        if (this.textpage != null) {
            this.textpage.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.getActivePage() == this.designeditorindex) {
            this.datamodel.doSave();
        }
        if (this.textpage != null) {
            this.textpage.doSaveAs();
        }
        this.datamodel.setInput(this.textpage, this.getEditorInput(), this.getXSDFile(this.getEditorInput()));
    }

    public Object getAdapter(Class key) {
        if (this.textpage != null) {
            return this.textpage.getAdapter(key);
        }
        return super.getAdapter(key);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void pageChange(int newpageindex) {
        if (!this.isinitializepage) {
            this.datamodel.setInput(this.textpage, this.getEditorInput(), this.getXSDFile(this.getEditorInput()));
            this.datamodel.updateBaseDocuemnt();
            this.designpage.refresh();
            this.isinitializepage = true;
        }
        if (newpageindex == this.texteditorindex) {
            if (this.designpage.isDirty() || this.datamodel.isDataChanged()) {
                this.datamodel.updateBaseDocuemnt();
            }
        } else if (newpageindex == this.designeditorindex && this.textpage.isDirty()) {
            this.datamodel.setInput(this.textpage, this.getEditorInput(), this.getXSDFile(this.getEditorInput()));
        }
        super.pageChange(newpageindex);
    }

    public void firePropertyChange() {
        this.firePropertyChange(257);
    }
}

