/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.init;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ConfigUtil {
    public static String lookupString(Object storage, String id) {
        try {
            if (storage instanceof Map) {
                Object value;
                Map map = (Map)storage;
                if (storage != null && map.containsKey(id) && (value = map.get(id)) instanceof String) {
                    return (String)value;
                }
            } else if (storage instanceof ArrayList) {
                ArrayList array = (ArrayList)storage;
                int i = 0;
                while (i < array.size()) {
                    String value = ConfigUtil.lookupString(array.get(i), id);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            } else if (storage instanceof String) {
                return (String)storage;
            }
        }
        catch (Exception exception) {
            System.err.println("unable to find a string value for " + id);
        }
        return null;
    }

    public static boolean lookupBoolean(Object storage, String id, String expectedvalue, boolean casesensitive) {
        String value = ConfigUtil.lookupString(storage, id);
        if (value == null) {
            return false;
        }
        return casesensitive && value.equals(expectedvalue) || !casesensitive && value.equalsIgnoreCase(expectedvalue.toLowerCase());
    }

    public static ArrayList<Object> lookupList(Object storage, String id) {
        ArrayList<Object> info = new ArrayList<Object>();
        try {
            if (storage instanceof Map) {
                Map map = (Map)storage;
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    if (!((String)it.next()).equals(id)) continue;
                    info.add(map.get(id));
                }
            } else if (storage instanceof ArrayList) {
                ArrayList array = (ArrayList)storage;
                int i = 0;
                while (i < array.size()) {
                    ArrayList<Object> found = ConfigUtil.lookupList(array.get(i), id);
                    if (found != null && found.size() > 0) {
                        info.addAll(found);
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("unable to find a string value for " + id);
        }
        return info;
    }
}

