/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.init;

import com.vmware.vide.init.IConfigChangeListener;
import com.vmware.vide.init.vIDEConfigInfo;
import com.vmware.vide.utils.local.VMWBConfig;
import com.vmware.vide.utils.symbol.Variable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InitPlugin
extends AbstractUIPlugin {
    private static final String EMPTY_STR = "";
    public static final String PLUGIN_ID = "com.vmware.vide.init";
    public static final String INFO_TITLE = "title";
    public static final String INFO_NAME = "name";
    public static final String INFO_VERSION = "version";
    public static final String INFO_TYPE = "type";
    public static final String INFO_DESCRIPTION = "description";
    public static final String INFO_PROJECTIDENTITY = "projectidentity";
    private static BundleContext bundleContext;
    public static final boolean TestModeOn = false;
    private static InitPlugin plugin;
    private static vIDEConfigInfo cfginfo;
    private String initPluginVersionMMM = null;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        super.start(context);
        plugin = this;
        cfginfo = new vIDEConfigInfo();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    public static InitPlugin getDefault() {
        return plugin;
    }

    public String getInitPluginVersionStringMMM() {
        if (this.initPluginVersionMMM == null) {
            Version v = this.getBundle().getVersion();
            this.initPluginVersionMMM = String.format("%d.%d.%d", v.getMajor(), v.getMinor(), v.getMicro());
        }
        return this.initPluginVersionMMM;
    }

    public vIDEConfigInfo getConfigInfo() {
        return cfginfo;
    }

    public void refreshAll() {
        cfginfo.refreshAll();
    }

    public String[] getKitIds() {
        return cfginfo.getKitIds();
    }

    public Map<String, String> getKitInfo(String kitid) {
        return cfginfo.getKitInfo(kitid);
    }

    public Map<String, File> getConfigFiles() {
        return cfginfo.getConfigFiles();
    }

    public File getConfigFile(String kitid) {
        Map<String, File> cfgfiles = this.getConfigFiles();
        if (cfgfiles.containsKey(kitid)) {
            return cfgfiles.get(kitid);
        }
        return null;
    }

    public String[] getKitIdsMatching(String keypath, String expectedvalue, boolean casesensitive) {
        return cfginfo.getKitIdsMatching(keypath, expectedvalue, casesensitive);
    }

    public String getFirstConfigValue(String kitid, String keypath) {
        return cfginfo.getFirstConfigValue(kitid, keypath);
    }

    public boolean isFirstConfigValue(String kitid, String keypath, String value, boolean casesensitive) {
        return cfginfo.isFirstConfigValue(kitid, keypath, value, casesensitive);
    }

    public Map<String, String> getConfigValueFromKeys(String kitid, String[] keypaths) {
        return cfginfo.getFirstConfigValueFromKeys(kitid, keypaths);
    }

    public int getConfigCount(String kitid, String keypath) {
        return cfginfo.getConfigCount(kitid, keypath);
    }

    public String getConfigValueByIndex(String kitid, String parentkeypath, String nodename, int index) {
        return cfginfo.getConfigValueByIndex(kitid, parentkeypath, nodename, index);
    }

    public Map<String, String> getChildrenNodeValuesByIndex(String kitid, String parentkeypath, int index) {
        return cfginfo.getChildrenNodeValuesByIndex(kitid, parentkeypath, index);
    }

    public Map<String, String> getAttributes(String kitid, String keypath) {
        return cfginfo.getAttributes(kitid, keypath);
    }

    public Node[] getConfigNode(String kitid, String keypath) {
        return cfginfo.getConfigNode(kitid, keypath);
    }

    public Document getConfigDocument(String kitid) {
        return cfginfo.getConfigDocument(kitid);
    }

    @Deprecated
    public Map<String, String> getProjectNatureInfo(String kitid, String projnatureid) {
        return cfginfo.getProjectNatureInfo(kitid, projnatureid);
    }

    public ArrayList<Map<String, String>> getProjectNatureOptions(String kitid, String projnatureid) {
        return cfginfo.getProjectNatureOptions(kitid, projnatureid);
    }

    public List<Map<String, String>> getProjectNaturePaths(String kitid, String projnatureid) {
        return cfginfo.getProjectNaturePaths(kitid, projnatureid);
    }

    public Map<String, String> getSystemOptions(String kitid) {
        return cfginfo.getSystemOptions(kitid);
    }

    public String getInstalledDevkitBuildNo(String kitid) {
        return cfginfo.getInstalledDevkitBuildNo(kitid);
    }

    public String getInstalledDevkitVersion(String kitid) {
        return cfginfo.getInstalledDevkitVersion(kitid);
    }

    public ArrayList<Map<String, Object>> getAllNodeValues(String kitid, String keypath) {
        return cfginfo.getAllNodeValues(kitid, keypath);
    }

    public void addEventListener(IConfigChangeListener listener) {
        cfginfo.addEventListener(listener);
    }

    public void removeEventListener(IConfigChangeListener listener) {
        cfginfo.removeEventListener(listener);
    }

    public String getRootInstallPath(String kitId) {
        String path = cfginfo.getFirstConfigValue(kitId, "system.rootinstallpath");
        if (path == null) {
            return EMPTY_STR;
        }
        String installDir = VMWBConfig.getInstallDir();
        if (installDir != null) {
            HashMap<String, String> hostVars = new HashMap<String, String>();
            hostVars.put("INSTALL_DIR", installDir);
            hostVars.put("WORKBENCH_INSTALLED_PATH", installDir);
            path = Variable.replaceVariables((String)path, hostVars);
        }
        return Variable.replaceVariables((String)path, cfginfo.getSystemOptions(kitId));
    }

    private void testInitPlugin() {
        String defaultkitid = "ddk";
        String[] kitids = cfginfo.getKitIds();
        System.out.println("[getId] " + Integer.toString(kitids.length) + " kit(s) found");
        int i = 0;
        while (i < kitids.length) {
            System.out.println("Kit Id:" + kitids[i]);
            ++i;
        }
        Map<String, File> files = this.getConfigFiles();
        System.out.println("[getConfigFiles] " + Integer.toString(files.size()) + " configuration file(s) found");
        for (String keypath : files.keySet()) {
            System.out.println(String.valueOf(keypath) + ":" + files.get(keypath).getAbsolutePath());
        }
        String testkeypath = "codechecker.enabled";
        String value = "true";
        kitids = this.getKitIdsMatching(testkeypath, value, false);
        System.out.println("[getValidKitIds] keypath :" + testkeypath + ", value=" + value + " :" + Integer.toString(kitids.length) + " matched kitid(s) found");
        testkeypath = "codechecker.disabled";
        kitids = this.getKitIdsMatching(testkeypath, value, false);
        System.out.println("[getValidKitIds] keypath :" + testkeypath + ", value=" + value + " :" + Integer.toString(kitids.length) + " matched kitid(s) found  (invalid keypath)");
        String[] testkeypaths = new String[]{"common.type", "system.rootinstallpath", "codechecker.togglemenu", "codechecker.vmwarecodechecker.execute.codecheckerpath", "wizard.importwizard.initdir"};
        int i2 = 0;
        while (i2 < testkeypaths.length) {
            value = this.getFirstConfigValue(defaultkitid, testkeypaths[i2]);
            System.out.println("[getFirstConfigValue] kitid:" + defaultkitid + " keypath :" + testkeypaths[i2] + "=" + (value == null ? "null" : value));
            ++i2;
        }
        String[] othertestkeypaths = new String[]{"codechecker.togglemenu", "codechecker.execmenu", "codechecker.ccview", "codechecker.invalidkey"};
        Map<String, String> values = this.getConfigValueFromKeys(defaultkitid, othertestkeypaths);
        String input = "[getConfigValueFromKeys] input :";
        int i3 = 0;
        while (i3 < othertestkeypaths.length) {
            input = input.concat(String.valueOf(othertestkeypaths[i3]) + ",");
            ++i3;
        }
        System.out.println(input);
        System.out.println("[getConfigValueFromKeys] " + Integer.toString(values.size()) + " value(s) found (invalid keypath)");
        for (String keypath : values.keySet()) {
            System.out.println(String.valueOf(keypath) + "=" + values.get(keypath));
        }
        testkeypath = "builder.makefile.buildtarget.menu";
        values = this.getAttributes(defaultkitid, testkeypath);
        System.out.println("[getAttributes] keypath :" + testkeypath + ", " + Integer.toString(values.size()) + " attribute(s) found");
        for (String keypath : values.keySet()) {
            System.out.println(String.valueOf(keypath) + "=" + values.get(keypath));
        }
        String natureid = "com.vmware.vide.core.ddknature";
        Map<String, String> natureinfo = this.getProjectNatureInfo(defaultkitid, natureid);
        System.out.println("[getProjectNatureInfo] natureid :" + natureid);
        for (String key : natureinfo.keySet()) {
            System.out.println(String.valueOf(key) + "=" + natureinfo.get(key));
        }
        testkeypath = "wizard.importwizard.importcategory";
        int count = this.getConfigCount(defaultkitid, testkeypath);
        System.out.println("[getConfigCount] " + testkeypath + ":" + Integer.toString(count));
        int i4 = 0;
        while (i4 < count) {
            values = this.getChildrenNodeValuesByIndex(defaultkitid, testkeypath, i4);
            System.out.println("Index : " + Integer.toString(i4));
            for (String keypath : values.keySet()) {
                System.out.println(String.valueOf(keypath) + "=" + values.get(keypath));
            }
            ++i4;
        }
    }
}

