/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.wbis;

import com.vmware.vide.wbis.Activator;
import com.vmware.vide.wbis.ExtensionManager;
import com.vmware.vide.wbis.ImageUtil;
import com.vmware.vide.wbis.VMwareViewDescription;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class VMwareViewsContributionItem
extends ContributionItem {
    ILog logger = Activator.getDefault().getLog();

    public VMwareViewsContributionItem() {
    }

    public VMwareViewsContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        MenuItem item = new MenuItem(menu, 64, index);
        item.setText("Views");
        Menu m = new Menu(menu);
        item.setMenu(m);
        this.createSubMenuItems(m);
    }

    void createSubMenuItems(Menu menu) {
        List<VMwareViewDescription> views = ExtensionManager.INSTANCE.getVMwareViews();
        for (final VMwareViewDescription desc : views) {
            final MenuItem item = new MenuItem(menu, 0);
            item.setText(desc.getName());
            item.setImage(ImageUtil.createMenuIconImage(desc.getImageDescriptor()));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
                    try {
                        page.showView(desc.getId());
                    }
                    catch (PartInitException e) {
                        VMwareViewsContributionItem.this.logger.log((IStatus)new Status(4, "com.vmware.vide.wbis", null, (Throwable)e));
                    }
                }
            });
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    item.getImage().dispose();
                }
            });
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

