/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.cifs;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.services.files.cifs.ICIFSService;
import org.eclipse.rse.internal.subsystems.files.cifs.connectorservice.CIFSConnectorService;
import org.eclipse.rse.internal.subsystems.files.cifs.connectorservice.CIFSConnectorServiceManager;
import org.eclipse.rse.internal.subsystems.files.cifs.model.CIFSFileAdapter;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class CIFSSubSystemConfiguration
extends FileServiceSubSystemConfiguration {
    IHostFileToRemoteFileAdapter hostFileAdapter;

    public CIFSSubSystemConfiguration() {
        this.setIsUnixStyle(true);
    }

    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = FileServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        CIFSConnectorService connectorService = (CIFSConnectorService)this.getConnectorService(host);
        FileServiceSubSystem subsys = new FileServiceSubSystem(host, (IConnectorService)connectorService, this.getFileService(host), this.getHostFileAdapter(), this.getSearchService(host));
        return subsys;
    }

    public IFileService createFileService(IHost host) {
        CIFSConnectorService connSvc = (CIFSConnectorService)this.getConnectorService(host);
        return connSvc.getFileService();
    }

    public IHostFileToRemoteFileAdapter getHostFileAdapter() {
        if (this.hostFileAdapter == null) {
            this.hostFileAdapter = new CIFSFileAdapter();
        }
        return this.hostFileAdapter;
    }

    public ISearchService createSearchService(IHost host) {
        return null;
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHost host, IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        return null;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory(IRemoteFileSubSystem ss) {
        return null;
    }

    public boolean supportsArchiveManagement() {
        return false;
    }

    public IConnectorService getConnectorService(IHost host) {
        return CIFSConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        CIFSConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public Class<ICIFSService> getServiceImplType() {
        return ICIFSService.class;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsSearch() {
        return false;
    }

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }
}

