/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils;

public class CommandLineUtil {
    public static String makeCommandLineArgument(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (s.isEmpty()) {
            return s;
        }
        if (s.startsWith("\"") && s.length() > 1 && s.endsWith("\"")) {
            return s;
        }
        if (s.startsWith("'") && s.length() > 1 && s.endsWith("'")) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < s.length()) {
            char c = s.charAt(index);
            if (c == '\\') {
                if (index + 1 < s.length()) {
                    sb.append(s.subSequence(index, index + 2));
                    index += 2;
                } else {
                    sb.append("\\\\");
                    break;
                }
            }
            if (c == '\"' || c == '\'' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
            ++index;
        }
        return sb.toString();
    }
}

