/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.local;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileHelper {
    public static boolean copyFile(File srcfile, String destpath, boolean overwrite) throws Exception {
        if (srcfile == null || !srcfile.exists() || destpath == null) {
            return false;
        }
        if (new File(destpath).isDirectory()) {
            destpath = String.valueOf(destpath) + File.separator + srcfile.getName();
        }
        File destfile = new File(destpath);
        if (!overwrite && destfile.exists()) {
            return true;
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(srcfile);
            out = new FileOutputStream(destfile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            return true;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String childName = stringArray[n2];
                if (!FileHelper.deleteDir(new File(dir, childName))) {
                    return false;
                }
                ++n2;
            }
        }
        return dir.delete();
    }

    public static boolean copyDirectory(File sourceFile, File destinationFile) throws Exception {
        if (sourceFile == null || !sourceFile.exists() || destinationFile == null) {
            return false;
        }
        if (sourceFile.isDirectory()) {
            String[] children;
            if (!destinationFile.exists()) {
                destinationFile.mkdirs();
            }
            String[] stringArray = children = sourceFile.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                FileHelper.copyDirectory(new File(sourceFile.getAbsolutePath(), child), new File(destinationFile.getAbsolutePath(), child));
                ++n2;
            }
        } else {
            FileHelper.copyFile(sourceFile, destinationFile.getAbsolutePath(), true);
        }
        return true;
    }

    public static void getListOfFilesinDirectory(File dir, List<String> filesList) throws IOException {
        File[] fileNames;
        File[] fileArray = fileNames = dir.listFiles();
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileHelper.getListOfFilesinDirectory(file, filesList);
            } else {
                filesList.add(file.getCanonicalPath());
            }
            ++n2;
        }
    }

    public static boolean createZIPArchive(String directory, String targetFile) throws IOException {
        targetFile = targetFile.endsWith(".zip") ? targetFile : String.valueOf(targetFile) + ".zip";
        File dir = new File(directory);
        ArrayList<String> filesList = new ArrayList<String>();
        FileHelper.getListOfFilesinDirectory(dir, filesList);
        try (ZipOutputStream zipout = new ZipOutputStream((OutputStream)new FileOutputStream(targetFile));){
            byte[] buf = new byte[1024];
            for (String fileName : filesList) {
                int len;
                FileInputStream in = new FileInputStream(fileName);
                fileName = fileName.replace(dir.getParent(), ".");
                fileName = fileName.replace("\\", "/");
                zipout.putNextEntry(new ZipEntry(fileName));
                while ((len = in.read(buf)) > 0) {
                    zipout.write(buf, 0, len);
                }
                zipout.closeEntry();
                in.close();
            }
        }
        return true;
    }

    public static boolean getListOfFilesinDirectory(File dir, List<String> filesList, FilenameFilter filter) throws IOException {
        File[] directories;
        String[] filteredFiles;
        if (filter == null) {
            FileHelper.getListOfFilesinDirectory(dir, filesList);
            return true;
        }
        String[] stringArray = filteredFiles = dir.list(filter);
        int n = filteredFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String files = stringArray[n2];
            filesList.add(files);
            ++n2;
        }
        File[] fileArray = directories = dir.listFiles();
        int n3 = directories.length;
        n = 0;
        while (n < n3) {
            File directory = fileArray[n];
            if (directory.isDirectory()) {
                FileHelper.getListOfFilesinDirectory(directory, filesList, filter);
            }
            ++n;
        }
        return true;
    }

    public static List<String> findFiles(String directory, String regExpression) throws IOException {
        RegExFileFilter searchExtensionFilter = new RegExFileFilter(regExpression);
        ArrayList<String> myFiles = new ArrayList<String>();
        FileHelper.getListOfFilesinDirectory(new File(directory), myFiles, searchExtensionFilter);
        return myFiles;
    }

    public static boolean findAndDeleteFile(String directory, String regExpression) throws IOException {
        List<String> files = FileHelper.findFiles(directory, regExpression);
        for (String file : files) {
            if (new File(String.valueOf(directory) + File.separator + file).delete()) continue;
            return false;
        }
        return true;
    }

    public static File saveToTempFile(String name, String ext, List<String> lines) throws IOException {
        File destFile = null;
        BufferedWriter writer = null;
        try {
            destFile = File.createTempFile(name, ext, null);
            destFile.deleteOnExit();
            FileWriter fileWriter = new FileWriter(destFile);
            writer = new BufferedWriter(fileWriter);
            for (String s : lines) {
                writer.write(s);
                writer.write("\n");
            }
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception exception) {}
        return destFile;
    }

    public static String findFileNamePatternLocation(File topDir, String[] fileNamePatterns) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = fileNamePatterns;
        int n = fileNamePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            patterns.add(Pattern.compile(pattern));
            ++n2;
        }
        LinkedList<File> files = new LinkedList<File>();
        files.add(topDir);
        while (!files.isEmpty()) {
            File[] fs;
            File file = (File)files.poll();
            for (Pattern p : patterns) {
                if (!p.matcher(file.getName()).matches()) continue;
                Path topPath = new Path(topDir.getAbsolutePath());
                Path path = new Path(file.getParentFile().getAbsolutePath());
                return path.makeRelativeTo((IPath)topPath).toOSString();
            }
            if (!file.isDirectory()) continue;
            File[] fileArray = fs = file.listFiles();
            int n3 = fs.length;
            int n4 = 0;
            while (n4 < n3) {
                File f = fileArray[n4];
                files.add(f);
                ++n4;
            }
        }
        return null;
    }

    private static class RegExFileFilter
    implements FilenameFilter {
        Pattern p;

        public RegExFileFilter(String regEx) {
            this.p = Pattern.compile(regEx);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.p.matcher(name).matches();
        }
    }
}

