/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.net;

import com.vmware.vide.utils.local.HostCommandRunner;
import com.vmware.vide.utils.net.HttpLogCounter;
import com.vmware.vide.utils.net.NetUtils;
import com.vmware.vide.utils.net.NetworkHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class HttpLogger {
    private static final String VMWB_ENG_HOST = "vmwb.eng.vmware.com";
    private static final String VMWB_ENG_URL = String.format("http://%s/workbench/", "vmwb.eng.vmware.com");
    private static final String PART_WEB_URL = "http://partnerweb.vmware.com/workbench/";
    public static final long LOGGER_INTERVAL = 21600000L;
    public static final String VMWB4ENG_ACTIVITY = "vmwb4eng";
    private static boolean _isVMware;
    private static Map<String, HttpLogCounter> logActivities;
    private static volatile boolean isActivityLoggingEnabled;
    private static volatile String username;
    private static final String BEACON_FILE_SEPARATOR = "\t";
    private static String anonymousId;
    private static String javaDetails;
    private static String osDetails;
    private static final String command = "lsb_release -a";

    static {
        logActivities = new HashMap<String, HttpLogCounter>();
        anonymousId = null;
        javaDetails = null;
        osDetails = null;
        isActivityLoggingEnabled = true;
        _isVMware = false;
        String javaVersion = System.getProperty("java.version");
        String jvmName = System.getProperty("java.vm.name");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = Platform.getOSArch();
        try {
            if (javaVersion != null && jvmName != null) {
                javaDetails = "&javaVersion=" + URLEncoder.encode(String.valueOf(javaVersion) + " " + jvmName, "UTF-8");
            }
            if (osName != null && osVersion != null) {
                HostCommandRunner cmd;
                int result;
                if (osName.toLowerCase().startsWith("linux") && (result = (cmd = new HostCommandRunner()).runCommand(command)) == 0) {
                    List<String> output = cmd.getStdOutLines();
                    for (String line : output) {
                        if (line.startsWith("Distributor ID")) {
                            osName = line.substring(line.lastIndexOf(":") + 1).trim();
                        }
                        if (!line.startsWith("Release")) continue;
                        osVersion = line.substring(line.lastIndexOf(":") + 1).trim();
                    }
                }
                osDetails = "&arch=" + URLEncoder.encode(String.valueOf(osName) + " " + osVersion + "@" + osArch, "UTF-8");
            }
        }
        catch (Exception exception) {}
        try {
            InetAddress.getByName(VMWB_ENG_HOST);
            _isVMware = true;
            username = System.getProperty("user.name");
        }
        catch (UnknownHostException unknownHostException) {}
    }

    public static boolean isVMware() {
        return _isVMware;
    }

    public static File getSavedStateFile() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath workspaceDirectory = workspace.getRoot().getLocation();
        IPath statePath = workspaceDirectory.append(".perfData.txt");
        File stateFile = statePath.toFile();
        return stateFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBeacons(File stateFile) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(stateFile)));){
            Map<String, HttpLogCounter> map = logActivities;
            synchronized (map) {
                String b64 = null;
                while ((b64 = br.readLine()) != null) {
                    String line = NetUtils.base64decode(b64);
                    String[] kv = line.split(BEACON_FILE_SEPARATOR);
                    if (kv.length != 2) continue;
                    HttpLogCounter c = new HttpLogCounter();
                    c.nHitsSinceLastSent = Integer.parseInt(kv[1]);
                    logActivities.put(kv[0], c);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBeacons(File stateFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(stateFile));){
            Map<String, HttpLogCounter> map = logActivities;
            synchronized (map) {
                Set<String> keys = logActivities.keySet();
                for (String k : keys) {
                    HttpLogCounter c = logActivities.get(k);
                    StringBuilder line = new StringBuilder(k).append(BEACON_FILE_SEPARATOR).append(c.nHitsSinceLastSent);
                    String b64 = NetUtils.base64encode(line.toString());
                    sb.append(b64).append("\n");
                    c.nHitsSinceLastSent = 0;
                }
                bw.write(sb.toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean getActivityLoggingEnabled() {
        return isActivityLoggingEnabled;
    }

    public static void setActivityLoggingEnabled(boolean enabled) {
        isActivityLoggingEnabled = enabled;
    }

    public static void setUsername(String user) {
        username = user;
    }

    public static void logException(String area, Throwable throwable, String extraString) {
        String extraData = "noCause";
        String exceptionData = "noException";
        if (throwable != null) {
            StackTraceElement rootLocation = throwable.getStackTrace()[0];
            exceptionData = String.valueOf(throwable.getClass().getName()) + " at " + rootLocation.toString();
            Throwable cause = throwable.getCause();
            if (cause != null) {
                StackTraceElement causeLocation = cause.getStackTrace()[0];
                extraData = String.valueOf(cause.getClass().getName()) + " at " + causeLocation.toString();
            } else if (extraString != null) {
                extraData = extraString;
            }
        }
        HttpLogger.logActivity("exception", area, exceptionData, extraData);
    }

    public static void logException(String area, Throwable throwable) {
        HttpLogger.logException(area, throwable, null);
    }

    public static void logTimer(String activity) {
        HttpLogger.logTimer(activity, null, null);
    }

    public static void logTimer(String activity, String programId, String subProgramId) {
        final String beaconId = HttpLogger.getBeaconId(activity, programId, subProgramId, "HeartBeat", null);
        Timer timer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                HttpLogger.sendBeacon(beaconId, 1);
            }
        };
        timer.schedule(task, 0L, 21600000L);
    }

    public static void logActivity(String activity) {
        HttpLogger.logActivity(activity, null, null);
    }

    public static void logActivity(String activity, String programId) {
        HttpLogger.logActivity(activity, programId, null);
    }

    public static void logActivity(String activity, String programId, String subProgramId) {
        HttpLogger.logActivity(activity, programId, subProgramId, null, 21600000L);
    }

    public static void logActivity(String activity, String programId, String subProgramId, String task) {
        HttpLogger.logActivity(activity, programId, subProgramId, task, null, 21600000L);
    }

    public static void logActivity(String activity, String programId, String subProgramId, String proxyIp, long beaconCheckMilliseconds) {
        HttpLogger.logActivity(activity, programId, subProgramId, null, proxyIp, beaconCheckMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logActivity(String wbComponent, String programId, String subProgramId, String task, String proxyIp, long beaconCheckMilliseconds) {
        final String beaconId = HttpLogger.getBeaconId(wbComponent, programId, subProgramId, proxyIp, task);
        int hitCounter = 1;
        if (beaconCheckMilliseconds > 0L) {
            long currentTime = Calendar.getInstance().getTime().getTime();
            Map<String, HttpLogCounter> map = logActivities;
            synchronized (map) {
                HttpLogCounter counter = logActivities.get(beaconId);
                if (counter != null) {
                    ++counter.nHitsSinceLastSent;
                    long lastTime = counter.timeLastSent;
                    if (currentTime - lastTime < beaconCheckMilliseconds) {
                        return;
                    }
                } else {
                    counter = new HttpLogCounter();
                    logActivities.put(beaconId, counter);
                }
                hitCounter += counter.nHitsSinceLastSent;
                counter.nHitsSinceLastSent = 0;
                counter.timeLastSent = currentTime;
            }
        }
        final int nHits = hitCounter;
        Runnable logger = new Runnable(){

            @Override
            public void run() {
                HttpLogger.sendBeacon(beaconId, nHits);
            }
        };
        new Thread(logger).start();
    }

    public static String getBeaconId(String wbComponent, String programId, String subProgramId, String proxyIp, String task) {
        StringBuilder id = new StringBuilder(wbComponent).append(".php");
        IProduct product = Platform.getProduct();
        String productName = product != null ? product.getName() : System.getProperty("eclipse.product");
        if (productName == null) {
            productName = "";
        }
        String version = null;
        Bundle bundle = Platform.getBundle((String)"com.vmware.vide.utils");
        if (bundle != null) {
            version = bundle.getVersion().toString();
        }
        try {
            String anonymousID;
            id.append("?productId=");
            id.append(URLEncoder.encode(productName, "UTF-8"));
            if (programId != null && !programId.isEmpty()) {
                id.append("&programId=");
                id.append(URLEncoder.encode(programId, "UTF-8"));
            }
            if (subProgramId != null && !subProgramId.isEmpty()) {
                id.append("&subId=");
                id.append(URLEncoder.encode(subProgramId, "UTF-8"));
            }
            if (task != null && !task.isEmpty()) {
                id.append("&task=");
                id.append(URLEncoder.encode(task, "UTF-8"));
            }
            if (proxyIp != null && !proxyIp.isEmpty()) {
                id.append("&proxyIp=");
                id.append(URLEncoder.encode(proxyIp, "UTF-8"));
            }
            if (version != null && !version.isEmpty()) {
                id.append("&version=");
                id.append(URLEncoder.encode(version, "UTF-8"));
            }
            if (osDetails != null) {
                id.append(osDetails);
            }
            if (javaDetails != null) {
                id.append(javaDetails);
            }
            if ((anonymousID = HttpLogger.getAnonymousId()) != null) {
                id.append("&anonymousID=");
                id.append(URLEncoder.encode(anonymousID, "UTF-8"));
            }
        }
        catch (Exception exception) {}
        return id.toString();
    }

    private static void sendBeacon(String beaconId, int nHits) {
        StringBuilder url = new StringBuilder(_isVMware ? VMWB_ENG_URL : PART_WEB_URL);
        url.append(beaconId);
        try {
            url.append("&cnt=").append(nHits);
            if (_isVMware && username != null && !username.isEmpty()) {
                url.append("&username=");
                url.append(URLEncoder.encode(username, "UTF-8"));
            }
            NetworkHelper.getFromURL(url.toString());
        }
        catch (Exception exception) {
            HttpLogger.updateBeaconCounter(beaconId, nHits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateBeaconCounter(String key, int nHits) {
        Map<String, HttpLogCounter> map = logActivities;
        synchronized (map) {
            HttpLogCounter counter = logActivities.get(key);
            if (counter == null) {
                counter = new HttpLogCounter();
                logActivities.put(key, counter);
            }
            counter.nHitsSinceLastSent += nHits;
        }
    }

    public static String getAnonymousId() {
        if (anonymousId == null) {
            anonymousId = HttpLogger.calculateAnonymousId();
        }
        return anonymousId;
    }

    private static String calculateAnonymousId() {
        String id = null;
        try {
            InetAddress ip;
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks != null && networks.hasMoreElements()) {
                NetworkInterface networkInterface = networks.nextElement();
                byte[] address = networkInterface.getHardwareAddress();
                if (address == null || address.length <= 0) continue;
                StringBuilder macAddress = new StringBuilder();
                int i = 0;
                while (i < address.length) {
                    macAddress.append(String.format("%02X%s", address[i], i < address.length - 1 ? ":" : ""));
                    ++i;
                }
                if (!HttpLogger.isValid(macAddress.toString())) continue;
                id = HttpLogger.getMD5Hash(macAddress.toString());
                break;
            }
            if (id == null && (ip = InetAddress.getLocalHost()) != null && !ip.isLoopbackAddress()) {
                id = HttpLogger.getMD5Hash(ip.toString());
            }
        }
        catch (Exception exception) {}
        return id;
    }

    private static boolean isValid(String macAddress) {
        List<String> invalidMACAddress = Arrays.asList("00:00:00:00:00:E0", "00:00:00:00:00:00:00:E0");
        return !invalidMACAddress.contains(macAddress);
    }

    private static String getMD5Hash(String address) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(address.getBytes());
        byte[] byteData = md.digest();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < byteData.length) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }
}

